/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBScrollBar;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalStarter;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.JediTerminal;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.ui.JediTermWidget;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.JBTabbedTerminalWidget;
import org.jetbrains.plugins.terminal.JBTerminalPanel;
import org.jetbrains.plugins.terminal.JBTerminalStarter;
import org.jetbrains.plugins.terminal.JBTerminalSystemSettingsProvider;

public class JBTerminalWidget
extends JediTermWidget
implements Disposable {
    public JBTerminalWidget(JBTerminalSystemSettingsProvider settingsProvider, Disposable parent) {
        super((SettingsProvider)settingsProvider);
        JBTabbedTerminalWidget.convertActions((JComponent)((Object)this), this.getActions());
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    protected JBTerminalPanel createTerminalPanel(@NotNull SettingsProvider settingsProvider, @NotNull StyleState styleState, @NotNull TerminalTextBuffer textBuffer) {
        if (settingsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/terminal/JBTerminalWidget", "createTerminalPanel"));
        }
        if (styleState == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/terminal/JBTerminalWidget", "createTerminalPanel"));
        }
        if (textBuffer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/terminal/JBTerminalWidget", "createTerminalPanel"));
        }
        JBTerminalPanel panel = new JBTerminalPanel((JBTerminalSystemSettingsProvider)settingsProvider, textBuffer, styleState);
        Disposer.register((Disposable)this, (Disposable)panel);
        return panel;
    }

    protected TerminalStarter createTerminalStarter(JediTerminal terminal, TtyConnector connector) {
        return new JBTerminalStarter((Terminal)terminal, connector);
    }

    protected JScrollBar createScrollBar() {
        return new JBScrollBar();
    }

    public void dispose() {
    }
}

