/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui.model;

import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.ui.BaseTestProxyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;

class TestProxyDescriptor
extends BaseTestProxyNodeDescriptor<TestProxy> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.junit2.ui.model.TestProxyDescriptor");
    private static final int STATE_UP_TO_DATE = 0;
    private static final int STATE_OUT_OF_DATE = 1;
    private static final int STATE_UNKNOWN = 2;
    private int myTimestamp = -1;
    private int myLastChildCount = -1;
    private int myLastMagnitude = -1;

    public TestProxyDescriptor(Project project, NodeDescriptor parentDescriptor, TestProxy test) {
        super(project, (AbstractTestProxy)test, parentDescriptor);
        this.myTimestamp = test.getStateTimestamp();
        this.myLastChildCount = test.getChildCount();
        this.myName = test.toString();
    }

    public boolean update() {
        TestProxy test = (TestProxy)this.getElement();
        boolean needsUpdate = this.checkNeedsUpdate(test);
        this.myTimestamp = test.getStateTimestamp();
        this.myLastChildCount = test.getChildCount();
        return needsUpdate;
    }

    private boolean checkNeedsUpdate(TestProxy test) {
        int needsUpdate = 0;
        if (test.getChildCount() != this.myLastChildCount) {
            needsUpdate = 1;
        } else if (test.getStateTimestamp() != this.myTimestamp) {
            needsUpdate = 2;
        }
        if (needsUpdate == 2) {
            int magnitude = test.getState().getMagnitude();
            needsUpdate = magnitude == this.myLastMagnitude ? 0 : 1;
            this.myLastMagnitude = magnitude;
        }
        if (needsUpdate == 0) {
            return false;
        }
        if (needsUpdate == 1) {
            return true;
        }
        LOG.error(String.valueOf(needsUpdate));
        return true;
    }
}

