/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.inspection;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.reference.EntryPoint;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class JUnitEntryPoint
extends EntryPoint {
    public boolean ADD_JUNIT_TO_ENTRIES = true;

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.dead.code.option2", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit2/inspection/JUnitEntryPoint", "getDisplayName"));
        }
        return string;
    }

    public boolean isEntryPoint(@NotNull RefElement refElement, @NotNull PsiElement psiElement) {
        if (refElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/junit2/inspection/JUnitEntryPoint", "isEntryPoint"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/junit2/inspection/JUnitEntryPoint", "isEntryPoint"));
        }
        return this.isEntryPoint(psiElement);
    }

    public boolean isEntryPoint(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/junit2/inspection/JUnitEntryPoint", "isEntryPoint"));
        }
        if (this.ADD_JUNIT_TO_ENTRIES) {
            if (psiElement instanceof PsiClass) {
                PsiClass aClass = (PsiClass)psiElement;
                if (JUnitUtil.isTestClass((PsiClass)aClass, (boolean)false, (boolean)true)) {
                    if (!PsiClassUtil.isRunnableClass((PsiClass)aClass, (boolean)true, (boolean)true)) {
                        CommonProcessors.FindProcessor<PsiClass> findProcessor = new CommonProcessors.FindProcessor<PsiClass>(){

                            protected boolean accept(PsiClass psiClass) {
                                return !psiClass.hasModifierProperty("abstract");
                            }
                        };
                        return !ClassInheritorsSearch.search((PsiClass)aClass).forEach((Processor)findProcessor) && findProcessor.isFound();
                    }
                    return true;
                }
            } else if (psiElement instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)psiElement;
                if (method.isConstructor() && method.getParameterList().getParametersCount() == 0) {
                    return JUnitUtil.isTestClass((PsiClass)method.getContainingClass());
                }
                if (JUnitUtil.isTestMethodOrConfig((PsiMethod)method)) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isSelected() {
        return this.ADD_JUNIT_TO_ENTRIES;
    }

    public void setSelected(boolean selected) {
        this.ADD_JUNIT_TO_ENTRIES = selected;
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        if (!this.ADD_JUNIT_TO_ENTRIES) {
            DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
        }
    }

    public String[] getIgnoreAnnotations() {
        return new String[]{"org.junit.Rule", "org.mockito.Mock", "org.mockito.Spy", "org.mockito.Captor", "org.mockito.InjectMocks", "org.junit.ClassRule", "org.junit.experimental.theories.DataPoint"};
    }
}

