/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.execution.configurations.ConfigurationUtil;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.ide.util.ClassFilter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class TestClassFilter
implements ClassFilter.ClassFilterWithScope {
    private final PsiClass myBase;
    private final Project myProject;
    private final GlobalSearchScope myScope;

    private TestClassFilter(@NotNull PsiClass base, GlobalSearchScope scope) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/junit/TestClassFilter", "<init>"));
        }
        this.myBase = base;
        this.myProject = base.getProject();
        this.myScope = scope;
    }

    public PsiManager getPsiManager() {
        return PsiManager.getInstance((Project)this.myProject);
    }

    public Project getProject() {
        return this.myProject;
    }

    public boolean isAccepted(final PsiClass aClass) {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                if (aClass.getQualifiedName() != null && ConfigurationUtil.PUBLIC_INSTANTIATABLE_CLASS.value((Object)aClass) && (aClass.isInheritor(TestClassFilter.this.myBase, true) || JUnitUtil.isTestClass((PsiClass)aClass))) {
                    CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)TestClassFilter.this.getProject());
                    VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)aClass);
                    if (virtualFile == null) {
                        return false;
                    }
                    return !compilerConfiguration.isExcludedFromCompilation(virtualFile) && !ProjectRootManager.getInstance((Project)TestClassFilter.this.myProject).getFileIndex().isUnderSourceRootOfType(virtualFile, JavaModuleSourceRootTypes.RESOURCES);
                }
                return false;
            }
        });
    }

    public TestClassFilter intersectionWith(GlobalSearchScope scope) {
        return new TestClassFilter(this.myBase, this.myScope.intersectWith(scope));
    }

    public static TestClassFilter create(SourceScope sourceScope, Module module) throws JUnitUtil.NoJUnitException {
        if (sourceScope == null) {
            throw new JUnitUtil.NoJUnitException();
        }
        PsiClass testCase = module == null ? JUnitUtil.getTestCaseClass((SourceScope)sourceScope) : JUnitUtil.getTestCaseClass((Module)module);
        return new TestClassFilter(testCase, sourceScope.getGlobalSearchScope());
    }

    public static TestClassFilter create(SourceScope sourceScope, Module module, String pattern) throws JUnitUtil.NoJUnitException {
        if (sourceScope == null) {
            throw new JUnitUtil.NoJUnitException();
        }
        PsiClass testCase = module == null ? JUnitUtil.getTestCaseClass((SourceScope)sourceScope) : JUnitUtil.getTestCaseClass((Module)module);
        String[] patterns = pattern.split("\\|\\|");
        final ArrayList<Pattern> compilePatterns = new ArrayList<Pattern>();
        for (String p : patterns) {
            Pattern compilePattern = TestClassFilter.getCompilePattern(p);
            if (compilePattern == null) continue;
            compilePatterns.add(compilePattern);
        }
        return new TestClassFilter(testCase, sourceScope.getGlobalSearchScope()){

            @Override
            public boolean isAccepted(final PsiClass aClass) {
                if (super.isAccepted(aClass)) {
                    String qualifiedName = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                        public String compute() {
                            return aClass.getQualifiedName();
                        }
                    });
                    for (Pattern compilePattern : compilePatterns) {
                        if (!compilePattern.matcher(qualifiedName).matches()) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    private static Pattern getCompilePattern(String pattern) {
        Pattern compilePattern;
        try {
            compilePattern = Pattern.compile(pattern.trim());
        }
        catch (PatternSyntaxException e) {
            compilePattern = null;
        }
        return compilePattern;
    }

    public GlobalSearchScope getScope() {
        return this.myScope;
    }

    public PsiClass getBase() {
        return this.myBase;
    }
}

