/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.PatternConfigurationProducer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class AddToTestsPatternAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Project project;
        DataContext dataContext = e.getDataContext();
        PsiElement[] psiElements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        final Set<PsiElement> classes = PatternConfigurationProducer.collectTestMembers(psiElements, true);
        List<JUnitConfiguration> patternConfigurations = AddToTestsPatternAction.collectPatternConfigurations(classes, project = (Project)CommonDataKeys.PROJECT.getData(dataContext));
        if (patternConfigurations.size() == 1) {
            JUnitConfiguration configuration = patternConfigurations.get(0);
            for (PsiElement aClass : classes) {
                configuration.getPersistentData().getPatterns().add(PatternConfigurationProducer.getQName(aClass));
            }
        } else {
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<JUnitConfiguration>("Choose suite to add", patternConfigurations){

                public PopupStep onChosen(JUnitConfiguration configuration, boolean finalChoice) {
                    for (PsiElement aClass : classes) {
                        configuration.getPersistentData().getPatterns().add(PatternConfigurationProducer.getQName(aClass));
                    }
                    return FINAL_CHOICE;
                }

                public Icon getIconFor(JUnitConfiguration configuration) {
                    return configuration.getIcon();
                }

                @NotNull
                public String getTextFor(JUnitConfiguration value) {
                    String string = value.getName();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/AddToTestsPatternAction$1", "getTextFor"));
                    }
                    return string;
                }
            }).showInBestPositionFor(dataContext);
        }
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setVisible(false);
        DataContext dataContext = e.getDataContext();
        PsiElement[] psiElements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        if (psiElements != null) {
            List<JUnitConfiguration> foundConfigurations;
            Set<PsiElement> foundMembers = PatternConfigurationProducer.collectTestMembers(psiElements, true);
            if (foundMembers.isEmpty()) {
                return;
            }
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project != null && !(foundConfigurations = AddToTestsPatternAction.collectPatternConfigurations(foundMembers, project)).isEmpty()) {
                presentation.setVisible(true);
                if (foundConfigurations.size() == 1) {
                    presentation.setText("Add to temp suite: " + foundConfigurations.get(0).getName());
                }
            }
        }
    }

    private static List<JUnitConfiguration> collectPatternConfigurations(Set<PsiElement> foundClasses, Project project) {
        List configurations = RunManager.getInstance((Project)project).getConfigurationsList((ConfigurationType)JUnitConfigurationType.getInstance());
        ArrayList<JUnitConfiguration> foundConfigurations = new ArrayList<JUnitConfiguration>();
        for (RunConfiguration configuration : configurations) {
            JUnitConfiguration.Data data = ((JUnitConfiguration)configuration).getPersistentData();
            if (data.TEST_OBJECT != "pattern" || foundClasses.size() <= 1 && data.getPatterns().contains(PatternConfigurationProducer.getQName(foundClasses.iterator().next()))) continue;
            foundConfigurations.add((JUnitConfiguration)configuration);
        }
        return foundConfigurations;
    }
}

