/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.commander;

import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.ide.TwoPaneIdeView;
import com.intellij.ide.commander.AbstractListBuilder;
import com.intellij.ide.commander.CommanderHistory;
import com.intellij.ide.commander.CommanderHistoryListener;
import com.intellij.ide.commander.CommanderPanel;
import com.intellij.ide.commander.ProjectListBuilder;
import com.intellij.ide.commander.PsiDiffContentFactory;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.AbstractProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diff.actions.CompareFiles;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.AutoScrollToSourceHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

@State(name="Commander", storages={@Storage(file="$WORKSPACE_FILE$")})
public class Commander
extends JPanel
implements PersistentStateComponent<Element>,
DataProvider,
TwoPaneIdeView,
Disposable {
    private final Project myProject;
    private CommanderPanel myLeftPanel;
    private CommanderPanel myRightPanel;
    private final Splitter mySplitter;
    private final ListSelectionListener mySelectionListener;
    private final ListDataListener myListDataListener;
    public boolean MOVE_FOCUS = true;
    private Element myElement;
    private final FocusWatcher myFocusWatcher;
    private final CommanderHistory myHistory;
    private boolean myAutoScrollMode;
    private final ToolWindowManager myToolWindowManager;
    @NonNls
    private static final String ACTION_BACKCOMMAND = "backCommand";
    @NonNls
    private static final String ACTION_FORWARDCOMMAND = "forwardCommand";
    @NonNls
    private static final String ELEMENT_LEFTPANEL = "leftPanel";
    @NonNls
    private static final String ATTRIBUTE_MOVE_FOCUS = "MOVE_FOCUS";
    @NonNls
    private static final String ELEMENT_OPTION = "OPTION";
    @NonNls
    private static final String ATTRIBUTE_PROPORTION = "proportion";
    @NonNls
    private static final String ELEMENT_SPLITTER = "splitter";
    @NonNls
    private static final String ELEMENT_RIGHTPANEL = "rightPanel";
    @NonNls
    private static final String ATTRIBUTE_URL = "url";
    @NonNls
    private static final String ATTRIBUTE_CLASS = "class";

    public Commander(Project project, KeymapManager keymapManager) {
        this(project, keymapManager, null);
    }

    public Commander(Project project, KeymapManager keymapManager, ToolWindowManager toolWindowManager) {
        super(new BorderLayout());
        boolean shouldAddToolbar;
        KeyStroke[] fwdStrokes;
        KeyStroke[] backStrokes;
        this.myProject = project;
        this.myToolWindowManager = toolWindowManager;
        AbstractAction backAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Commander.this.myHistory.back();
            }
        };
        AbstractAction fwdAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Commander.this.myHistory.forward();
            }
        };
        ActionMap actionMap = this.getActionMap();
        actionMap.put(ACTION_BACKCOMMAND, backAction);
        actionMap.put(ACTION_FORWARDCOMMAND, fwdAction);
        for (KeyStroke stroke : backStrokes = Commander.getKeyStrokes("Back", keymapManager)) {
            this.registerKeyboardAction(backAction, ACTION_BACKCOMMAND, stroke, 2);
            this.registerKeyboardAction(backAction, ACTION_BACKCOMMAND, stroke, 1);
        }
        for (KeyStroke stroke : fwdStrokes = Commander.getKeyStrokes("Forward", keymapManager)) {
            this.registerKeyboardAction(fwdAction, ACTION_FORWARDCOMMAND, stroke, 2);
            this.registerKeyboardAction(fwdAction, ACTION_FORWARDCOMMAND, stroke, 1);
        }
        this.myHistory = new CommanderHistory(this);
        this.mySelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Commander.this.updateToolWindowTitle();
            }
        };
        this.myListDataListener = new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                Commander.this.updateToolWindowTitle();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                Commander.this.updateToolWindowTitle();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                Commander.this.updateToolWindowTitle();
            }
        };
        this.myFocusWatcher = new FocusWatcher();
        this.myLeftPanel = this.createPanel();
        this.myLeftPanel.addHistoryListener(new CommanderHistoryListener(){

            public void historyChanged(PsiElement selectedElement, boolean elementExpanded) {
                Commander.this.getCommandHistory().saveState(selectedElement, elementExpanded, true);
            }
        });
        this.myRightPanel = this.createPanel();
        this.myRightPanel.addHistoryListener(new CommanderHistoryListener(){

            public void historyChanged(PsiElement selectedElement, boolean elementExpanded) {
                Commander.this.getCommandHistory().saveState(selectedElement, elementExpanded, false);
            }
        });
        this.mySplitter = new Splitter();
        this.mySplitter.setFirstComponent((JComponent)this.myLeftPanel);
        this.mySplitter.setSecondComponent((JComponent)this.myRightPanel);
        this.add((Component)this.mySplitter, "Center");
        AutoScrollToSourceHandler handler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return Commander.this.myAutoScrollMode;
            }

            protected void setAutoScrollMode(boolean state) {
                Commander.this.myAutoScrollMode = state;
            }
        };
        handler.install(this.myLeftPanel.getList());
        handler.install(this.myRightPanel.getList());
        boolean bl = shouldAddToolbar = !ApplicationManager.getApplication().isUnitTestMode();
        if (shouldAddToolbar) {
            DefaultActionGroup toolbarActions = this.createToolbarActions();
            toolbarActions.add((AnAction)handler.createToggleAction());
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("CommanderToolbar", (ActionGroup)toolbarActions, true);
            this.add((Component)toolbar.getComponent(), "North");
        }
        this.myFocusWatcher.install((Component)this);
    }

    public static Commander getInstance(Project project) {
        return (Commander)ServiceManager.getService((Project)project, Commander.class);
    }

    public CommanderHistory getCommandHistory() {
        return this.myHistory;
    }

    private void processConfigurationElement() {
        String attribute;
        PsiElement parentElement;
        if (this.myElement == null) {
            return;
        }
        Element element = this.myElement.getChild(ELEMENT_LEFTPANEL);
        if (element != null && (parentElement = this.readParentElement(element)) != null) {
            this.myLeftPanel.getBuilder().enterElement(parentElement, PsiUtilCore.getVirtualFile((PsiElement)parentElement));
        }
        if ((element = this.myElement.getChild(ELEMENT_RIGHTPANEL)) != null && (parentElement = this.readParentElement(element)) != null) {
            this.myRightPanel.getBuilder().enterElement(parentElement, PsiUtilCore.getVirtualFile((PsiElement)parentElement));
        }
        if ((element = this.myElement.getChild(ELEMENT_SPLITTER)) != null && (attribute = element.getAttributeValue(ATTRIBUTE_PROPORTION)) != null) {
            try {
                float proportion = Float.valueOf(attribute).floatValue();
                if (proportion >= 0.0f && proportion <= 1.0f) {
                    this.mySplitter.setProportion(proportion);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((element = this.myElement.getChild(ELEMENT_OPTION)) != null) {
            this.MOVE_FOCUS = !"false".equals(element.getAttributeValue(ATTRIBUTE_MOVE_FOCUS));
        }
        this.myLeftPanel.setActive(false);
        this.myRightPanel.setActive(false);
        this.myLeftPanel.setMoveFocus(this.MOVE_FOCUS);
        this.myRightPanel.setMoveFocus(this.MOVE_FOCUS);
        this.myElement = null;
    }

    private static KeyStroke[] getKeyStrokes(String actionId, KeymapManager keymapManager) {
        Shortcut[] shortcuts = keymapManager.getActiveKeymap().getShortcuts(actionId);
        ArrayList<KeyStroke> strokes = new ArrayList<KeyStroke>();
        for (Shortcut shortcut : shortcuts) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            strokes.add(((KeyboardShortcut)shortcut).getFirstKeyStroke());
        }
        return strokes.toArray(new KeyStroke[strokes.size()]);
    }

    private DefaultActionGroup createToolbarActions() {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup group = new DefaultActionGroup();
        AnAction backAction = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                Commander.this.myHistory.back();
            }

            public void update(AnActionEvent e) {
                super.update(e);
                e.getPresentation().setEnabled(Commander.this.myHistory.canGoBack());
            }
        };
        backAction.copyFrom(actionManager.getAction("Back"));
        group.add(backAction);
        AnAction forwardAction = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                Commander.this.myHistory.forward();
            }

            public void update(AnActionEvent e) {
                super.update(e);
                e.getPresentation().setEnabled(Commander.this.myHistory.canGoForward());
            }
        };
        forwardAction.copyFrom(actionManager.getAction("Forward"));
        group.add(forwardAction);
        group.add(actionManager.getAction("CommanderSwapPanels"));
        group.add(actionManager.getAction("CommanderSyncViews"));
        return group;
    }

    private CommanderPanel createPanel() {
        final CommanderPanel panel = new CommanderPanel(this.myProject, true, false);
        panel.getList().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (27 == e.getKeyCode()) {
                    boolean[] isCopied;
                    if (e.isConsumed()) {
                        return;
                    }
                    PsiCopyPasteManager copyPasteManager = PsiCopyPasteManager.getInstance();
                    if (copyPasteManager.getElements(isCopied = new boolean[1]) != null && !isCopied[0]) {
                        copyPasteManager.clear();
                        e.consume();
                    }
                }
            }
        });
        AbstractProjectTreeStructure treeStructure = this.createProjectTreeStructure();
        panel.setBuilder((AbstractListBuilder)new ProjectListBuilder(this.myProject, panel, (AbstractTreeStructure)treeStructure, (Comparator)AlphaComparator.INSTANCE, true));
        panel.setProjectTreeStructure((ProjectAbstractTreeStructureBase)treeStructure);
        final FocusAdapter focusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                Commander.this.updateToolWindowTitle(panel);
            }
        };
        final JList list = panel.getList();
        list.addFocusListener(focusListener);
        list.getSelectionModel().addListSelectionListener(this.mySelectionListener);
        list.getModel().addListDataListener(this.myListDataListener);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                list.removeFocusListener(focusListener);
                list.getSelectionModel().removeListSelectionListener(Commander.this.mySelectionListener);
                list.getModel().removeListDataListener(Commander.this.myListDataListener);
            }
        });
        return panel;
    }

    protected AbstractProjectTreeStructure createProjectTreeStructure() {
        return new AbstractProjectTreeStructure(this.myProject){

            public boolean isShowMembers() {
                return true;
            }

            public boolean isHideEmptyMiddlePackages() {
                return false;
            }

            public boolean isFlattenPackages() {
                return false;
            }

            public boolean isAbbreviatePackageNames() {
                return false;
            }

            public boolean isShowLibraryContents() {
                return false;
            }

            public boolean isShowModules() {
                return false;
            }
        };
    }

    private void updateToolWindowTitle() {
        CommanderPanel panel = this.getActivePanel();
        this.updateToolWindowTitle(panel);
    }

    protected void updateToolWindowTitle(CommanderPanel activePanel) {
        AbstractTreeNode node;
        ToolWindow toolWindow = this.myToolWindowManager.getToolWindow(ToolWindowId.COMMANDER);
        if (toolWindow != null && (node = activePanel.getSelectedNode()) instanceof ProjectViewNode) {
            toolWindow.setTitle(((ProjectViewNode)node).getTitle());
        }
    }

    public boolean isLeftPanelActive() {
        return this.isPanelActive(this.myLeftPanel);
    }

    boolean isPanelActive(CommanderPanel panel) {
        return panel.getList() == this.myFocusWatcher.getFocusedComponent();
    }

    public void selectElementInLeftPanel(Object element, VirtualFile virtualFile) {
        this.myLeftPanel.getBuilder().selectElement(element, virtualFile);
        if (!this.isPanelActive(this.myLeftPanel)) {
            this.switchActivePanel();
        }
    }

    public void selectElementInRightPanel(Object element, VirtualFile virtualFile) {
        this.myRightPanel.getBuilder().selectElement(element, virtualFile);
        if (!this.isPanelActive(this.myRightPanel)) {
            this.switchActivePanel();
        }
    }

    public void switchActivePanel() {
        CommanderPanel activePanel = this.getActivePanel();
        CommanderPanel inactivePanel = this.getInactivePanel();
        inactivePanel.setActive(true);
        activePanel.setActive(false);
        IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)inactivePanel).requestFocus();
    }

    public void enterElementInActivePanel(PsiElement element) {
        CommanderPanel activePanel = this.isLeftPanelActive() ? this.myLeftPanel : this.myRightPanel;
        activePanel.getBuilder().enterElement(element, PsiUtilCore.getVirtualFile((PsiElement)element));
    }

    public void swapPanels() {
        this.mySplitter.swapComponents();
        CommanderPanel tmpPanel = this.myLeftPanel;
        this.myLeftPanel = this.myRightPanel;
        this.myRightPanel = tmpPanel;
    }

    public void syncViews() {
        CommanderPanel passivePanel;
        CommanderPanel activePanel;
        if (this.isLeftPanelActive()) {
            activePanel = this.myLeftPanel;
            passivePanel = this.myRightPanel;
        } else {
            activePanel = this.myRightPanel;
            passivePanel = this.myLeftPanel;
        }
        ProjectViewNode element = (ProjectViewNode)activePanel.getBuilder().getParentNode();
        passivePanel.getBuilder().enterElement((AbstractTreeNode)element);
    }

    public CommanderPanel getActivePanel() {
        return this.isLeftPanelActive() ? this.myLeftPanel : this.myRightPanel;
    }

    public CommanderPanel getInactivePanel() {
        return !this.isLeftPanelActive() ? this.myLeftPanel : this.myRightPanel;
    }

    public Object getData(String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "viewingStructure.commander";
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (LangDataKeys.TARGET_PSI_ELEMENT.is(dataId)) {
            AbstractTreeNode parentElement = this.getInactivePanel().getBuilder().getParentNode();
            if (parentElement == null) {
                return null;
            }
            Object element = parentElement.getValue();
            return element instanceof PsiElement && ((PsiElement)element).isValid() ? element : null;
        }
        if (CompareFiles.DIFF_REQUEST.is(dataId)) {
            PsiElement primary = this.getActivePanel().getSelectedElement();
            PsiElement secondary = this.getInactivePanel().getSelectedElement();
            if (primary != null && secondary != null && primary.isValid() && secondary.isValid() && !PsiTreeUtil.isAncestor((PsiElement)primary, (PsiElement)secondary, (boolean)false) && !PsiTreeUtil.isAncestor((PsiElement)secondary, (PsiElement)primary, (boolean)false)) {
                return PsiDiffContentFactory.comparePsiElements(primary, secondary);
            }
            return null;
        }
        return this.getActivePanel().getDataImpl(dataId);
    }

    public Element getState() {
        Element element = new Element("commander");
        if (this.myLeftPanel == null || this.myRightPanel == null) {
            return element;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        Element e = new Element(ELEMENT_LEFTPANEL);
        element.addContent(e);
        Commander.writePanel(this.myLeftPanel, e);
        e = new Element(ELEMENT_RIGHTPANEL);
        element.addContent(e);
        Commander.writePanel(this.myRightPanel, e);
        e = new Element(ELEMENT_SPLITTER);
        element.addContent(e);
        e.setAttribute(ATTRIBUTE_PROPORTION, Float.toString(this.mySplitter.getProportion()));
        if (!this.MOVE_FOCUS) {
            e = new Element(ELEMENT_OPTION);
            element.addContent(e);
            e.setAttribute(ATTRIBUTE_MOVE_FOCUS, "false");
        }
        return element;
    }

    private static void writePanel(CommanderPanel panel, Element element) {
        Object parentElement;
        AbstractListBuilder builder = panel.getBuilder();
        if (builder == null) {
            return;
        }
        AbstractTreeNode parentNode = builder.getParentNode();
        Object object = parentElement = parentNode != null ? parentNode.getValue() : null;
        if (parentElement instanceof PsiDirectory) {
            PsiDirectory directory = (PsiDirectory)parentElement;
            element.setAttribute(ATTRIBUTE_URL, directory.getVirtualFile().getUrl());
        } else if (parentElement instanceof PsiClass) {
            for (PsiElement e = (PsiElement)parentElement; e != null && e.isValid(); e = e.getParent()) {
                String qualifiedName;
                if (!(e instanceof PsiClass) || (qualifiedName = ((PsiClass)e).getQualifiedName()) == null) continue;
                element.setAttribute(ATTRIBUTE_CLASS, qualifiedName);
                break;
            }
        }
    }

    public void loadState(Element state) {
        this.myElement = state;
        this.processConfigurationElement();
        this.myElement = null;
    }

    private PsiElement readParentElement(Element element) {
        if (element.getAttributeValue(ATTRIBUTE_URL) != null) {
            String url = element.getAttributeValue(ATTRIBUTE_URL);
            VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
            return file != null ? PsiManager.getInstance((Project)this.myProject).findDirectory(file) : null;
        }
        if (element.getAttributeValue(ATTRIBUTE_CLASS) != null) {
            String className = element.getAttributeValue(ATTRIBUTE_CLASS);
            return className != null ? JavaPsiFacade.getInstance((Project)this.myProject).findClass(className, GlobalSearchScope.allScope((Project)this.myProject)) : null;
        }
        return null;
    }

    public void dispose() {
        if (this.myLeftPanel == null) {
            return;
        }
        this.myLeftPanel.dispose();
        this.myRightPanel.dispose();
        this.myHistory.clearHistory();
    }

    public CommanderPanel getRightPanel() {
        return this.myRightPanel;
    }

    public CommanderPanel getLeftPanel() {
        return this.myLeftPanel;
    }

    public void selectElement(PsiElement element, boolean selectInActivePanel) {
        CommanderPanel panel = selectInActivePanel ? this.getActivePanel() : this.getInactivePanel();
        panel.getBuilder().selectElement((Object)element, PsiUtilCore.getVirtualFile((PsiElement)element));
    }
}

