/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class CvsVfsUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.util.CvsVfsUtil");

    public static VirtualFile findFileByPath(String path) {
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    public static VirtualFile findChild(VirtualFile file, String name) {
        if (file == null) {
            return LocalFileSystem.getInstance().findFileByIoFile(new File(name));
        }
        return file.findChild(name);
    }

    public static VirtualFile getParentFor(File file) {
        return CvsVfsUtil.findFileByIoFile(file.getParentFile());
    }

    public static File getFileFor(VirtualFile file) {
        if (file == null) {
            return null;
        }
        return new File(file.getPath());
    }

    public static File getFileFor(VirtualFile parent, String name) {
        if (parent == null) {
            return new File(name);
        }
        return new File(parent.getPath(), name);
    }

    public static VirtualFile findFileByIoFile(File file) {
        if (file == null) {
            return null;
        }
        return LocalFileSystem.getInstance().findFileByIoFile(file);
    }

    public static VirtualFile refreshAndFindFileByIoFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/cvsSupport2/util/CvsVfsUtil", "refreshAndFindFileByIoFile"));
        }
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
    }

    public static VirtualFile[] getChildrenOf(VirtualFile directory) {
        return directory.isValid() ? directory.getChildren() : null;
    }

    public static long getTimeStamp(VirtualFile file) {
        return file.getTimeStamp();
    }

    public static boolean isWritable(VirtualFile virtualFile) {
        return virtualFile.isWritable();
    }

    public static String getPresentablePathFor(VirtualFile root) {
        return root.getPresentableUrl();
    }

    public static VirtualFile refreshAndfFindChild(VirtualFile parent, String fileName) {
        return CvsVfsUtil.refreshAndFindFileByIoFile(new File(CvsVfsUtil.getFileFor(parent), fileName));
    }
}

