/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.ui.experts.importToCvs;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.cvsIgnore.IgnoredFilesInfo;
import com.intellij.cvsSupport2.cvsIgnore.IgnoredFilesInfoImpl;
import com.intellij.cvsSupport2.ui.experts.CvsWizard;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.file.AbstractFileObject;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;
import org.netbeans.lib.cvsclient.util.IIgnoreFileFilter;

public class ImportTree
extends NodeRenderer {
    private final Collection<VirtualFile> myExcludedFiles = new HashSet();
    private final Collection<VirtualFile> myIncludedFiles = new HashSet();
    private final Project myProject;
    private final FileSystemTree myFileSystemTree;
    private final CvsWizard myWizard;

    public ImportTree(@Nullable Project project, FileSystemTree fileSystemTree, CvsWizard wizard) {
        this.myProject = project;
        this.myFileSystemTree = fileSystemTree;
        this.myWizard = wizard;
    }

    public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (this.customize(tree, value, selected, expanded, leaf, row, hasFocus)) {
            return;
        }
        super.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
    }

    private boolean customize(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (!(value instanceof DefaultMutableTreeNode)) {
            return false;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObject = node.getUserObject();
        if (!(userObject instanceof NodeDescriptor)) {
            return false;
        }
        NodeDescriptor descriptor = (NodeDescriptor)userObject;
        Object element = descriptor.getElement();
        if (!(element instanceof FileElement)) {
            return false;
        }
        FileElement fileElement = (FileElement)element;
        if (!this.isExcluded(fileElement)) {
            return false;
        }
        this.setIcon(IconLoader.getDisabledIcon((Icon)descriptor.getIcon()));
        String text = tree.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
        this.append(text, new SimpleTextAttributes(4, tree.getForeground()));
        return true;
    }

    public AnAction createExcludeAction() {
        return new AnAction(CvsBundle.message((String)"import.wizard.exclude.from.import.action.name", (Object[])new Object[0]), null, PlatformIcons.DELETE_ICON){

            public void update(AnActionEvent e) {
                VirtualFile[] selectedFiles = ImportTree.this.myFileSystemTree.getSelectedFiles();
                Presentation presentation = e.getPresentation();
                presentation.setEnabled(ImportTree.this.isAtLeastOneFileIncluded(selectedFiles));
            }

            public void actionPerformed(AnActionEvent e) {
                VirtualFile[] selectedFiles;
                for (VirtualFile selectedFile : selectedFiles = ImportTree.this.myFileSystemTree.getSelectedFiles()) {
                    ImportTree.this.exclude(selectedFile);
                }
                ImportTree.this.myWizard.updateStep();
                ImportTree.this.myFileSystemTree.getTree().repaint();
            }
        };
    }

    private boolean isAtLeastOneFileIncluded(VirtualFile[] selectedFiles) {
        if (selectedFiles == null || selectedFiles.length == 0) {
            return false;
        }
        for (VirtualFile selectedFile : selectedFiles) {
            if (this.isExcluded(selectedFile)) continue;
            return true;
        }
        return false;
    }

    public AnAction createIncludeAction() {
        return new AnAction(CvsBundle.message((String)"import.wizard.include.to.import.action.name", (Object[])new Object[0]), null, IconUtil.getAddIcon()){

            public void update(AnActionEvent e) {
                VirtualFile[] selectedFiles = ImportTree.this.myFileSystemTree.getSelectedFiles();
                Presentation presentation = e.getPresentation();
                presentation.setEnabled(ImportTree.this.isAtLeastOneFileExcluded(selectedFiles));
            }

            public void actionPerformed(AnActionEvent e) {
                VirtualFile[] selectedFiles;
                for (VirtualFile selectedFile : selectedFiles = ImportTree.this.myFileSystemTree.getSelectedFiles()) {
                    ImportTree.this.include(selectedFile);
                }
                ImportTree.this.myWizard.updateStep();
                ImportTree.this.myFileSystemTree.getTree().repaint();
            }
        };
    }

    private void include(VirtualFile selectedFile) {
        this.myExcludedFiles.remove(selectedFile);
        if (this.myProject == null) {
            return;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        if (!fileIndex.isIgnored(selectedFile)) {
            return;
        }
        VirtualFile parent = selectedFile.getParent();
        if (parent != null && fileIndex.isIgnored(parent)) {
            return;
        }
        for (VirtualFile excludedFile : this.myExcludedFiles) {
            if (!VfsUtil.isAncestor((VirtualFile)excludedFile, (VirtualFile)selectedFile, (boolean)true)) continue;
            return;
        }
        this.myIncludedFiles.add(selectedFile);
    }

    private void exclude(VirtualFile selectedFile) {
        this.myExcludedFiles.add(selectedFile);
        this.myIncludedFiles.remove(selectedFile);
    }

    private boolean isAtLeastOneFileExcluded(VirtualFile[] selectedFiles) {
        if (selectedFiles == null || selectedFiles.length == 0) {
            return false;
        }
        for (VirtualFile selectedFile : selectedFiles) {
            VirtualFile parent;
            ProjectFileIndex fileIndex;
            if (this.myExcludedFiles.contains(selectedFile)) {
                return true;
            }
            if (this.myProject == null || !(fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex()).isIgnored(selectedFile) || (parent = selectedFile.getParent()) == null || fileIndex.isIgnored(parent) || this.myExcludedFiles.contains(parent) || this.myIncludedFiles.contains(selectedFile)) continue;
            return true;
        }
        return false;
    }

    private boolean isExcluded(FileElement fileElement) {
        VirtualFile file = fileElement.getFile();
        if (file == null) {
            return false;
        }
        return this.isExcluded(file);
    }

    public boolean isExcluded(VirtualFile file) {
        for (VirtualFile excludedFile : this.myExcludedFiles) {
            if (!VfsUtil.isAncestor((VirtualFile)excludedFile, (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        if (this.myProject == null || !ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isIgnored(file)) {
            return false;
        }
        for (VirtualFile includedFile : this.myIncludedFiles) {
            if (!VfsUtil.isAncestor((VirtualFile)includedFile, (VirtualFile)file, (boolean)false)) continue;
            return false;
        }
        return true;
    }

    public IIgnoreFileFilter getIgnoreFileFilter() {
        HashSet excludedFiles = new HashSet();
        for (VirtualFile excludedFile : this.myExcludedFiles) {
            excludedFiles.add(CvsVfsUtil.getFileFor(excludedFile));
        }
        HashSet includedFiles = new HashSet();
        for (VirtualFile includedFile : this.myIncludedFiles) {
            includedFiles.add(CvsVfsUtil.getFileFor(includedFile));
        }
        return new IIgnoreFileFilter((Collection)includedFiles, (Collection)excludedFiles){
            private final Map<File, IgnoredFilesInfo> myParentToIgnoresMap = new HashMap();
            final /* synthetic */ Collection val$includedFiles;
            final /* synthetic */ Collection val$excludedFiles;
            {
                this.val$includedFiles = collection;
                this.val$excludedFiles = collection2;
            }

            public boolean shouldBeIgnored(AbstractFileObject abstractFileObject, ICvsFileSystem cvsFileSystem) {
                VirtualFile vFile;
                File file = cvsFileSystem.getLocalFileSystem().getFile(abstractFileObject);
                if (file.isDirectory() && file.getName().equals("CVS")) {
                    return true;
                }
                if (FileTypeManager.getInstance().isFileIgnored(abstractFileObject.getName())) {
                    return true;
                }
                if (ImportTree.this.myProject != null && !this.val$includedFiles.contains(file) && (vFile = LocalFileSystem.getInstance().findFileByIoFile(file)) != null && ProjectRootManager.getInstance((Project)ImportTree.this.myProject).getFileIndex().isIgnored(vFile)) {
                    return true;
                }
                if (this.val$excludedFiles.contains(file)) {
                    return true;
                }
                File parentFile = file.getParentFile();
                if (parentFile == null) {
                    return false;
                }
                if (!this.myParentToIgnoresMap.containsKey(parentFile)) {
                    this.myParentToIgnoresMap.put(parentFile, IgnoredFilesInfoImpl.createForFile(new File(parentFile, ".cvsignore")));
                }
                return this.myParentToIgnoresMap.get(parentFile).shouldBeIgnored(file.getName());
            }
        };
    }
}

