/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.common;

import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.cvsoperations.common.CvsOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsAdd.AddFileOperation;
import com.intellij.cvsSupport2.errorHandling.CannotFindCvsRootException;
import com.intellij.openapi.vcs.VcsException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;

public class CompositeOperation
extends CvsOperation {
    private final List<CvsOperation> mySubOperations = new ArrayList<CvsOperation>();
    private CvsOperation myCurrentOperation;

    public void addOperation(CvsOperation operation) {
        this.mySubOperations.add(operation);
    }

    protected void addOperation(int i, CvsOperation operation) {
        this.mySubOperations.add(i, operation);
    }

    @Override
    public void appendSelfCvsRootProvider(@NotNull Collection<CvsEnvironment> roots) throws CannotFindCvsRootException {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/cvsSupport2/cvsoperations/common/CompositeOperation", "appendSelfCvsRootProvider"));
        }
        for (CvsOperation operation : this.mySubOperations) {
            operation.appendSelfCvsRootProvider(roots);
        }
    }

    @Override
    public void execute(CvsExecutionEnvironment executionEnvironment, boolean underReadAction) throws VcsException, CommandAbortedException {
        Iterator<CvsOperation> i$ = this.getSubOperations().iterator();
        while (i$.hasNext()) {
            CvsOperation cvsOperation;
            this.myCurrentOperation = cvsOperation = i$.next();
            this.myCurrentOperation.execute(executionEnvironment, underReadAction);
        }
    }

    @Override
    public void executeFinishActions() {
        super.executeFinishActions();
        for (CvsOperation cvsOperation : this.getSubOperations()) {
            cvsOperation.executeFinishActions();
        }
    }

    @Override
    public String getLastProcessedCvsRoot() {
        if (this.myCurrentOperation == null) {
            return null;
        }
        return this.myCurrentOperation.getLastProcessedCvsRoot();
    }

    protected boolean containsSubOperation(AddFileOperation op) {
        return this.mySubOperations.contains(op);
    }

    protected List<CvsOperation> getSubOperations() {
        return this.mySubOperations;
    }

    @Override
    public boolean runInReadThread() {
        for (CvsOperation op : this.mySubOperations) {
            if (!op.runInReadThread()) continue;
            return true;
        }
        return false;
    }

    protected int getSubOperationsCount() {
        return this.mySubOperations.size();
    }
}

