/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections;

import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.config.ExtConfiguration;
import com.intellij.cvsSupport2.config.LocalSettings;
import com.intellij.cvsSupport2.config.ProxySettings;
import com.intellij.cvsSupport2.config.SshSettings;
import com.intellij.cvsSupport2.connections.ConnectionWrapper;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.connections.CvsRootData;
import com.intellij.cvsSupport2.connections.CvsSettings;
import com.intellij.cvsSupport2.connections.SelfTestingConnection;
import com.intellij.cvsSupport2.connections.SelfTestingConnectionWrapper;
import com.intellij.cvsSupport2.cvsoperations.cvsMessages.CvsListenerWithProgress;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.RevisionOrDate;
import com.intellij.cvsSupport2.errorHandling.ErrorRegistry;
import com.intellij.cvsSupport2.javacvsImpl.io.ReadWriteStatistics;
import org.netbeans.lib.cvsclient.CvsRoot;
import org.netbeans.lib.cvsclient.connection.IConnection;

public abstract class CvsConnectionSettings
extends CvsRootData
implements CvsEnvironment,
CvsSettings {
    private final CvsRootConfiguration myCvsRootConfiguration;
    private boolean myOffline;

    protected CvsConnectionSettings(CvsRootConfiguration cvsRootConfiguration) {
        super(cvsRootConfiguration.getCvsRootAsString());
        this.PORT = this.getDefaultPort();
        this.myCvsRootConfiguration = cvsRootConfiguration;
    }

    public abstract int getDefaultPort();

    public RevisionOrDate getRevisionOrDate() {
        return RevisionOrDate.EMPTY;
    }

    public String getRepository() {
        return this.REPOSITORY;
    }

    public CvsRoot getCvsRoot() {
        return new CvsRoot(this.USER, this.REPOSITORY, this.getCvsRootAsString());
    }

    public boolean isValid() {
        return true;
    }

    public IConnection createConnection(ReadWriteStatistics statistics) {
        CvsListenerWithProgress cvsCommandStopper = CvsListenerWithProgress.createOnProgress();
        IConnection originalConnection = this.createOriginalConnection(cvsCommandStopper, this.myCvsRootConfiguration);
        if (originalConnection instanceof SelfTestingConnection) {
            return new SelfTestingConnectionWrapper(originalConnection, statistics, cvsCommandStopper);
        }
        return new ConnectionWrapper(originalConnection, statistics, cvsCommandStopper);
    }

    protected abstract IConnection createOriginalConnection(ErrorRegistry var1, CvsRootConfiguration var2);

    protected ExtConfiguration getExtConfiguration() {
        return this.myCvsRootConfiguration.EXT_CONFIGURATION;
    }

    protected LocalSettings getLocalConfiguration() {
        return this.myCvsRootConfiguration.LOCAL_CONFIGURATION;
    }

    protected SshSettings getSshConfiguration() {
        return this.myCvsRootConfiguration.SSH_CONFIGURATION;
    }

    public ProxySettings getProxySettings() {
        return this.myCvsRootConfiguration.PROXY_SETTINGS;
    }

    public void setUseProxy(String proxyHost, String proxyPort) {
        super.setUseProxy(proxyHost, proxyPort);
        ProxySettings settings = this.myCvsRootConfiguration.PROXY_SETTINGS;
        settings.PROXY_HOST = proxyHost;
        try {
            settings.PROXY_PORT = Integer.parseInt(proxyPort);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        settings.USE_PROXY = true;
    }

    public boolean isOffline() {
        return this.myOffline;
    }

    public void setOffline(boolean offline) {
        this.myOffline = offline;
    }
}

