/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.config.ui;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.config.ui.CvsConfigurationsListEditor;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nullable;

public class SelectCvsConfigurationPanel
extends JPanel {
    private final DefaultListModel myModel = new DefaultListModel();
    private final JList myList = new JBList((ListModel)this.myModel);
    private CvsRootConfiguration mySelection = null;
    private final Project myProject;

    public SelectCvsConfigurationPanel(Project project) {
        super(new BorderLayout(2, 4));
        this.myProject = project;
        this.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myList), "Center");
        this.add(this.createButtonPanel(), "East");
        this.myList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SelectCvsConfigurationPanel.this.mySelection = (CvsRootConfiguration)SelectCvsConfigurationPanel.this.myList.getSelectedValue();
                SelectCvsConfigurationPanel.this.fireSelectionValueChanged(e.getFirstIndex(), e.getLastIndex(), e.getValueIsAdjusting());
            }
        });
        this.myList.setSelectionMode(0);
        this.fillModel(null);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.listenerList.add(ListSelectionListener.class, listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.listenerList.remove(ListSelectionListener.class, listener);
    }

    private void fireSelectionValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
        ListSelectionListener[] listeners = (ListSelectionListener[])this.getListeners(ListSelectionListener.class);
        if (listeners.length == 0) {
            return;
        }
        ListSelectionEvent event = new ListSelectionEvent(this, firstIndex, lastIndex, isAdjusting);
        for (ListSelectionListener listener : listeners) {
            listener.valueChanged(event);
        }
    }

    private Component createButtonPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JButton button = new JButton(CvsBundle.message((String)"button.text.configure.cvs.roots", (Object[])new Object[0]));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectCvsConfigurationPanel.this.editConfigurations();
            }
        });
        panel.add((Component)button, "North");
        return panel;
    }

    public void editConfigurations() {
        CvsApplicationLevelConfiguration configuration = CvsApplicationLevelConfiguration.getInstance();
        CvsConfigurationsListEditor cvsConfigurationsListEditor = new CvsConfigurationsListEditor(new ArrayList<CvsRootConfiguration>(configuration.CONFIGURATIONS), this.myProject);
        CvsRootConfiguration selectedConfiguration = this.getSelectedConfiguration();
        if (selectedConfiguration != null) {
            cvsConfigurationsListEditor.selectConfiguration(selectedConfiguration);
        }
        cvsConfigurationsListEditor.show();
        if (cvsConfigurationsListEditor.isOK()) {
            configuration.CONFIGURATIONS = cvsConfigurationsListEditor.getConfigurations();
            this.fillModel(cvsConfigurationsListEditor.getSelectedConfiguration());
        }
    }

    private void fillModel(@Nullable CvsRootConfiguration configurationToSelect) {
        CvsRootConfiguration selection = configurationToSelect == null ? this.mySelection : configurationToSelect;
        this.myModel.removeAllElements();
        List<CvsRootConfiguration> configurations = CvsApplicationLevelConfiguration.getInstance().CONFIGURATIONS;
        for (CvsRootConfiguration configuration : configurations) {
            if (configuration.CVS_ROOT.isEmpty()) continue;
            this.myModel.addElement(configuration);
        }
        if (selection != null) {
            this.myList.setSelectedValue(selection, true);
        }
        if (this.myList.getSelectedIndex() < 0 && this.myList.getModel().getSize() > 0) {
            this.myList.setSelectedIndex(0);
        }
    }

    public CvsRootConfiguration getSelectedConfiguration() {
        return this.mySelection;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }
}

