/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.config.ui;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.config.ui.ConfigureCvsGlobalSettingsDialog;
import com.intellij.cvsSupport2.config.ui.Cvs2SettingsEditPanel;
import com.intellij.cvsSupport2.config.ui.CvsListCellRenderer;
import com.intellij.cvsSupport2.ui.CvsRootChangeListener;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputException;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.PlatformIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CvsConfigurationsListEditor
extends DialogWrapper
implements DataProvider {
    private final Project myProject;
    private final JList myList = new JBList();
    private final DefaultListModel myModel = new DefaultListModel();
    private CvsRootConfiguration mySelection;
    private final Cvs2SettingsEditPanel myCvs2SettingsEditPanel;
    @NonNls
    private static final String SAMPLE_CVSROOT = ":pserver:user@host/server/home/user/cvs";
    private boolean myIsUpdating = false;

    public CvsConfigurationsListEditor(List<CvsRootConfiguration> configs, Project project) {
        this(configs, project, false);
    }

    public CvsConfigurationsListEditor(List<CvsRootConfiguration> configs, Project project, boolean readOnly) {
        super(true);
        this.myProject = project;
        this.myCvs2SettingsEditPanel = new Cvs2SettingsEditPanel(project, readOnly);
        this.setTitle(CvsBundle.message((String)"operation.name.edit.configurations", (Object[])new Object[0]));
        this.myList.setSelectionMode(0);
        this.selectNone();
        this.fillModel(configs);
        this.myCvs2SettingsEditPanel.addCvsRootChangeListener(new CvsRootChangeListener(){

            @Override
            public void onCvsRootChanged() {
                if (CvsConfigurationsListEditor.this.mySelection == null) {
                    return;
                }
                try {
                    CvsConfigurationsListEditor.this.myCvs2SettingsEditPanel.saveTo(CvsConfigurationsListEditor.this.mySelection);
                }
                catch (InputException inputException) {
                    // empty catch block
                }
                CvsConfigurationsListEditor.this.myList.repaint();
            }
        });
        this.setTitle(CvsBundle.message((String)"dialog.title.cvs.roots", (Object[])new Object[0]));
        if (!configs.isEmpty()) {
            this.myList.setSelectedIndex(0);
        }
        if (readOnly) {
            this.myList.setEnabled(false);
        }
        this.init();
    }

    @Nullable
    public static CvsRootConfiguration reconfigureCvsRoot(String root, Project project) {
        CvsApplicationLevelConfiguration configuration = CvsApplicationLevelConfiguration.getInstance();
        CvsRootConfiguration selectedConfig = configuration.getConfigurationForCvsRoot(root);
        ArrayList<CvsRootConfiguration> modifiableList = new ArrayList<CvsRootConfiguration>(configuration.CONFIGURATIONS);
        CvsConfigurationsListEditor editor = new CvsConfigurationsListEditor(modifiableList, project, true);
        editor.select(selectedConfig);
        editor.show();
        if (editor.isOK()) {
            configuration.CONFIGURATIONS = modifiableList;
            return configuration.getConfigurationForCvsRoot(root);
        }
        return null;
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        AbstractAction globalSettingsAction = new AbstractAction(CvsBundle.message((String)"button.text.global.settings", (Object[])new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ConfigureCvsGlobalSettingsDialog(CvsConfigurationsListEditor.this.myProject).show();
            }
        };
        Action[] actionArray = new Action[]{globalSettingsAction};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cvsSupport2/config/ui/CvsConfigurationsListEditor", "createLeftSideActions"));
        }
        return actionArray;
    }

    protected void doOKAction() {
        if (this.saveSelectedConfiguration()) {
            super.doOKAction();
        }
    }

    private void fillModel(List<CvsRootConfiguration> configurations) {
        for (CvsRootConfiguration configuration : configurations) {
            this.myModel.addElement(configuration.getMyCopy());
        }
    }

    private JComponent createListPanel() {
        AnActionButton duplicateButton = new AnActionButton(CvsBundle.message((String)"action.name.copy", (Object[])new Object[0]), PlatformIcons.COPY_ICON){

            public void updateButton(AnActionEvent e) {
                e.getPresentation().setEnabled(CvsConfigurationsListEditor.this.getSelectedConfiguration() != null);
            }

            public void actionPerformed(AnActionEvent e) {
                CvsConfigurationsListEditor.this.copySelectedConfiguration();
            }
        };
        duplicateButton.setShortcut((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(68, SystemInfo.isMac ? 4 : 2)));
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JList)this.myList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                CvsConfigurationsListEditor.this.createNewConfiguration();
            }
        }).addExtraAction(duplicateButton);
        return decorator.createPanel();
    }

    protected JComponent createCenterPanel() {
        this.myList.setCellRenderer(new CvsListCellRenderer());
        BorderLayout layout = new BorderLayout();
        layout.setHgap(6);
        JPanel centerPanel = new JPanel(layout);
        JComponent listPanel = this.createListPanel();
        centerPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        centerPanel.add((Component)listPanel, "Center");
        centerPanel.add((Component)this.createCvsConfigurationPanel(), "East");
        this.myList.setModel(this.myModel);
        this.addSelectionListener();
        int minWidth = this.myList.getFontMetrics(this.myList.getFont()).stringWidth(SAMPLE_CVSROOT) + 40;
        Dimension minSize = new Dimension(minWidth, this.myList.getMaximumSize().height);
        listPanel.setMinimumSize(minSize);
        listPanel.setPreferredSize(minSize);
        return centerPanel;
    }

    private JComponent createCvsConfigurationPanel() {
        return this.myCvs2SettingsEditPanel.getPanel();
    }

    private boolean saveSelectedConfiguration() {
        if (this.getSelectedConfiguration() == null) {
            return true;
        }
        try {
            this.myCvs2SettingsEditPanel.saveTo(this.getSelectedConfiguration());
            return true;
        }
        catch (InputException e) {
            e.show();
            return false;
        }
    }

    private void copySelectedConfiguration() {
        if (!this.saveSelectedConfiguration()) {
            return;
        }
        CvsRootConfiguration newConfig = this.mySelection.getMyCopy();
        this.myModel.addElement(newConfig);
        this.myList.setSelectedIndex(this.myModel.getSize() - 1);
    }

    private void editSelectedConfiguration() {
        this.editConfiguration(this.mySelection);
        this.myList.repaint();
    }

    private void createNewConfiguration() {
        if (!this.saveSelectedConfiguration()) {
            return;
        }
        this.myList.setSelectedValue(null, false);
        CvsRootConfiguration newConfig = CvsApplicationLevelConfiguration.createNewConfiguration(CvsApplicationLevelConfiguration.getInstance());
        this.myModel.addElement(newConfig);
        this.myList.setSelectedValue(newConfig, true);
    }

    private void editConfiguration(CvsRootConfiguration newConfig) {
        this.myCvs2SettingsEditPanel.updateFrom(newConfig);
    }

    private void addSelectionListener() {
        this.myList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (CvsConfigurationsListEditor.this.myIsUpdating) {
                    return;
                }
                int selectedIndex = CvsConfigurationsListEditor.this.myList.getSelectedIndex();
                if (selectedIndex < 0 || selectedIndex >= CvsConfigurationsListEditor.this.myModel.getSize()) {
                    CvsConfigurationsListEditor.this.selectNone();
                } else {
                    CvsRootConfiguration newSelection = (CvsRootConfiguration)CvsConfigurationsListEditor.this.myModel.getElementAt(selectedIndex);
                    if (newSelection == CvsConfigurationsListEditor.this.mySelection) {
                        return;
                    }
                    if (!CvsConfigurationsListEditor.this.select(newSelection)) {
                        CvsConfigurationsListEditor.this.myIsUpdating = true;
                        CvsConfigurationsListEditor.this.myList.setSelectedValue(CvsConfigurationsListEditor.this.mySelection, true);
                        CvsConfigurationsListEditor.this.myIsUpdating = false;
                    }
                }
            }
        });
    }

    private boolean select(CvsRootConfiguration cvsConfiguration) {
        if (this.mySelection != null) {
            try {
                this.myCvs2SettingsEditPanel.saveTo(this.mySelection);
            }
            catch (InputException e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        e.show();
                    }
                });
                return false;
            }
        }
        this.mySelection = cvsConfiguration;
        this.editSelectedConfiguration();
        return true;
    }

    private void selectNone() {
        this.mySelection = null;
        this.myCvs2SettingsEditPanel.disable();
    }

    public List<CvsRootConfiguration> getConfigurations() {
        ArrayList<CvsRootConfiguration> result = new ArrayList<CvsRootConfiguration>();
        Enumeration each = this.myModel.elements();
        while (each.hasMoreElements()) {
            result.add((CvsRootConfiguration)each.nextElement());
        }
        return result;
    }

    public CvsRootConfiguration getSelectedConfiguration() {
        return this.mySelection;
    }

    public void selectConfiguration(CvsRootConfiguration selectedConfiguration) {
        this.myList.setSelectedValue(selectedConfiguration, true);
    }

    @NonNls
    public Object getData(String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "reference.versioncontrol.cvs.roots";
        }
        return null;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("reference.versioncontrol.cvs.roots");
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cvsSupport2/config/ui/CvsConfigurationsListEditor", "createActions"));
        }
        return actionArray;
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myModel.isEmpty()) {
            return null;
        }
        return this.myCvs2SettingsEditPanel.getPreferredFocusedComponent();
    }
}

