/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions.merge;

import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.actions.merge.CvsConflictsParser;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.netbeans.lib.cvsclient.admin.Entry;

public class CvsMergeProvider
implements MergeProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public MergeData loadRevisions(VirtualFile file) throws VcsException {
        MergeData mergeData;
        File cvsFile;
        block8: {
            Entry entry = CvsEntriesManager.getInstance().getEntryFor(file);
            cvsFile = CvsVfsUtil.getFileFor(file);
            if (entry == null || !entry.isResultOfMerge() || !entry.isBinary()) break block8;
            String originalRevision = CvsUtil.getOriginalRevisionForFile(file);
            MergeData mergeData2 = new MergeData();
            mergeData2.CURRENT = CvsUtil.getStoredContentForFile(file, originalRevision);
            mergeData2.LAST = FileUtil.loadFileBytes((File)cvsFile);
            MergeData mergeData3 = mergeData2;
            {
                catch (IOException e) {
                    throw new VcsException((Throwable)e);
                }
            }
            if (mergeData3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cvsSupport2/actions/merge/CvsMergeProvider", "loadRevisions"));
            }
            return mergeData3;
        }
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(cvsFile));
        try {
            CvsConflictsParser parser = CvsConflictsParser.createOn(input);
            MergeData mergeData4 = new MergeData();
            mergeData4.ORIGINAL = parser.getCenterVersion().getBytes();
            mergeData4.CURRENT = parser.getLeftVersion().getBytes();
            mergeData4.LAST = parser.getRightVersion().getBytes();
            mergeData = mergeData4;
        }
        catch (Throwable throwable) {
            input.close();
            throw throwable;
        }
        input.close();
        MergeData mergeData5 = mergeData;
        if (mergeData5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cvsSupport2/actions/merge/CvsMergeProvider", "loadRevisions"));
        }
        return mergeData5;
    }

    public void conflictResolvedForFile(VirtualFile file) {
        CvsUtil.resolveConflict(file);
        CvsEntriesManager.getInstance().clearCachedEntriesFor(file.getParent());
    }

    public boolean isBinary(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/cvsSupport2/actions/merge/CvsMergeProvider", "isBinary"));
        }
        return false;
    }
}

