/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions.cvsContext;

import com.intellij.cvsSupport2.actions.cvsContext.CvsContext;
import com.intellij.cvsSupport2.actions.cvsContext.CvsLightweightFile;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.ui.Refreshable;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedCvsContext
implements CvsContext {
    private final boolean myIsActive;
    private final Collection<String> myDeletedFileNames;
    private final CvsLightweightFile[] myCvsLightweightFiles;
    private final VcsContext myVcsContext;

    public CachedCvsContext(CvsContext baseContext) {
        this.myIsActive = baseContext.cvsIsActive();
        this.myDeletedFileNames = baseContext.getDeletedFileNames();
        this.myCvsLightweightFiles = baseContext.getSelectedLightweightFiles();
        this.myVcsContext = baseContext;
    }

    public Project getProject() {
        return this.myVcsContext.getProject();
    }

    public VirtualFile getSelectedFile() {
        return this.myVcsContext.getSelectedFile();
    }

    public String getActionName() {
        return this.myVcsContext.getActionName();
    }

    @NotNull
    public VirtualFile[] getSelectedFiles() {
        VirtualFile[] virtualFileArray = this.myVcsContext.getSelectedFiles();
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cvsSupport2/actions/cvsContext/CachedCvsContext", "getSelectedFiles"));
        }
        return virtualFileArray;
    }

    public Editor getEditor() {
        return this.myVcsContext.getEditor();
    }

    public Collection<VirtualFile> getSelectedFilesCollection() {
        return this.myVcsContext.getSelectedFilesCollection();
    }

    public File[] getSelectedIOFiles() {
        return this.myVcsContext.getSelectedIOFiles();
    }

    public int getModifiers() {
        return this.myVcsContext.getModifiers();
    }

    public Refreshable getRefreshableDialog() {
        return this.myVcsContext.getRefreshableDialog();
    }

    public String getPlace() {
        return (String)this.myVcsContext.getPlace();
    }

    public File getSelectedIOFile() {
        return this.myVcsContext.getSelectedIOFile();
    }

    @Override
    public boolean cvsIsActive() {
        return this.myIsActive;
    }

    @Override
    public Collection<String> getDeletedFileNames() {
        return this.myDeletedFileNames;
    }

    @Override
    public CvsLightweightFile[] getSelectedLightweightFiles() {
        return this.myCvsLightweightFiles;
    }

    public FilePath[] getSelectedFilePaths() {
        return this.myVcsContext.getSelectedFilePaths();
    }

    public FilePath getSelectedFilePath() {
        return this.myVcsContext.getSelectedFilePath();
    }

    @Nullable
    public ChangeList[] getSelectedChangeLists() {
        return this.myVcsContext.getSelectedChangeLists();
    }

    @Nullable
    public Change[] getSelectedChanges() {
        return this.myVcsContext.getSelectedChanges();
    }
}

