/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContext;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContextWrapper;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.connections.CvsConnectionSettings;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;

public class ToggleOfflineAction
extends ToggleAction {
    public boolean isSelected(AnActionEvent e) {
        VirtualFile firstDirInChain;
        CvsContext cvsContext = CvsContextWrapper.createInstance(e);
        if (!cvsContext.cvsIsActive()) {
            return false;
        }
        VirtualFile root = cvsContext.getSelectedFile();
        if (root == null) {
            return false;
        }
        VirtualFile virtualFile = firstDirInChain = root.isDirectory() ? root : root.getParent();
        if (firstDirInChain == null) {
            return false;
        }
        CvsConnectionSettings settings = CvsEntriesManager.getInstance().getCvsConnectionSettingsFor(firstDirInChain);
        if (settings == null) {
            return false;
        }
        return settings.isOffline();
    }

    public void setSelected(AnActionEvent e, boolean state) {
        VirtualFile firstDirInChain;
        CvsContext cvsContext = CvsContextWrapper.createInstance(e);
        CvsEntriesManager entriesManager = CvsEntriesManager.getInstance();
        VirtualFile file = cvsContext.getSelectedFile();
        if (file == null) {
            return;
        }
        VirtualFile virtualFile = firstDirInChain = file.isDirectory() ? file : file.getParent();
        if (firstDirInChain == null) {
            return;
        }
        CvsConnectionSettings settings = entriesManager.getCvsConnectionSettingsFor(firstDirInChain);
        if (!settings.isValid()) {
            entriesManager.clearCachedEntriesFor(firstDirInChain);
            settings = entriesManager.getCvsConnectionSettingsFor(firstDirInChain);
        }
        if (settings != null && settings.isValid() && state != settings.isOffline()) {
            VcsBalloonProblemNotifier.showOverChangesView((Project)cvsContext.getProject(), (String)(state ? CvsBundle.message((String)"set.offline.notification.text", (Object[])new Object[0]) : CvsBundle.message((String)"set.online.notification.text", (Object[])new Object[0])), (MessageType)(state ? MessageType.WARNING : MessageType.INFO), (NamedRunnable[])new NamedRunnable[0]);
            settings.setOffline(state);
        }
    }

    public void update(AnActionEvent e) {
        super.update(e);
        CvsContext cvsContext = CvsContextWrapper.createInstance(e);
        VirtualFile[] files = cvsContext.getSelectedFiles();
        e.getPresentation().setVisible(files != null && files.length > 0 && cvsContext.cvsIsActive());
    }
}

