/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.actions.AbstractAction;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContext;
import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.config.ui.SelectCvsConfigurationDialog;
import com.intellij.cvsSupport2.cvsBrowser.ui.BrowserPanel;
import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.cvsSupport2.cvshandlers.FileSetToBeUpdated;
import com.intellij.cvsSupport2.cvsoperations.common.LoginPerformer;
import com.intellij.cvsSupport2.ui.CvsTabbedWindow;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.Consumer;
import java.util.Collections;

public class BrowseCvsRepositoryAction
extends AbstractAction
implements DumbAware {
    private static final String TITLE = CvsBundle.message((String)"operation.name.browse.repository", (Object[])new Object[0]);
    private CvsRootConfiguration mySelectedConfiguration;

    public BrowseCvsRepositoryAction() {
        super(false);
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        boolean projectExists = e.getData(CommonDataKeys.PROJECT) != null;
        presentation.setVisible(projectExists);
        presentation.setEnabled(projectExists);
    }

    @Override
    protected String getTitle(VcsContext context) {
        return TITLE;
    }

    @Override
    protected CvsHandler getCvsHandler(CvsContext context) {
        SelectCvsConfigurationDialog selectCvsConfigurationDialog = new SelectCvsConfigurationDialog(context.getProject());
        selectCvsConfigurationDialog.show();
        if (!selectCvsConfigurationDialog.isOK()) {
            return CvsHandler.NULL;
        }
        this.mySelectedConfiguration = selectCvsConfigurationDialog.getSelectedConfiguration();
        return new MyCvsHandler();
    }

    @Override
    protected void onActionPerformed(CvsContext context, CvsTabbedWindow tabbedWindow, boolean successfully, CvsHandler handler) {
        if (this.mySelectedConfiguration == null) {
            return;
        }
        final Project project = context.getProject();
        if (!this.loginImpl(context.getProject(), new Consumer<VcsException>(){

            public void consume(VcsException e) {
                VcsBalloonProblemNotifier.showOverChangesView((Project)project, (String)e.getMessage(), (MessageType)MessageType.WARNING, (NamedRunnable[])new NamedRunnable[0]);
            }
        })) {
            return;
        }
        super.onActionPerformed(context, tabbedWindow, successfully, handler);
        if (successfully) {
            LOG.assertTrue(project != null);
            LOG.assertTrue(this.mySelectedConfiguration != null);
            BrowserPanel browserPanel = new BrowserPanel(this.mySelectedConfiguration, project, new Consumer<VcsException>(){

                public void consume(VcsException e) {
                    VcsBalloonProblemNotifier.showOverChangesView((Project)project, (String)e.getMessage(), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
                }
            });
            tabbedWindow.addTab(TITLE, browserPanel, true, true, true, true, browserPanel.getActionGroup(), "cvs.browse");
            tabbedWindow.ensureVisible(project);
        }
    }

    private boolean loginImpl(Project project, Consumer<VcsException> exceptionConsumer) {
        LoginPerformer performer = new LoginPerformer(project, Collections.singletonList(this.mySelectedConfiguration), exceptionConsumer);
        try {
            return performer.loginAll(false);
        }
        catch (Exception e) {
            VcsBalloonProblemNotifier.showOverChangesView((Project)project, (String)e.getMessage(), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
            return false;
        }
    }

    private class MyCvsHandler
    extends CvsHandler {
        public MyCvsHandler() {
            super(TITLE, FileSetToBeUpdated.EMPTY);
        }

        @Override
        public boolean isCanceled() {
            return false;
        }

        @Override
        protected int getFilesToProcessCount() {
            return 0;
        }

        @Override
        public boolean login(Project project) {
            return BrowseCvsRepositoryAction.this.loginImpl(project, (Consumer<VcsException>)((Consumer)new Consumer<VcsException>(){

                public void consume(VcsException e) {
                    MyCvsHandler.this.myErrors.add(e);
                }
            }));
        }
    }
}

