/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import java.io.IOException;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.LockFile;
import org.eclipse.jgit.storage.file.RefDirectory;
import org.eclipse.jgit.storage.file.WriteConfig;

class RefDirectoryUpdate
extends RefUpdate {
    private final RefDirectory database;
    private LockFile lock;

    RefDirectoryUpdate(RefDirectory r, Ref ref) {
        super(ref);
        this.database = r;
    }

    protected RefDirectory getRefDatabase() {
        return this.database;
    }

    protected Repository getRepository() {
        return this.database.getRepository();
    }

    protected boolean tryLock(boolean deref) throws IOException {
        Ref dst = this.getRef();
        if (deref) {
            dst = dst.getLeaf();
        }
        String name = dst.getName();
        this.lock = new LockFile(this.database.fileFor(name), this.getRepository().getFS());
        if (this.lock.lock()) {
            dst = this.database.getRef(name);
            this.setOldObjectId(dst != null ? dst.getObjectId() : null);
            return true;
        }
        return false;
    }

    protected void unlock() {
        if (this.lock != null) {
            this.lock.unlock();
            this.lock = null;
        }
    }

    protected RefUpdate.Result doUpdate(RefUpdate.Result status) throws IOException {
        WriteConfig wc = this.database.getRepository().getConfig().get(WriteConfig.KEY);
        this.lock.setFSync(wc.getFSyncRefFiles());
        this.lock.setNeedStatInformation(true);
        this.lock.write(this.getNewObjectId());
        String msg = this.getRefLogMessage();
        if (msg != null) {
            String strResult;
            if (this.isRefLogIncludingResult() && (strResult = this.toResultString(status)) != null) {
                msg = msg.length() > 0 ? msg + ": " + strResult : strResult;
            }
            this.database.log(this, msg, true);
        }
        if (!this.lock.commit()) {
            return RefUpdate.Result.LOCK_FAILURE;
        }
        this.database.stored(this, this.lock.getCommitSnapshot());
        return status;
    }

    private String toResultString(RefUpdate.Result status) {
        switch (status) {
            case FORCED: {
                return "forced-update";
            }
            case FAST_FORWARD: {
                return "fast forward";
            }
            case NEW: {
                return "created";
            }
        }
        return null;
    }

    protected RefUpdate.Result doDelete(RefUpdate.Result status) throws IOException {
        if (this.getRef().getLeaf().getStorage() != Ref.Storage.NEW) {
            this.database.delete(this);
        }
        return status;
    }

    protected RefUpdate.Result doLink(String target) throws IOException {
        WriteConfig wc = this.database.getRepository().getConfig().get(WriteConfig.KEY);
        this.lock.setFSync(wc.getFSyncRefFiles());
        this.lock.setNeedStatInformation(true);
        this.lock.write(Constants.encode("ref: " + target + '\n'));
        String msg = this.getRefLogMessage();
        if (msg != null) {
            this.database.log(this, msg, false);
        }
        if (!this.lock.commit()) {
            return RefUpdate.Result.LOCK_FAILURE;
        }
        this.database.storedSymbolicRef(this, this.lock.getCommitSnapshot(), target);
        if (this.getRef().getStorage() == Ref.Storage.NEW) {
            return RefUpdate.Result.NEW;
        }
        return RefUpdate.Result.FORCED;
    }
}

