/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.artifacts.ArtifactBuildTaskProvider;
import org.jetbrains.jps.incremental.BuildTask;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.elements.JpsArchivePackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsArtifactOutputPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.plugins.javaFX.JpsJavaFxApplicationArtifactType;
import org.jetbrains.plugins.javaFX.JpsJavaFxArtifactProperties;
import org.jetbrains.plugins.javaFX.packaging.AbstractJavaFxPackager;
import org.jetbrains.plugins.javaFX.packaging.JavaFxManifestAttribute;
import org.jetbrains.plugins.javaFX.packaging.JavaFxPackagerConstants;
import org.jetbrains.plugins.javaFX.preloader.JpsJavaFxPreloaderArtifactProperties;
import org.jetbrains.plugins.javaFX.preloader.JpsJavaFxPreloaderArtifactType;

public class JpsJavaFxArtifactBuildTaskProvider
extends ArtifactBuildTaskProvider {
    public static final String COMPILER_NAME = "Java FX Packager";

    @NotNull
    public List<? extends BuildTask> createArtifactBuildTasks(@NotNull JpsArtifact artifact, @NotNull ArtifactBuildTaskProvider.ArtifactBuildPhase buildPhase) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/javaFX/JpsJavaFxArtifactBuildTaskProvider", "createArtifactBuildTasks"));
        }
        if (buildPhase == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/javaFX/JpsJavaFxArtifactBuildTaskProvider", "createArtifactBuildTasks"));
        }
        if (buildPhase != ArtifactBuildTaskProvider.ArtifactBuildPhase.POST_PROCESSING) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/JpsJavaFxArtifactBuildTaskProvider", "createArtifactBuildTasks"));
            }
            return list;
        }
        if (!(artifact.getArtifactType() instanceof JpsJavaFxApplicationArtifactType)) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/JpsJavaFxArtifactBuildTaskProvider", "createArtifactBuildTasks"));
            }
            return list;
        }
        JpsElement props = artifact.getProperties();
        if (!(props instanceof JpsJavaFxArtifactProperties)) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/JpsJavaFxArtifactBuildTaskProvider", "createArtifactBuildTasks"));
            }
            return list;
        }
        List<JavaFxJarDeployTask> list = Collections.singletonList(new JavaFxJarDeployTask((JpsJavaFxArtifactProperties)props, artifact));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/JpsJavaFxArtifactBuildTaskProvider", "createArtifactBuildTasks"));
        }
        return list;
    }

    private static class JpsJavaFxPackager
    extends AbstractJavaFxPackager {
        private final JpsJavaFxArtifactProperties myProperties;
        private final CompileContext myCompileContext;
        private final JpsArtifact myArtifact;

        public JpsJavaFxPackager(JpsJavaFxArtifactProperties properties, CompileContext compileContext, JpsArtifact artifact) {
            this.myArtifact = artifact;
            this.myProperties = properties;
            this.myCompileContext = compileContext;
        }

        protected String getArtifactName() {
            return this.myArtifact.getName();
        }

        protected String getArtifactOutputPath() {
            return this.myArtifact.getOutputPath();
        }

        protected String getArtifactOutputFilePath() {
            for (JpsPackagingElement element : this.myArtifact.getRootElement().getChildren()) {
                if (!(element instanceof JpsArchivePackagingElement)) continue;
                return this.myArtifact.getOutputFilePath() + File.separator + ((JpsArchivePackagingElement)element).getArchiveName();
            }
            return this.myArtifact.getOutputFilePath();
        }

        protected String getAppClass() {
            return this.myProperties.myState.getAppClass();
        }

        protected String getTitle() {
            return this.myProperties.myState.getTitle();
        }

        protected String getVendor() {
            return this.myProperties.myState.getVendor();
        }

        protected String getDescription() {
            return this.myProperties.myState.getDescription();
        }

        protected String getWidth() {
            return this.myProperties.myState.getWidth();
        }

        protected String getHeight() {
            return this.myProperties.myState.getHeight();
        }

        protected void registerJavaFxPackagerError(String message) {
            this.myCompileContext.processMessage((BuildMessage)new CompilerMessage(JpsJavaFxArtifactBuildTaskProvider.COMPILER_NAME, BuildMessage.Kind.ERROR, message));
        }

        protected String getHtmlParamFile() {
            return this.myProperties.myState.getHtmlParamFile();
        }

        protected String getParamFile() {
            return this.myProperties.myState.getParamFile();
        }

        protected String getUpdateMode() {
            return this.myProperties.myState.getUpdateMode();
        }

        protected JavaFxPackagerConstants.NativeBundles getNativeBundle() {
            return this.myProperties.myState.myNativeBundle;
        }

        public String getKeypass() {
            return this.myProperties.myState.getKeypass();
        }

        public String getStorepass() {
            return this.myProperties.myState.getStorepass();
        }

        public String getKeystore() {
            return this.myProperties.myState.getKeystore();
        }

        public String getAlias() {
            return this.myProperties.myState.getAlias();
        }

        public boolean isSelfSigning() {
            return this.myProperties.myState.isSelfSigning();
        }

        public boolean isEnabledSigning() {
            return this.myProperties.myState.isEnabledSigning();
        }

        public String getPreloaderClass() {
            JpsArtifact artifact = this.getPreloaderArtifact();
            if (artifact != null) {
                JpsJavaFxPreloaderArtifactProperties artifactProperties = (JpsJavaFxPreloaderArtifactProperties)artifact.getProperties();
                return artifactProperties.getPreloaderClass();
            }
            return null;
        }

        public String getPreloaderJar() {
            JpsArtifact artifact = this.getPreloaderArtifact();
            if (artifact != null) {
                return ((JpsArchivePackagingElement)artifact.getRootElement()).getArchiveName();
            }
            return null;
        }

        public boolean convertCss2Bin() {
            return this.myProperties.myState.isConvertCss2Bin();
        }

        public List<JavaFxManifestAttribute> getCustomManifestAttributes() {
            return this.myProperties.myState.getCustomManifestAttributes();
        }

        private JpsArtifact getPreloaderArtifact() {
            for (JpsPackagingElement element : this.myArtifact.getRootElement().getChildren()) {
                JpsArtifact artifact;
                if (!(element instanceof JpsArtifactOutputPackagingElement) || (artifact = (JpsArtifact)((JpsArtifactOutputPackagingElement)element).getArtifactReference().resolve()) == null || !(artifact.getArtifactType() instanceof JpsJavaFxPreloaderArtifactType)) continue;
                return artifact;
            }
            return null;
        }
    }

    private static class JavaFxJarDeployTask
    extends BuildTask {
        private final JpsJavaFxArtifactProperties myProps;
        private final JpsArtifact myArtifact;

        public JavaFxJarDeployTask(JpsJavaFxArtifactProperties props, JpsArtifact artifact) {
            this.myProps = props;
            this.myArtifact = artifact;
        }

        public void build(CompileContext context) throws ProjectBuildException {
            Set sdks = context.getProjectDescriptor().getProjectJavaSdks();
            JpsSdk javaSdk = null;
            for (JpsSdk sdk : sdks) {
                JpsSdkType sdkType = sdk.getSdkType();
                if (!(sdkType instanceof JpsJavaSdkType)) continue;
                javaSdk = sdk;
                break;
            }
            if (javaSdk == null) {
                context.processMessage((BuildMessage)new CompilerMessage(JpsJavaFxArtifactBuildTaskProvider.COMPILER_NAME, BuildMessage.Kind.ERROR, "Java version 7 or higher is required to build JavaFX package"));
                return;
            }
            new JpsJavaFxPackager(this.myProps, context, this.myArtifact).buildJavaFxArtifact(javaSdk.getHomePath());
        }
    }
}

