/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.model.impl;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.maven.model.impl.MavenResourceFileFilter;
import org.jetbrains.jps.maven.model.impl.MavenResourcesTarget;
import org.jetbrains.jps.maven.model.impl.ResourceRootConfiguration;

public class MavenResourceRootDescriptor
extends BuildRootDescriptor {
    private final MavenResourcesTarget myTarget;
    private final ResourceRootConfiguration myConfig;
    private final File myFile;
    private final String myId;

    public MavenResourceRootDescriptor(@NotNull MavenResourcesTarget target, ResourceRootConfiguration config) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/maven/model/impl/MavenResourceRootDescriptor", "<init>"));
        }
        this.myTarget = target;
        this.myConfig = config;
        String path = FileUtil.toCanonicalPath((String)config.directory);
        this.myFile = new File(path);
        this.myId = path;
    }

    public ResourceRootConfiguration getConfiguration() {
        return this.myConfig;
    }

    public String getRootId() {
        return this.myId;
    }

    public File getRootFile() {
        return this.myFile;
    }

    public MavenResourcesTarget getTarget() {
        return this.myTarget;
    }

    @NotNull
    public FileFilter createFileFilter() {
        MavenResourceFileFilter mavenResourceFileFilter = new MavenResourceFileFilter(this.myFile, this.myConfig);
        if (mavenResourceFileFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/maven/model/impl/MavenResourceRootDescriptor", "createFileFilter"));
        }
        return mavenResourceFileFilter;
    }

    public boolean canUseFileCache() {
        return true;
    }
}

