/*
 * Decompiled with CFR 0.152.
 */
package com.michaelbaranov.microba.marker;

import com.michaelbaranov.microba.common.AbstractBoundedTableModelWithSelection;
import com.michaelbaranov.microba.marker.MarkerMutationModel;
import java.util.ArrayList;
import java.util.List;

public class DefaultMarkerModel
extends AbstractBoundedTableModelWithSelection
implements MarkerMutationModel {
    private List data = new ArrayList(32);
    private int lowerBound = 0;
    private int upperBound = 100;

    public DefaultMarkerModel() {
        this.setSelectionMode(0);
    }

    public int getRowCount() {
        return this.data.size();
    }

    public int getColumnCount() {
        return 1;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        this.checkIndexes(rowIndex, columnIndex);
        return this.data.get(rowIndex);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.checkIndexes(rowIndex, columnIndex);
        Integer newValue = (Integer)aValue;
        Integer oldValue = (Integer)this.getValueAt(rowIndex, columnIndex);
        if (!newValue.equals(oldValue)) {
            this.data.remove(rowIndex);
            this.data.add(rowIndex, newValue);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    public Class getColumnClass(int columnIndex) {
        return Integer.class;
    }

    public String getColumnName(int columnIndex) {
        return "Position";
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public void removeMarkerAtIndex(int index) {
        if (this.isSelectedIndex(index)) {
            this.removeSelectionInterval(index, index);
        }
        this.data.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    public int addMarkAtPosition(int position) {
        this.data.add(new Integer(position));
        int row = this.data.size() - 1;
        this.fireTableRowsInserted(row, row);
        this.setSelectionInterval(row, row);
        return row;
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public void setLowerBound(int lowerBound) {
        if (lowerBound >= this.upperBound) {
            throw new IllegalArgumentException("lowerBound >= upperBound");
        }
        int old = this.lowerBound;
        this.lowerBound = lowerBound;
        this.firePropertyChange("lowerBound", old, lowerBound);
    }

    public void setUpperBound(int upperBound) {
        int old = this.upperBound;
        this.upperBound = upperBound;
        this.firePropertyChange("upperBound", old, upperBound);
    }

    private void checkIndexes(int rowIndex, int columnIndex) {
        if (columnIndex != 0) {
            throw new IndexOutOfBoundsException("columnIndex: " + columnIndex);
        }
        if (rowIndex < 0 || rowIndex >= this.data.size()) {
            throw new IndexOutOfBoundsException("rowIndex: " + rowIndex);
        }
    }
}

