/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections.ssh;

import com.intellij.cvsSupport2.connections.ssh.SshLogger;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.KeyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.util.proxy.CommonProxy;
import com.intellij.util.proxy.NonStaticAuthenticator;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.lib.cvsclient.connection.ConnectionSettings;

public class SocksAuthenticatorManager {
    private final Object myLock = new Object();
    private volatile CvsProxySelector mySelector;

    public static SocksAuthenticatorManager getInstance() {
        return (SocksAuthenticatorManager)ServiceManager.getService(SocksAuthenticatorManager.class);
    }

    private SocksAuthenticatorManager() {
    }

    public void register(ConnectionSettings connectionSettings) {
        SshLogger.debug("register in authenticator");
        this.ensureRegistered();
        this.mySelector.register(connectionSettings.getHostName(), connectionSettings.getPort(), connectionSettings.getProxyHostName(), connectionSettings.getProxyPort(), connectionSettings.getProxyLogin(), connectionSettings.getProxyPassword());
        CommonProxy.getInstance().setCustomAuth(this.getClass().getName(), this.mySelector.getAuthenticator());
    }

    public void unregister(ConnectionSettings connectionSettings) {
        SshLogger.debug("unregister in authenticator");
        if (!connectionSettings.isUseProxy()) {
            return;
        }
        int proxyType = connectionSettings.getProxyType();
        if (proxyType != 1 && proxyType != 2) {
            return;
        }
        this.mySelector.unregister(connectionSettings.getHostName(), connectionSettings.getPort());
        CommonProxy.getInstance().removeCustomAuth(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureRegistered() {
        if (this.mySelector == null) {
            Object object = this.myLock;
            synchronized (object) {
                if (this.mySelector == null) {
                    this.mySelector = new CvsProxySelector();
                    CommonProxy.getInstance().setCustom("com.intellij.cvsSupport2.connections.ssh.CvsSocksSelector", (ProxySelector)this.mySelector);
                }
            }
        }
    }

    private static class CvsProxySelector
    extends ProxySelector {
        private final Map<Pair<String, Integer>, Pair<String, Integer>> myKnownHosts = Collections.synchronizedMap(new HashMap());
        private final Map<Pair<String, Integer>, KeyValue<String, String>> myAuthMap = Collections.synchronizedMap(new HashMap());
        private NonStaticAuthenticator myAuthenticator = new NonStaticAuthenticator(){

            public PasswordAuthentication getPasswordAuthentication() {
                KeyValue value = (KeyValue)CvsProxySelector.this.myAuthMap.get(Pair.create((Object)this.getRequestingHost(), (Object)this.getRequestingPort()));
                if (value != null) {
                    return new PasswordAuthentication((String)value.getKey(), ((String)value.getValue()).toCharArray());
                }
                return null;
            }
        };

        private CvsProxySelector() {
        }

        private NonStaticAuthenticator getAuthenticator() {
            return this.myAuthenticator;
        }

        public void register(String host, int port, String proxyHost, int proxyPort, String login, String password) {
            Pair value = Pair.create((Object)proxyHost, (Object)proxyPort);
            this.myKnownHosts.put((Pair<String, Integer>)Pair.create((Object)host, (Object)port), (Pair<String, Integer>)value);
            this.myAuthMap.put((Pair<String, Integer>)value, (KeyValue<String, String>)KeyValue.create((Object)login, (Object)password));
        }

        public void unregister(String host, int port) {
            Pair<String, Integer> remove = this.myKnownHosts.remove(Pair.create((Object)host, (Object)port));
            this.myAuthMap.remove(remove);
        }

        @Override
        public List<Proxy> select(URI uri) {
            Pair<String, Integer> pair = this.myKnownHosts.get(Pair.create((Object)uri.getHost(), (Object)uri.getPort()));
            if (pair != null) {
                return Collections.singletonList(new Proxy(Proxy.Type.SOCKS, new InetSocketAddress((String)pair.getFirst(), (int)((Integer)pair.getSecond()))));
            }
            return null;
        }

        @Override
        public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        }
    }
}

