/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections;

import com.intellij.cvsSupport2.errorHandling.ErrorRegistry;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.concurrency.Semaphore;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.IConnection;
import org.netbeans.lib.cvsclient.io.IStreamLogger;

public abstract class ConnectionOnProcess
implements IConnection {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.connections.ConnectionOnProcess");
    protected InputStream myInputStream;
    protected OutputStream myOutputStream;
    protected Process myProcess;
    private final String myRepository;
    private final ErrorRegistry myErrorRegistry;
    private boolean myContainsError = false;
    protected final StringBuffer myErrorText = new StringBuffer();
    private Future<?> myStdErrFuture;
    private ReadProcessThread myErrThread;
    private Semaphore myWaitSemaphore;
    private Future<?> myWaitForThreadFuture;

    protected ConnectionOnProcess(String repository, ErrorRegistry errorRegistry) {
        this.myRepository = repository;
        this.myErrorRegistry = errorRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        if (this.myWaitForThreadFuture != null) {
            this.myWaitForThreadFuture.cancel(true);
        }
        if (this.myWaitSemaphore != null) {
            this.myWaitSemaphore.up();
        }
        try {
            if (this.myInputStream != null && !this.myContainsError) {
                this.myInputStream.close();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        finally {
            try {
                if (this.myOutputStream != null && !this.myContainsError) {
                    this.myOutputStream.close();
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {}
                }
                try {
                    if (this.myErrThread != null) {
                        this.myErrThread.setProcessTerminated(true);
                    }
                    if (this.myStdErrFuture != null) {
                        this.myStdErrFuture.get();
                    }
                }
                catch (InterruptedException e) {
                }
                catch (ExecutionException e) {
                    LOG.error((Throwable)e);
                }
            }
            finally {
                try {
                    if (this.myProcess != null) {
                        this.myProcess.destroy();
                    }
                }
                finally {
                    this.myInputStream = null;
                    this.myOutputStream = null;
                    this.myProcess = null;
                }
            }
        }
    }

    public InputStream getInputStream() {
        return this.myInputStream;
    }

    public OutputStream getOutputStream() {
        return this.myOutputStream;
    }

    public abstract void open() throws AuthenticationException;

    public String getRepository() {
        return this.myRepository;
    }

    public void verify(IStreamLogger streamLogger) throws AuthenticationException {
        this.open(streamLogger);
    }

    public void open(IStreamLogger streamLogger) throws AuthenticationException {
        this.open();
    }

    protected synchronized void execute(GeneralCommandLine commandLine) throws AuthenticationException {
        try {
            commandLine.setPassParentEnvironment(true);
            this.myProcess = commandLine.createProcess();
            this.myErrThread = new ReadProcessThread(new BufferedReader(new InputStreamReader(this.myProcess.getErrorStream(), EncodingManager.getInstance().getDefaultCharset()))){

                @Override
                protected void textAvailable(String s) {
                    ConnectionOnProcess.this.myErrorText.append(s);
                    ConnectionOnProcess.this.myErrorRegistry.registerError(s);
                    ConnectionOnProcess.this.myContainsError = true;
                }
            };
            Application application = ApplicationManager.getApplication();
            this.myStdErrFuture = application.executeOnPooledThread((Runnable)this.myErrThread);
            this.myInputStream = this.myProcess.getInputStream();
            this.myOutputStream = this.myProcess.getOutputStream();
            this.waitForProcess(application);
        }
        catch (Exception e) {
            this.closeInternal();
            throw new AuthenticationException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void waitForProcess(Application application) {
        this.myWaitSemaphore = new Semaphore();
        this.myWaitSemaphore.down();
        this.myWaitForThreadFuture = application.executeOnPooledThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ConnectionOnProcess.this.myProcess.waitFor();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    ConnectionOnProcess.this.myWaitSemaphore.up();
                }
            }
        });
    }

    protected void closeInternal() {
        try {
            this.close();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean isOpen() {
        return this.myProcess != null;
    }

    private static abstract class ReadProcessThread
    implements Runnable {
        private final Reader myReader;
        private boolean skipLF = false;
        private boolean myIsProcessTerminated = false;
        private final char[] myBuffer = new char[8192];

        public ReadProcessThread(Reader reader) {
            this.myReader = reader;
        }

        public synchronized void setProcessTerminated(boolean isProcessTerminated) {
            this.myIsProcessTerminated = isProcessTerminated;
        }

        @Override
        public void run() {
            try {
                while (this.readAvailable()) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException ignore) {}
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }

        private synchronized boolean readAvailable() throws IOException {
            int n;
            char[] buffer = this.myBuffer;
            StringBuilder token = new StringBuilder();
            while (this.myReader.ready() && (n = this.myReader.read(buffer)) > 0) {
                for (int i = 0; i < n; ++i) {
                    char c = buffer[i];
                    if (this.skipLF && c != '\n') {
                        token.append('\r');
                    }
                    if (c == '\r') {
                        this.skipLF = true;
                    } else {
                        this.skipLF = false;
                        token.append(c);
                    }
                    if (c != '\n') continue;
                    this.textAvailable(token.toString());
                    token.setLength(0);
                }
            }
            if (token.length() != 0) {
                this.textAvailable(token.toString());
                token.setLength(0);
            }
            if (this.myIsProcessTerminated) {
                try {
                    this.myReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
            return true;
        }

        protected abstract void textAvailable(String var1);
    }
}

