/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.stepping;

import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.xdebugger.stepping.XSmartStepIntoVariant;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiBackedSmartStepIntoVariant<T extends PsiNamedElement & NavigationItem>
extends XSmartStepIntoVariant {
    private final T myElement;
    private final ItemPresentation myPresentation;

    public PsiBackedSmartStepIntoVariant(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/stepping/PsiBackedSmartStepIntoVariant", "<init>"));
        }
        this.myElement = element;
        this.myPresentation = ((NavigationItem)element).getPresentation();
        assert (this.myPresentation != null) : "Invalid presentation:" + this.myElement;
    }

    @Override
    public String getText() {
        String location = this.myPresentation.getLocationString();
        return this.myPresentation.getPresentableText() + (location != null ? " " + location : "");
    }

    @Override
    public Icon getIcon() {
        return this.myPresentation.getIcon(false);
    }

    @NotNull
    public T getElement() {
        T t = this.myElement;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/stepping/PsiBackedSmartStepIntoVariant", "getElement"));
        }
        return t;
    }
}

