/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XDebuggerUtil {
    public static XDebuggerUtil getInstance() {
        return ServiceManager.getService(XDebuggerUtil.class);
    }

    public abstract XLineBreakpointType<?>[] getLineBreakpointTypes();

    public void toggleLineBreakpoint(@NotNull Project project, @NotNull VirtualFile file, int line) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/XDebuggerUtil", "toggleLineBreakpoint"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/XDebuggerUtil", "toggleLineBreakpoint"));
        }
        this.toggleLineBreakpoint(project, file, line, false);
    }

    public abstract void toggleLineBreakpoint(@NotNull Project var1, @NotNull VirtualFile var2, int var3, boolean var4);

    public abstract boolean canPutBreakpointAt(@NotNull Project var1, @NotNull VirtualFile var2, int var3);

    public <P extends XBreakpointProperties> void toggleLineBreakpoint(@NotNull Project project, @NotNull XLineBreakpointType<P> type, @NotNull VirtualFile file, int line) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/XDebuggerUtil", "toggleLineBreakpoint"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/XDebuggerUtil", "toggleLineBreakpoint"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/xdebugger/XDebuggerUtil", "toggleLineBreakpoint"));
        }
        this.toggleLineBreakpoint(project, type, file, line, false);
    }

    public abstract <P extends XBreakpointProperties> void toggleLineBreakpoint(@NotNull Project var1, @NotNull XLineBreakpointType<P> var2, @NotNull VirtualFile var3, int var4, boolean var5);

    public abstract void removeBreakpoint(Project var1, XBreakpoint<?> var2);

    public abstract <B extends XBreakpoint<?>> XBreakpointType<B, ?> findBreakpointType(@NotNull Class<? extends XBreakpointType<B, ?>> var1);

    @Nullable
    public abstract XSourcePosition createPosition(@Nullable VirtualFile var1, int var2);

    @Nullable
    public abstract XSourcePosition createPositionByOffset(@Nullable VirtualFile var1, int var2);

    public abstract <B extends XLineBreakpoint<?>> XBreakpointGroupingRule<B, ?> getGroupingByFileRule();

    public abstract <B extends XLineBreakpoint<?>> List<XBreakpointGroupingRule<B, ?>> getGroupingByFileRuleAsList();

    public abstract <B extends XBreakpoint<?>> Comparator<B> getDefaultBreakpointComparator(XBreakpointType<B, ?> var1);

    public abstract <P extends XBreakpointProperties> Comparator<XLineBreakpoint<P>> getDefaultLineBreakpointComparator();

    public abstract <T extends XDebuggerSettings<?>> T getDebuggerSettings(Class<T> var1);

    @Nullable
    public abstract XValueContainer getValueContainer(DataContext var1);

    public abstract void iterateLine(@NotNull Project var1, @NotNull Document var2, int var3, @NotNull Processor<PsiElement> var4);

    public abstract void disableValueLookup(@NotNull Editor var1);

    @Nullable
    public abstract PsiElement findContextElement(@NotNull VirtualFile var1, int var2, @NotNull Project var3, boolean var4);
}

