/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.model.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.MergedObject;
import com.intellij.util.xml.model.DomModel;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DomModelImpl<T extends DomElement>
implements DomModel<T> {
    protected final DomFileElement<T> myMergedModel;
    protected final Set<XmlFile> myConfigFiles;
    private Class<T> myClass;
    private Project myProject;

    @Deprecated
    public DomModelImpl(T mergedModel, @NotNull Set<XmlFile> configFiles) {
        if (configFiles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/xml/model/impl/DomModelImpl", "<init>"));
        }
        this.myMergedModel = DomUtil.getFileElement(mergedModel);
        this.myConfigFiles = configFiles;
    }

    public DomModelImpl(DomFileElement<T> mergedModel, @NotNull Set<XmlFile> configFiles) {
        if (configFiles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/xml/model/impl/DomModelImpl", "<init>"));
        }
        this.myMergedModel = DomUtil.getFileElement(mergedModel);
        this.myConfigFiles = configFiles;
    }

    public DomModelImpl(@NotNull Set<XmlFile> configFiles, Class<T> clazz, Project project) {
        if (configFiles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/model/impl/DomModelImpl", "<init>"));
        }
        this.myProject = project;
        this.myMergedModel = null;
        this.myConfigFiles = configFiles;
        this.myClass = clazz;
    }

    @Override
    @NotNull
    public T getMergedModel() {
        if (this.myMergedModel == null) {
            final DomManager domManager = DomManager.getDomManager(this.myProject);
            DomElement domElement = (DomElement)domManager.createModelMerger().mergeModels(this.myClass, ContainerUtil.mapNotNull(this.myConfigFiles, (Function)new NullableFunction<XmlFile, T>(){

                public T fun(XmlFile xmlFile) {
                    DomFileElement fileElement = domManager.getFileElement(xmlFile, DomModelImpl.this.myClass);
                    return fileElement == null ? null : (Object)fileElement.getRootElement();
                }
            }));
            if (domElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/model/impl/DomModelImpl", "getMergedModel"));
            }
            return (T)domElement;
        }
        T t = this.myMergedModel.getRootElement();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/model/impl/DomModelImpl", "getMergedModel"));
        }
        return t;
    }

    @Override
    @NotNull
    public Set<XmlFile> getConfigFiles() {
        Set<XmlFile> set = this.myConfigFiles;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/model/impl/DomModelImpl", "getConfigFiles"));
        }
        return set;
    }

    @Override
    @NotNull
    public List<DomFileElement<T>> getRoots() {
        if (this.myMergedModel == null) {
            List list = ContainerUtil.mapNotNull(this.myConfigFiles, (Function)new NullableFunction<XmlFile, DomFileElement<T>>(){

                public DomFileElement<T> fun(XmlFile xmlFile) {
                    return DomManager.getDomManager(xmlFile.getProject()).getFileElement(xmlFile, DomModelImpl.this.myClass);
                }
            });
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/model/impl/DomModelImpl", "getRoots"));
            }
            return list;
        }
        List<DomFileElement<Object>> list = this.myMergedModel instanceof MergedObject ? ((MergedObject)((Object)this.myMergedModel)).getImplementations() : Collections.singletonList(this.myMergedModel);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/model/impl/DomModelImpl", "getRoots"));
        }
        return list;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/model/impl/DomModelImpl", "getProject"));
        }
        return project;
    }
}

