/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.model.impl;

import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.ModelMerger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomModelFactoryHelper<T extends DomElement> {
    protected final Class<T> myClass;
    protected final ModelMerger myModelMerger;

    public DomModelFactoryHelper(@NotNull Class<T> aClass, @NotNull ModelMerger modelMerger) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/model/impl/DomModelFactoryHelper", "<init>"));
        }
        if (modelMerger == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/xml/model/impl/DomModelFactoryHelper", "<init>"));
        }
        this.myClass = aClass;
        this.myModelMerger = modelMerger;
    }

    @Nullable
    public T getDom(@NotNull XmlFile configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/model/impl/DomModelFactoryHelper", "getDom"));
        }
        DomFileElement<T> element = this.getDomRoot(configFile);
        return element == null ? null : (T)element.getRootElement();
    }

    @Nullable
    public DomFileElement<T> getDomRoot(@NotNull XmlFile configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/model/impl/DomModelFactoryHelper", "getDomRoot"));
        }
        return DomManager.getDomManager(configFile.getProject()).getFileElement(configFile, this.myClass);
    }

    public Class<T> getDomModelClass() {
        return this.myClass;
    }

    public ModelMerger getModelMerger() {
        return this.myModelMerger;
    }
}

