/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomBundle;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import org.jetbrains.annotations.NotNull;

public class RemoveDomElementQuickFix
implements LocalQuickFix {
    private final boolean myIsTag;
    private final String myName;

    public RemoveDomElementQuickFix(@NotNull DomElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/highlighting/RemoveDomElementQuickFix", "<init>"));
        }
        this.myIsTag = element.getXmlElement() instanceof XmlTag;
        this.myName = element.getXmlElementName();
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myIsTag ? DomBundle.message("remove.element.fix.name", this.myName) : DomBundle.message("remove.attribute.fix.name", this.myName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/RemoveDomElementQuickFix", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = DomBundle.message("quick.fixes.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/RemoveDomElementQuickFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/highlighting/RemoveDomElementQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/xml/highlighting/RemoveDomElementQuickFix", "applyFix"));
        }
        if (this.myIsTag) {
            XmlTag tag = (XmlTag)descriptor.getPsiElement();
            XmlTag parentTag = tag.getParentTag();
            DomElement domElement = DomManager.getDomManager(project).getDomElement(tag);
            assert (domElement != null);
            domElement.undefine();
            if (parentTag != null && parentTag.isValid()) {
                parentTag.collapseIfEmpty();
            }
        } else {
            GenericAttributeValue domElement = DomManager.getDomManager(project).getDomElement((XmlAttribute)descriptor.getPsiElement());
            assert (domElement != null);
            domElement.undefine();
        }
    }
}

