/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.converters;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.ide.TypePresentationService;
import com.intellij.pom.PomRenameableTarget;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMemberResolveConverter
extends ResolvingConverter<PsiMember> {
    @Nullable
    protected abstract PsiClass getTargetClass(ConvertContext var1);

    @NotNull
    protected abstract PropertyMemberType[] getMemberTypes(ConvertContext var1);

    @NotNull
    protected PsiType getPsiType(ConvertContext context) {
        PsiClassType psiClassType = PsiType.getJavaLangObject(context.getPsiManager(), ProjectScope.getAllScope(context.getPsiManager().getProject()));
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/converters/AbstractMemberResolveConverter", "getPsiType"));
        }
        return psiClassType;
    }

    protected boolean isLookDeep() {
        return true;
    }

    protected String getPropertyName(String s, ConvertContext context) {
        return s;
    }

    @Override
    public PsiMember fromString(String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        PsiClass psiClass = this.getTargetClass(context);
        if (psiClass == null) {
            return null;
        }
        block5: for (PropertyMemberType type : this.getMemberTypes(context)) {
            switch (type) {
                case FIELD: {
                    PsiField field = psiClass.findFieldByName(s, this.isLookDeep());
                    if (field == null) continue block5;
                    return field;
                }
                case GETTER: {
                    PsiMethod getter = PropertyUtil.findPropertyGetter(psiClass, this.getPropertyName(s, context), false, this.isLookDeep());
                    if (getter == null) continue block5;
                    return getter;
                }
                case SETTER: {
                    PsiMethod setter = PropertyUtil.findPropertySetter(psiClass, this.getPropertyName(s, context), false, this.isLookDeep());
                    if (setter == null) continue block5;
                    return setter;
                }
            }
        }
        return null;
    }

    @Override
    public String toString(PsiMember t, ConvertContext context) {
        return t == null ? null : this.getPropertyName(t.getName(), context);
    }

    @Override
    public String getErrorMessage(String s, ConvertContext context) {
        DomElement parent = context.getInvocationElement().getParent();
        assert (parent != null);
        return CodeInsightBundle.message("error.cannot.resolve.0.1", TypePresentationService.getService().getTypeName(parent), s);
    }

    @Override
    @NotNull
    public Collection<? extends PsiMember> getVariants(ConvertContext context) {
        PsiClass psiClass = this.getTargetClass(context);
        if (psiClass == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/converters/AbstractMemberResolveConverter", "getVariants"));
            }
            return list;
        }
        ArrayList<PomRenameableTarget<PsiElement>> list = new ArrayList<PomRenameableTarget<PsiElement>>();
        for (PsiField psiField : this.isLookDeep() ? psiClass.getAllFields() : psiClass.getFields()) {
            if (!this.fieldSuits(psiField)) continue;
            list.add(psiField);
        }
        for (PomRenameableTarget<PsiElement> pomRenameableTarget : this.isLookDeep() ? psiClass.getAllMethods() : psiClass.getMethods()) {
            if (!this.methodSuits((PsiMethod)pomRenameableTarget)) continue;
            list.add(pomRenameableTarget);
        }
        ArrayList<PomRenameableTarget<PsiElement>> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/converters/AbstractMemberResolveConverter", "getVariants"));
        }
        return arrayList;
    }

    protected boolean methodSuits(PsiMethod psiMethod) {
        return !psiMethod.isConstructor() && !psiMethod.hasModifierProperty("static") && PropertyUtil.getPropertyName(psiMethod) != null;
    }

    protected boolean fieldSuits(PsiField psiField) {
        return !psiField.hasModifierProperty("static");
    }

    @Override
    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        LocalQuickFix[] localQuickFixArray;
        String targetName = ((GenericValue)((Object)context.getInvocationElement())).getStringValue();
        if (!JavaPsiFacade.getInstance(context.getProject()).getNameHelper().isIdentifier(targetName)) {
            return super.getQuickFixes(context);
        }
        PsiClass targetClass = this.getTargetClass(context);
        if (targetClass == null) {
            return super.getQuickFixes(context);
        }
        PropertyMemberType memberType = this.getMemberTypes(context)[0];
        PsiType psiType = this.getPsiType(context);
        IntentionAction fix = QuickFixFactory.getInstance().createCreateFieldOrPropertyFix(targetClass, targetName, psiType, memberType, new PsiAnnotation[0]);
        if (fix instanceof LocalQuickFix) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = (LocalQuickFix)((Object)fix);
        } else {
            localQuickFixArray = super.getQuickFixes(context);
        }
        return localQuickFixArray;
    }

    @Override
    public void handleElementRename(GenericDomValue<PsiMember> genericValue, ConvertContext context, String newElementName) {
        super.handleElementRename(genericValue, context, this.getPropertyName(newElementName, context));
    }

    @Override
    public void bindReference(GenericDomValue<PsiMember> genericValue, ConvertContext context, PsiElement newTarget) {
        if (newTarget instanceof PsiMember) {
            String elementName = ((PsiMember)newTarget).getName();
            genericValue.setStringValue(this.getPropertyName(elementName, context));
        }
    }
}

