/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class JavaMethodSignature {
    private final String myMethodName;
    private final Class[] myMethodParameters;

    public JavaMethodSignature(String methodName, Class ... methodParameters) {
        this.myMethodName = methodName;
        this.myMethodParameters = methodParameters.length == 0 ? ArrayUtil.EMPTY_CLASS_ARRAY : methodParameters;
    }

    public JavaMethodSignature(Method method) {
        this(method.getName(), method.getParameterTypes());
    }

    public String getMethodName() {
        return this.myMethodName;
    }

    @Nullable
    public final Method findMethod(Class aClass) {
        Method method = this.getDeclaredMethod(aClass);
        if (method == null && aClass.isInterface()) {
            method = this.getDeclaredMethod(Object.class);
        }
        return method;
    }

    private void collectMethods(Class aClass, List<Method> methods) {
        this.addMethodWithSupers(aClass, this.findMethod(aClass), methods);
    }

    @Nullable
    private Method getDeclaredMethod(Class aClass) {
        Method method = ReflectionUtil.getMethod((Class)aClass, (String)this.myMethodName, (Class[])this.myMethodParameters);
        return method == null ? ReflectionUtil.getDeclaredMethod((Class)aClass, (String)this.myMethodName, (Class[])this.myMethodParameters) : method;
    }

    private void addMethodWithSupers(Class aClass, Method method, List<Method> methods) {
        Class superClass;
        if (method != null) {
            methods.add(method);
        }
        if ((superClass = aClass.getSuperclass()) != null) {
            this.collectMethods(superClass, methods);
        } else if (aClass.isInterface()) {
            this.collectMethods(Object.class, methods);
        }
        for (Class<?> anInterface : aClass.getInterfaces()) {
            this.collectMethods(anInterface, methods);
        }
    }

    public final List<Method> getAllMethods(Class startFrom) {
        ArrayList<Method> methods = new ArrayList<Method>();
        this.collectMethods(startFrom, methods);
        return methods;
    }

    @Nullable
    public final <T extends Annotation> Method findAnnotatedMethod(Class<T> annotationClass, Class startFrom) {
        for (Method method : this.getAllMethods(startFrom)) {
            T annotation = method.getAnnotation(annotationClass);
            if (annotation == null || !ReflectionUtil.isAssignable(method.getDeclaringClass(), (Class)startFrom)) continue;
            return method;
        }
        return null;
    }

    public String toString() {
        return this.myMethodName + Arrays.asList(this.myMethodParameters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaMethodSignature that = (JavaMethodSignature)o;
        if (!this.myMethodName.equals(that.myMethodName)) {
            return false;
        }
        return Arrays.equals(this.myMethodParameters, that.myMethodParameters);
    }

    public int hashCode() {
        int result = this.myMethodName.hashCode();
        result = 31 * result + Arrays.hashCode(this.myMethodParameters);
        return result;
    }
}

