/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.MergedObject;
import com.intellij.util.xml.NameValue;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import com.intellij.util.xml.reflect.DomGenericInfo;
import com.intellij.xml.util.XmlTagUtil;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.xml.DomUtil");
    public static final TypeVariable<Class<GenericValue>> GENERIC_VALUE_TYPE_VARIABLE = GenericValue.class.getTypeParameters()[0];
    private static final Class<Void> DUMMY = Void.TYPE;
    private static final Key<DomFileElement> FILE_ELEMENT_KEY = Key.create((String)"dom file element");
    private static final ConcurrentFactoryMap<Type, Class> ourTypeParameters = new ConcurrentFactoryMap<Type, Class>(){

        @NotNull
        protected Class create(Type key) {
            Class<?> result = DomUtil.substituteGenericType(GENERIC_VALUE_TYPE_VARIABLE, key);
            Class<?> clazz = result == null ? DUMMY : result;
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/DomUtil$1", "create"));
            }
            return clazz;
        }
    };
    private static final ConcurrentFactoryMap<Pair<Type, Type>, Class> ourVariableSubstitutions = new ConcurrentFactoryMap<Pair<Type, Type>, Class>(){

        @Nullable
        protected Class create(Pair<Type, Type> key) {
            return ReflectionUtil.substituteGenericType((Type)((Type)key.first), (Type)((Type)key.second));
        }
    };

    public static Class extractParameterClassFromGenericType(Type type) {
        return DomUtil.getGenericValueParameter(type);
    }

    public static boolean isGenericValueType(Type type) {
        return DomUtil.getGenericValueParameter(type) != null;
    }

    @Nullable
    public static <T extends DomElement> T findByName(@NotNull Collection<T> list, @NonNls @NotNull String name) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/DomUtil", "findByName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/xml/DomUtil", "findByName"));
        }
        for (DomElement element : list) {
            String elementName = element.getGenericInfo().getElementName(element);
            if (elementName == null || !elementName.equals(name)) continue;
            return (T)element;
        }
        return null;
    }

    @NotNull
    public static String[] getElementNames(@NotNull Collection<? extends DomElement> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/DomUtil", "getElementNames"));
        }
        ArrayList<String> result = new ArrayList<String>(list.size());
        if (list.size() > 0) {
            for (DomElement domElement : list) {
                String name = domElement.getGenericInfo().getElementName(domElement);
                if (name == null) continue;
                result.add(name);
            }
        }
        String[] stringArray = ArrayUtil.toStringArray(result);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/DomUtil", "getElementNames"));
        }
        return stringArray;
    }

    @NotNull
    public static List<XmlTag> getElementTags(@NotNull Collection<? extends DomElement> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/DomUtil", "getElementTags"));
        }
        ArrayList<XmlTag> result = new ArrayList<XmlTag>(list.size());
        for (DomElement domElement : list) {
            XmlTag tag = domElement.getXmlTag();
            if (tag == null) continue;
            result.add(tag);
        }
        ArrayList<XmlTag> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/DomUtil", "getElementTags"));
        }
        return arrayList;
    }

    @NotNull
    public static XmlTag[] getElementTags(@NotNull DomElement[] list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/DomUtil", "getElementTags"));
        }
        XmlTag[] result = new XmlTag[list.length];
        int i = 0;
        for (DomElement element : list) {
            XmlTag tag = element.getXmlTag();
            if (tag == null) continue;
            result[i++] = tag;
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/DomUtil", "getElementTags"));
        }
        return result;
    }

    @Nullable
    public static List<JavaMethod> getFixedPath(DomElement element) {
        DomElement parent;
        assert (element.isValid());
        LinkedList<JavaMethod> methods = new LinkedList<JavaMethod>();
        while (!((parent = element.getParent()) instanceof DomFileElement)) {
            JavaMethod method = DomUtil.getGetterMethod(element, parent);
            if (method == null) {
                return null;
            }
            methods.addFirst(method);
            element = element.getParent();
        }
        return methods;
    }

    @Nullable
    private static JavaMethod getGetterMethod(DomElement element, DomElement parent) {
        String xmlElementName = element.getXmlElementName();
        String namespace = element.getXmlElementNamespaceKey();
        DomGenericInfo genericInfo = parent.getGenericInfo();
        if (element instanceof GenericAttributeValue) {
            DomAttributeChildDescription description = genericInfo.getAttributeChildDescription(xmlElementName, namespace);
            assert (description != null);
            return description.getGetterMethod();
        }
        DomFixedChildDescription description = genericInfo.getFixedChildDescription(xmlElementName, namespace);
        return description != null ? description.getGetterMethod(description.getValues(parent).indexOf(element)) : null;
    }

    public static Class<?> substituteGenericType(Type genericType, Type classType) {
        return (Class)ourVariableSubstitutions.get((Object)Pair.create((Object)genericType, (Object)classType));
    }

    @Nullable
    public static Class getGenericValueParameter(Type type) {
        Class aClass = (Class)ourTypeParameters.get((Object)type);
        return aClass == DUMMY ? null : aClass;
    }

    @Nullable
    public static XmlElement getValueElement(GenericDomValue domValue) {
        if (domValue instanceof GenericAttributeValue) {
            GenericAttributeValue value = (GenericAttributeValue)domValue;
            XmlAttributeValue attributeValue = value.getXmlAttributeValue();
            return attributeValue == null ? value.getXmlAttribute() : attributeValue;
        }
        return domValue.getXmlTag();
    }

    public static List<? extends DomElement> getIdentitySiblings(DomElement element) {
        String tagName;
        GenericDomValue nameDomElement = element.getGenericInfo().getNameDomElement(element);
        if (nameDomElement == null) {
            return Collections.emptyList();
        }
        NameValue nameValue = nameDomElement.getAnnotation(NameValue.class);
        if (nameValue == null || !nameValue.unique()) {
            return Collections.emptyList();
        }
        String stringValue = ElementPresentationManager.getElementName(element);
        if (stringValue == null) {
            return Collections.emptyList();
        }
        DomElement scope = element.getManager().getIdentityScope(element);
        if (scope == null) {
            return Collections.emptyList();
        }
        DomGenericInfo domGenericInfo = scope.getGenericInfo();
        DomCollectionChildDescription childDescription = domGenericInfo.getCollectionChildDescription(tagName = element.getXmlElementName(), element.getXmlElementNamespaceKey());
        if (childDescription != null) {
            ArrayList<? extends DomElement> list = new ArrayList<DomElement>(childDescription.getValues(scope));
            list.remove(element);
            return list;
        }
        return Collections.emptyList();
    }

    public static <T> List<T> getChildrenOfType(@NotNull DomElement parent, final Class<T> type) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/DomUtil", "getChildrenOfType"));
        }
        SmartList result = new SmartList();
        parent.acceptChildren(new DomElementVisitor((List)result){
            final /* synthetic */ List val$result;
            {
                this.val$result = list;
            }

            @Override
            public void visitDomElement(DomElement element) {
                if (type.isInstance(element)) {
                    this.val$result.add(element);
                }
            }
        });
        return result;
    }

    public static List<DomElement> getDefinedChildren(@NotNull DomElement parent, boolean tags, boolean attributes) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/DomUtil", "getDefinedChildren"));
        }
        if (parent instanceof MergedObject) {
            final SmartList result = new SmartList();
            parent.acceptChildren(new DomElementVisitor(){

                @Override
                public void visitDomElement(DomElement element) {
                    if (DomUtil.hasXml(element)) {
                        result.add((Object)element);
                    }
                }
            });
            return result;
        }
        ProgressManager.checkCanceled();
        if (parent instanceof GenericAttributeValue) {
            return Collections.emptyList();
        }
        if (parent instanceof DomFileElement) {
            DomFileElement element = (DomFileElement)parent;
            return tags ? Arrays.asList(element.getRootElement()) : Collections.emptyList();
        }
        XmlElement xmlElement = parent.getXmlElement();
        if (xmlElement instanceof XmlTag) {
            DomElement element;
            XmlTag tag = (XmlTag)xmlElement;
            DomManager domManager = parent.getManager();
            SmartList result = new SmartList();
            if (attributes) {
                for (XmlElement xmlElement2 : tag.getAttributes()) {
                    if (!xmlElement2.isValid()) {
                        LOG.error("Invalid attr: parent.valid=" + tag.isValid());
                        continue;
                    }
                    element = domManager.getDomElement((XmlAttribute)xmlElement2);
                    if (!DomUtil.checkHasXml(xmlElement2, element)) continue;
                    ContainerUtil.addIfNotNull((Object)element, (Collection)result);
                }
            }
            if (tags) {
                for (XmlElement xmlElement3 : tag.getSubTags()) {
                    if (!xmlElement3.isValid()) {
                        LOG.error("Invalid subtag: parent.valid=" + tag.isValid());
                        continue;
                    }
                    element = domManager.getDomElement((XmlTag)xmlElement3);
                    if (!DomUtil.checkHasXml(xmlElement3, element)) continue;
                    ContainerUtil.addIfNotNull((Object)element, (Collection)result);
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static boolean checkHasXml(XmlElement psi, DomElement dom) {
        if (dom != null && dom.getXmlElement() == null) {
            LOG.error("No xml for dom " + dom + "; attr=" + psi + ", physical=" + psi.isPhysical());
            return false;
        }
        return true;
    }

    public static <T> List<T> getDefinedChildrenOfType(@NotNull DomElement parent, Class<T> type, boolean tags, boolean attributes) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/DomUtil", "getDefinedChildrenOfType"));
        }
        return ContainerUtil.findAll(DomUtil.getDefinedChildren(parent, tags, attributes), type);
    }

    public static <T> List<T> getDefinedChildrenOfType(@NotNull DomElement parent, Class<T> type) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/DomUtil", "getDefinedChildrenOfType"));
        }
        return DomUtil.getDefinedChildrenOfType(parent, type, true, true);
    }

    @Nullable
    public static DomElement findDuplicateNamedValue(DomElement element, String newName) {
        return ElementPresentationManager.findByName(DomUtil.getIdentitySiblings(element), newName);
    }

    public static boolean isAncestor(@NotNull DomElement ancestor, @NotNull DomElement descendant, boolean strict) {
        if (ancestor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/DomUtil", "isAncestor"));
        }
        if (descendant == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/xml/DomUtil", "isAncestor"));
        }
        if (!strict && ancestor.equals(descendant)) {
            return true;
        }
        DomElement parent = descendant.getParent();
        return parent != null && DomUtil.isAncestor(ancestor, parent, false);
    }

    public static void acceptAvailableChildren(DomElement element, DomElementVisitor visitor) {
        XmlTag tag = element.getXmlTag();
        if (tag != null) {
            for (XmlTag xmlTag : tag.getSubTags()) {
                DomElement childElement = element.getManager().getDomElement(xmlTag);
                if (childElement == null) continue;
                childElement.accept(visitor);
            }
        }
    }

    public static Collection<Class> getAllInterfaces(Class aClass, Collection<Class> result) {
        Object[] interfaces = aClass.getInterfaces();
        ContainerUtil.addAll(result, (Object[])interfaces);
        if (aClass.getSuperclass() != null) {
            DomUtil.getAllInterfaces(aClass.getSuperclass(), result);
        }
        for (Object anInterface : interfaces) {
            DomUtil.getAllInterfaces((Class)anInterface, result);
        }
        return result;
    }

    @Nullable
    public static <T> T getParentOfType(DomElement element, Class<T> requiredClass, boolean strict) {
        DomElement curElement;
        DomElement domElement = curElement = strict && element != null ? element.getParent() : element;
        while (curElement != null) {
            if (requiredClass.isInstance(curElement)) {
                return (T)curElement;
            }
            curElement = curElement.getParent();
        }
        return null;
    }

    @Nullable
    public static <T> T getContextElement(@Nullable Editor editor, Class<T> clazz) {
        DomElement element = DomUtil.getContextElement(editor);
        return DomUtil.getParentOfType(element, clazz, false);
    }

    @Nullable
    public static DomElement getContextElement(@Nullable Editor editor) {
        if (editor == null) {
            return null;
        }
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        PsiFile file = PsiDocumentManager.getInstance(project).getPsiFile(editor.getDocument());
        if (!(file instanceof XmlFile)) {
            return null;
        }
        return DomUtil.getDomElement(file.findElementAt(editor.getCaretModel().getOffset()));
    }

    @Nullable
    public static DomElement getDomElement(Editor editor, PsiFile file) {
        return DomUtil.getDomElement(file.findElementAt(editor.getCaretModel().getOffset()));
    }

    @Nullable
    public static DomElement getDomElement(@Nullable PsiElement element) {
        GenericAttributeValue value;
        if (element == null) {
            return null;
        }
        Project project = element.getProject();
        DomManager domManager = DomManager.getDomManager(project);
        XmlAttribute attr = PsiTreeUtil.getParentOfType(element, XmlAttribute.class, false);
        if (attr != null && (value = domManager.getDomElement(attr)) != null) {
            return value;
        }
        for (XmlTag tag = PsiTreeUtil.getParentOfType(element, XmlTag.class, false); tag != null; tag = tag.getParentTag()) {
            DomElement domElement = domManager.getDomElement(tag);
            if (domElement == null) continue;
            return domElement;
        }
        return null;
    }

    @NotNull
    public static <T extends DomElement> T getOriginalElement(@NotNull T domElement) {
        if (domElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/DomUtil", "getOriginalElement"));
        }
        XmlElement psiElement = domElement.getXmlElement();
        if (psiElement == null) {
            T t = domElement;
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/DomUtil", "getOriginalElement"));
            }
            return t;
        }
        PsiFile psiFile = psiElement.getContainingFile().getOriginalFile();
        TextRange range = psiElement.getTextRange();
        PsiElement element = psiFile.findElementAt(range.getStartOffset());
        int maxLength = range.getLength();
        boolean isAttribute = psiElement instanceof XmlAttribute;
        Class clazz = isAttribute ? XmlAttribute.class : XmlTag.class;
        DomManager domManager = domElement.getManager();
        DomElement current = null;
        XmlElement next = PsiTreeUtil.getParentOfType(element, clazz, false);
        while (next != null && next.getTextLength() <= maxLength) {
            DomElement domElement2 = current = isAttribute ? domManager.getDomElement((XmlAttribute)next) : domManager.getDomElement((XmlTag)next);
            if (current != null && domElement.getClass() != current.getClass()) {
                current = null;
            }
            next = PsiTreeUtil.getParentOfType((PsiElement)next, clazz, true);
        }
        DomElement domElement3 = current;
        if (domElement3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/DomUtil", "getOriginalElement"));
        }
        return (T)domElement3;
    }

    public static <T extends DomElement> T addElementAfter(@NotNull T anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/DomUtil", "addElementAfter"));
        }
        DomElement parent = anchor.getParent();
        DomCollectionChildDescription childDescription = (DomCollectionChildDescription)anchor.getChildDescription();
        assert (parent != null);
        List<? extends DomElement> list = childDescription.getValues(parent);
        int i = list.indexOf(anchor);
        assert (i >= 0);
        return (T)childDescription.addValue(parent, i + 1);
    }

    @Nullable
    public static <T extends DomElement> T findDomElement(@Nullable PsiElement element, Class<T> beanClass) {
        return DomUtil.findDomElement(element, beanClass, true);
    }

    @Nullable
    public static <T extends DomElement> T findDomElement(@Nullable PsiElement element, Class<T> beanClass, boolean strict) {
        if (element == null) {
            return null;
        }
        for (XmlTag tag = PsiTreeUtil.getParentOfType(element, XmlTag.class, strict); tag != null; tag = tag.getParentTag()) {
            DomElement domElement = DomManager.getDomManager(tag.getProject()).getDomElement(tag);
            if (domElement == null) continue;
            return domElement.getParentOfType(beanClass, false);
        }
        return null;
    }

    public static <T extends DomElement> DomFileElement<T> getFileElement(@NotNull DomElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/DomUtil", "getFileElement"));
        }
        if (element instanceof DomFileElement) {
            return (DomFileElement)element;
        }
        DomFileElement<T> fileElement = (DomFileElement<T>)element.getUserData(FILE_ELEMENT_KEY);
        if (fileElement == null) {
            DomElement parent = element.getParent();
            if (parent != null) {
                fileElement = DomUtil.getFileElement(parent);
            }
            element.putUserData(FILE_ELEMENT_KEY, fileElement);
        }
        return fileElement;
    }

    @NotNull
    public static XmlFile getFile(@NotNull DomElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/DomUtil", "getFile"));
        }
        XmlFile xmlFile = DomService.getInstance().getContainingFile(element);
        if (xmlFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/DomUtil", "getFile"));
        }
        return xmlFile;
    }

    @NotNull
    public static DomElement getRoot(@NotNull DomElement domElement) {
        if (domElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/DomUtil", "getRoot"));
        }
        while (true) {
            DomElement parent;
            if ((parent = domElement.getParent()) == null) {
                DomElement domElement2 = domElement;
                if (domElement2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/DomUtil", "getRoot"));
                }
                return domElement2;
            }
            domElement = parent;
        }
    }

    public static boolean hasXml(@NotNull DomElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/DomUtil", "hasXml"));
        }
        return element.getXmlElement() != null;
    }

    public static Pair<TextRange, PsiElement> getProblemRange(XmlTag tag) {
        XmlToken startToken = XmlTagUtil.getStartTagNameElement(tag);
        if (startToken == null) {
            return Pair.create((Object)tag.getTextRange(), (Object)tag);
        }
        return Pair.create((Object)startToken.getTextRange().shiftRight(-tag.getTextRange().getStartOffset()), (Object)tag);
    }

    public static <T extends DomElement> List<T> getChildrenOf(DomElement parent, Class<T> type) {
        SmartList list = new SmartList();
        List<? extends AbstractDomChildrenDescription> descriptions = parent.getGenericInfo().getChildrenDescriptions();
        int descriptionsSize = descriptions.size();
        for (int i = 0; i < descriptionsSize; ++i) {
            AbstractDomChildrenDescription description = descriptions.get(i);
            if (!(description.getType() instanceof Class) || !type.isAssignableFrom((Class)description.getType())) continue;
            List<? extends DomElement> values = description.getValues(parent);
            int valuesSize = values.size();
            for (int j = 0; j < valuesSize; ++j) {
                DomElement value = values.get(j);
                if (!value.exists()) continue;
                list.add(value);
            }
        }
        return list;
    }
}

