/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class VcsBackgroundTask<T>
extends Task.ConditionalModal {
    private final Collection<T> myItems;
    private final List<VcsException> myExceptions;

    public VcsBackgroundTask(Project project, @NotNull String title, @NotNull PerformInBackgroundOption backgroundOption, Collection<T> itemsToProcess, boolean canBeCanceled) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/ui/VcsBackgroundTask", "<init>"));
        }
        if (backgroundOption == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/ui/VcsBackgroundTask", "<init>"));
        }
        super(project, title, canBeCanceled, backgroundOption);
        this.myExceptions = new ArrayList<VcsException>();
        this.myItems = itemsToProcess;
    }

    public VcsBackgroundTask(Project project, @NotNull String title, @NotNull PerformInBackgroundOption backgroundOption, Collection<T> itemsToProcess) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/ui/VcsBackgroundTask", "<init>"));
        }
        if (backgroundOption == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/ui/VcsBackgroundTask", "<init>"));
        }
        this(project, title, backgroundOption, itemsToProcess, false);
    }

    @Override
    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ui/VcsBackgroundTask", "run"));
        }
        for (T item : this.myItems) {
            try {
                this.process(item);
            }
            catch (VcsException ex) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    throw new RuntimeException(ex);
                }
                this.myExceptions.add(ex);
            }
        }
    }

    protected boolean executedOk() {
        return this.myExceptions.isEmpty();
    }

    @Override
    public void onSuccess() {
        if (!this.myExceptions.isEmpty()) {
            AbstractVcsHelper.getInstance(this.myProject).showErrors(this.myExceptions, this.myTitle);
        }
    }

    protected abstract void process(T var1) throws VcsException;
}

