/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import com.intellij.util.ui.Line;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class EditorAdapter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.ui.EditorAdapter");
    private final Editor myEditor;
    private final Alarm myFlushAlarm;
    private final Collection<Line> myLines;
    private final Project myProject;
    private final boolean myScrollToTheEndOnAppend;
    private final Runnable myFlushDeferredRunnable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void flushStoredLines() {
        ArrayList<Line> lines;
        Collection<Line> collection = this.myLines;
        synchronized (collection) {
            lines = new ArrayList<Line>(this.myLines);
            this.myLines.clear();
        }
        ApplicationManager.getApplication().runWriteAction(this.writingCommand(lines));
    }

    public EditorAdapter(@NotNull Editor editor, Project project, boolean scrollToTheEndOnAppend) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ui/EditorAdapter", "<init>"));
        }
        this.myFlushAlarm = new Alarm();
        this.myLines = new ArrayList<Line>();
        this.myFlushDeferredRunnable = new Runnable(){

            @Override
            public void run() {
                EditorAdapter.this.flushStoredLines();
            }
        };
        this.myEditor = editor;
        this.myProject = project;
        this.myScrollToTheEndOnAppend = scrollToTheEndOnAppend;
        LOG.assertTrue(this.myEditor.isViewer());
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/EditorAdapter", "getEditor"));
        }
        return editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(String string, TextAttributes attrs) {
        Collection<Line> collection = this.myLines;
        synchronized (collection) {
            this.myLines.add(new Line(string, attrs));
        }
        if (this.myFlushAlarm.isEmpty()) {
            this.myFlushAlarm.addRequest(this.myFlushDeferredRunnable, 200, ModalityState.NON_MODAL);
        }
    }

    private Runnable writingCommand(final Collection<Line> lines) {
        final Runnable command = new Runnable(){

            @Override
            public void run() {
                int endBefore;
                Document document = EditorAdapter.this.myEditor.getDocument();
                StringBuilder buffer = new StringBuilder();
                for (Line line : lines) {
                    buffer.append(line.getValue());
                }
                int endBeforeLine = endBefore = document.getTextLength();
                document.insertString(endBefore, buffer.toString());
                for (Line line : lines) {
                    EditorAdapter.this.myEditor.getMarkupModel().addRangeHighlighter(endBeforeLine, Math.min(document.getTextLength(), endBeforeLine + line.getValue().length()), 3000, line.getAttributes(), HighlighterTargetArea.EXACT_RANGE);
                    if ((endBeforeLine += line.getValue().length()) <= document.getTextLength()) continue;
                    break;
                }
                EditorAdapter.this.shiftCursorToTheEndOfDocument();
            }
        };
        return new Runnable(){

            @Override
            public void run() {
                CommandProcessor.getInstance().executeCommand(EditorAdapter.this.myProject, command, "", null, UndoConfirmationPolicy.DEFAULT, EditorAdapter.this.myEditor.getDocument());
            }
        };
    }

    private void shiftCursorToTheEndOfDocument() {
        if (this.myScrollToTheEndOnAppend) {
            this.myEditor.getCaretModel().moveToOffset(this.myEditor.getDocument().getTextLength());
            this.myEditor.getSelectionModel().removeSelection();
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }
}

