/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightColors;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class ButtonlessScrollBarUI
extends BasicScrollBarUI {
    private static final BasicStroke BORDER_STROKE = new BasicStroke();
    private final AdjustmentListener myAdjustmentListener = new AdjustmentListener(){

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            ButtonlessScrollBarUI.this.resetAnimator();
        }
    };
    private final MouseMotionAdapter myMouseMotionListener = new MouseMotionAdapter(){

        @Override
        public void mouseMoved(MouseEvent e) {
            boolean inside = ButtonlessScrollBarUI.this.isOverThumb(e.getPoint());
            if (inside != ButtonlessScrollBarUI.this.myMouseIsOverThumb) {
                ButtonlessScrollBarUI.this.myMouseIsOverThumb = inside;
                ButtonlessScrollBarUI.this.resetAnimator();
            }
        }
    };
    private final MouseAdapter myMouseListener = new MouseAdapter(){

        @Override
        public void mouseExited(MouseEvent e) {
            if (ButtonlessScrollBarUI.this.myMouseIsOverThumb) {
                ButtonlessScrollBarUI.this.myMouseIsOverThumb = false;
                ButtonlessScrollBarUI.this.resetAnimator();
            }
        }
    };
    private Animator myAnimator;
    private int myAnimationColorShift = 0;
    private boolean myMouseIsOverThumb = false;
    public static final int DELAY_FRAMES = 4;
    public static final int FRAMES_COUNT = 14;

    public static JBColor getGradientLightColor() {
        return new JBColor((Color)Gray._251, (Color)Gray._95);
    }

    public static JBColor getGradientDarkColor() {
        return new JBColor((Color)Gray._215, (Color)Gray._80);
    }

    private static JBColor getGradientThumbBorderColor() {
        return new JBColor((Color)Gray._201, (Color)Gray._85);
    }

    public static JBColor getTrackBackground() {
        return new JBColor(LightColors.SLIGHTLY_GRAY, UIUtil.getListBackground());
    }

    public static JBColor getTrackBorderColor() {
        return new JBColor((Color)Gray._230, UIUtil.getListBackground());
    }

    private static int getAnimationColorShift() {
        return UIUtil.isUnderDarcula() ? 20 : 40;
    }

    protected ButtonlessScrollBarUI() {
    }

    @Override
    public void layoutContainer(Container scrollbarContainer) {
        try {
            super.layoutContainer(scrollbarContainer);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    protected BasicScrollBarUI.ModelListener createModelListener() {
        return new BasicScrollBarUI.ModelListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ButtonlessScrollBarUI.this.scrollbar != null) {
                    super.stateChanged(e);
                }
            }
        };
    }

    public int getDecrementButtonHeight() {
        return this.decrButton.getHeight();
    }

    public int getIncrementButtonHeight() {
        return this.incrButton.getHeight();
    }

    private void resetAnimator() {
        this.myAnimator.reset();
        if (this.scrollbar != null && this.scrollbar.getValueIsAdjusting() || this.myMouseIsOverThumb || Registry.is((String)"ui.no.bangs.and.whistles")) {
            this.myAnimator.suspend();
            this.myAnimationColorShift = ButtonlessScrollBarUI.getAnimationColorShift();
        } else {
            this.myAnimator.resume();
        }
    }

    public static BasicScrollBarUI createNormal() {
        return new ButtonlessScrollBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.scrollbar.setFocusable(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void installDefaults() {
        int incGap = UIManager.getInt("ScrollBar.incrementButtonGap");
        int decGap = UIManager.getInt("ScrollBar.decrementButtonGap");
        try {
            UIManager.put("ScrollBar.incrementButtonGap", 0);
            UIManager.put("ScrollBar.decrementButtonGap", 0);
            super.installDefaults();
        }
        finally {
            UIManager.put("ScrollBar.incrementButtonGap", incGap);
            UIManager.put("ScrollBar.decrementButtonGap", decGap);
        }
    }

    @Override
    protected void installListeners() {
        if (this.myAnimator == null || this.myAnimator.isDisposed()) {
            this.myAnimator = this.createAnimator();
        }
        super.installListeners();
        this.scrollbar.addAdjustmentListener(this.myAdjustmentListener);
        this.scrollbar.addMouseListener(this.myMouseListener);
        this.scrollbar.addMouseMotionListener(this.myMouseMotionListener);
    }

    private Animator createAnimator() {
        return new Animator("Adjustment fadeout", 14, 700, false){

            @Override
            public void paintNow(int frame, int totalFrames, int cycle) {
                ButtonlessScrollBarUI.this.myAnimationColorShift = ButtonlessScrollBarUI.getAnimationColorShift();
                if (frame > 4) {
                    ButtonlessScrollBarUI.this.myAnimationColorShift = (int)((double)ButtonlessScrollBarUI.this.myAnimationColorShift * (1.0 - (double)(frame - 4) / (double)(totalFrames - 4)));
                }
                if (ButtonlessScrollBarUI.this.scrollbar != null) {
                    ButtonlessScrollBarUI.this.scrollbar.repaint(((ButtonlessScrollBarUI)ButtonlessScrollBarUI.this.scrollbar.getUI()).getThumbBounds());
                }
            }
        };
    }

    private boolean isOverThumb(Point p) {
        Rectangle bounds = this.getThumbBounds();
        return bounds != null && bounds.contains(p);
    }

    @Override
    public Rectangle getThumbBounds() {
        return super.getThumbBounds();
    }

    @Override
    protected void uninstallListeners() {
        if (this.scrollTimer != null) {
            super.uninstallListeners();
        }
        this.scrollbar.removeAdjustmentListener(this.myAdjustmentListener);
        Disposer.dispose((Disposable)this.myAnimator);
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle bounds) {
        g.setColor((Color)ButtonlessScrollBarUI.getTrackBackground());
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        g.setColor((Color)ButtonlessScrollBarUI.getTrackBorderColor());
        if (this.isVertical()) {
            g.drawLine(bounds.x, bounds.y, bounds.x, bounds.y + bounds.height);
        } else {
            g.drawLine(bounds.x, bounds.y, bounds.x + bounds.width, bounds.y);
        }
    }

    @Override
    protected Dimension getMinimumThumbSize() {
        int thickness = this.getThickness();
        return this.isVertical() ? new Dimension(thickness, thickness * 2) : new Dimension(thickness * 2, thickness);
    }

    protected int getThickness() {
        return 13;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        int thickness = this.getThickness();
        return new Dimension(thickness, thickness);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getMaximumSize(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getMaximumSize(c);
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (thumbBounds.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        g.translate(thumbBounds.x, thumbBounds.y);
        this.paintMaxiThumb((Graphics2D)g, thumbBounds);
        g.translate(-thumbBounds.x, -thumbBounds.y);
    }

    private void paintMaxiThumb(Graphics2D g, Rectangle thumbBounds) {
        boolean vertical = this.isVertical();
        int hGap = vertical ? 2 : 1;
        int vGap = vertical ? 1 : 2;
        int w = this.adjustThumbWidth(thumbBounds.width - hGap * 2);
        int h = thumbBounds.height - vGap * 2;
        if (vertical) {
            --h;
        } else {
            --w;
        }
        Color start = this.adjustColor((Color)ButtonlessScrollBarUI.getGradientLightColor());
        Color end = this.adjustColor((Color)ButtonlessScrollBarUI.getGradientDarkColor());
        Paint paint = vertical ? UIUtil.getGradientPaint((float)1.0f, (float)0.0f, (Color)start, (float)(w + 1), (float)0.0f, (Color)end) : UIUtil.getGradientPaint((float)0.0f, (float)1.0f, (Color)start, (float)0.0f, (float)(h + 1), (Color)end);
        g.setPaint(paint);
        g.fillRect(hGap + 1, vGap + 1, w - 1, h - 1);
        Stroke stroke = g.getStroke();
        g.setStroke(BORDER_STROKE);
        g.setColor((Color)ButtonlessScrollBarUI.getGradientThumbBorderColor());
        g.drawRoundRect(hGap, vGap, w, h, 3, 3);
        g.setStroke(stroke);
    }

    @Override
    public boolean getSupportsAbsolutePositioning() {
        return true;
    }

    protected int adjustThumbWidth(int width) {
        return width;
    }

    protected Color adjustColor(Color c) {
        if (this.myAnimationColorShift == 0) {
            return c;
        }
        int sign = UIUtil.isUnderDarcula() ? -1 : 1;
        return Gray.get((int)Math.max(0, Math.min(255, c.getRed() - sign * this.myAnimationColorShift)));
    }

    private boolean isVertical() {
        return this.scrollbar.getOrientation() == 1;
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return new EmptyButton();
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return new EmptyButton();
    }

    private static class EmptyButton
    extends JButton {
        private EmptyButton() {
            this.setFocusable(false);
            this.setRequestFocusEnabled(false);
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(0, 0);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMaximumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getMaximumSize();
        }
    }
}

