/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net.ssl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.util.net.ssl.CertificateWrapper;
import java.io.Closeable;
import java.io.FileInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CertificateUtil {
    private static final Logger LOG = Logger.getInstance(CertificateUtil.class);
    private static final CertificateFactory ourFactory = CertificateUtil.createFactory();
    @Nls
    public static final String X509 = "X.509";
    @Nls
    public static final String JKS = "JKS";
    @Nls
    public static final String PKCS12 = "PKCS12";
    @Nls
    public static final String PKIX = "PKIX";
    @Nls
    public static final String TLS = "TLS";

    private static CertificateFactory createFactory() {
        try {
            return CertificateFactory.getInstance("X509");
        }
        catch (CertificateException e) {
            throw new AssertionError((Object)"Can't initialize X509 certificate factory");
        }
    }

    private CertificateUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static X509Certificate loadX509Certificate(@NotNull String path) {
        X509Certificate x509Certificate;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/net/ssl/CertificateUtil", "loadX509Certificate"));
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(path);
            x509Certificate = (X509Certificate)ourFactory.generateCertificate(stream);
        }
        catch (Exception e) {
            X509Certificate x509Certificate2;
            try {
                LOG.error("Can't add certificate for path: " + path, (Throwable)e);
                x509Certificate2 = null;
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(stream);
                throw throwable;
            }
            StreamUtil.closeStream((Closeable)stream);
            return x509Certificate2;
        }
        StreamUtil.closeStream((Closeable)stream);
        return x509Certificate;
    }

    public static String getCommonName(@NotNull X509Certificate certificate) {
        if (certificate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/net/ssl/CertificateUtil", "getCommonName"));
        }
        return new CertificateWrapper(certificate).getSubjectField(CertificateWrapper.CommonField.COMMON_NAME);
    }
}

