/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net.ssl;

import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.net.ssl.CertificateWrapper;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.jetbrains.annotations.NotNull;

public class CertificateInfoPanel
extends JPanel {
    private static DateFormat DATE_FORMAT = DateFormat.getDateInstance(3);
    private JPanel myPanel;
    private final CertificateWrapper myCertificateWrapper;

    public CertificateInfoPanel(@NotNull X509Certificate certificate) {
        if (certificate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/net/ssl/CertificateInfoPanel", "<init>"));
        }
        this.myCertificateWrapper = new CertificateWrapper(certificate);
        this.setLayout(new BorderLayout());
        FormBuilder builder = FormBuilder.createFormBuilder();
        builder = CertificateInfoPanel.updateBuilderWithTitle(builder, "Issued To");
        builder = CertificateInfoPanel.updateBuilderWithPrincipalData(builder, this.myCertificateWrapper.getSubjectFields());
        builder = CertificateInfoPanel.updateBuilderWithTitle(builder, "Issued By");
        builder = CertificateInfoPanel.updateBuilderWithPrincipalData(builder, this.myCertificateWrapper.getIssuerFields());
        builder = CertificateInfoPanel.updateBuilderWithTitle(builder, "Validity Period");
        String notBefore = DATE_FORMAT.format(this.myCertificateWrapper.getNotBefore());
        String notAfter = DATE_FORMAT.format(this.myCertificateWrapper.getNotAfter());
        builder = builder.setIndent(20).addLabeledComponent("Valid from:", CertificateInfoPanel.createColoredComponent(notBefore, "not yet valid", this.myCertificateWrapper.isNotYetValid())).addLabeledComponent("Valid until:", CertificateInfoPanel.createColoredComponent(notAfter, "expired", this.myCertificateWrapper.isExpired()));
        builder = builder.setIndent(0);
        builder = CertificateInfoPanel.updateBuilderWithTitle(builder, "Fingerprints");
        builder = builder.setIndent(20);
        builder = builder.addLabeledComponent("SHA-256:", CertificateInfoPanel.getTextPane(CertificateInfoPanel.formatHex(this.myCertificateWrapper.getSha256Fingerprint())));
        builder = builder.addLabeledComponent("SHA-1:", CertificateInfoPanel.getTextPane(CertificateInfoPanel.formatHex(this.myCertificateWrapper.getSha1Fingerprint())));
        this.add((Component)builder.getPanel(), "North");
        SimpleColoredComponent component = new SimpleColoredComponent();
    }

    @NotNull
    private static String formatHex(@NotNull String hex) {
        if (hex == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/net/ssl/CertificateInfoPanel", "formatHex"));
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < hex.length(); i += 2) {
            if (i == 32) {
                builder.append('\n');
            }
            builder.append(hex.substring(i, i + 2));
            builder.append(' ');
        }
        if (hex.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        String string = builder.toString().toUpperCase();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/ssl/CertificateInfoPanel", "formatHex"));
        }
        return string;
    }

    public X509Certificate getCertificate() {
        return this.myCertificateWrapper.getCertificate();
    }

    private static FormBuilder updateBuilderWithPrincipalData(FormBuilder builder, Map<String, String> fields) {
        builder = builder.setIndent(20);
        for (CertificateWrapper.CommonField field : CertificateWrapper.CommonField.values()) {
            String value = fields.get(field.getShortName());
            if (value == null) continue;
            String label = String.format("<html>%s (<b>%s</b>)</html>", field.getShortName(), field.getLongName());
            builder = builder.addLabeledComponent(label, (JComponent)new JBLabel(value));
        }
        return builder.setIndent(0);
    }

    private static FormBuilder updateBuilderWithTitle(FormBuilder builder, String title) {
        return builder.addComponent(new TitledSeparator(title), 7);
    }

    private static JComponent getTextPane(String text) {
        JTextPane pane = new JTextPane();
        pane.setOpaque(false);
        pane.setEditable(false);
        pane.setContentType("text/plain");
        pane.setText(text);
        return pane;
    }

    private static JComponent createColoredComponent(String mainText, String errorText, boolean hasError) {
        SimpleColoredComponent component = new SimpleColoredComponent();
        if (hasError) {
            component.append(mainText + " (" + errorText + ")", new SimpleTextAttributes(0, (Color)JBColor.RED));
        } else {
            component.append(mainText);
        }
        return component;
    }
}

