/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.usages.rules.UsageInLibrary;
import com.intellij.usages.rules.UsageInModule;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ModuleGroupingRule
implements UsageGroupingRule {
    @Override
    public UsageGroup groupUsage(@NotNull Usage usage) {
        UsageInLibrary usageInLibrary;
        OrderEntry entry;
        UsageInModule usageInModule;
        Module module;
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/rules/ModuleGroupingRule", "groupUsage"));
        }
        if (usage instanceof UsageInModule && (module = (usageInModule = (UsageInModule)usage).getModule()) != null) {
            return new ModuleUsageGroup(module);
        }
        if (usage instanceof UsageInLibrary && (entry = (usageInLibrary = (UsageInLibrary)usage).getLibraryEntry()) != null) {
            return new LibraryUsageGroup(entry);
        }
        return null;
    }

    private static class ModuleUsageGroup
    implements UsageGroup,
    TypeSafeDataProvider {
        private final Module myModule;

        public ModuleUsageGroup(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/rules/ModuleGroupingRule$ModuleUsageGroup", "<init>"));
            }
            this.myModule = module;
        }

        @Override
        public void update() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ModuleUsageGroup)) {
                return false;
            }
            ModuleUsageGroup moduleUsageGroup = (ModuleUsageGroup)o;
            return this.myModule.equals(moduleUsageGroup.myModule);
        }

        public int hashCode() {
            return this.myModule.hashCode();
        }

        @Override
        public Icon getIcon(boolean isOpen) {
            return this.myModule.isDisposed() ? null : ModuleType.get(this.myModule).getIcon();
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            String string = this.myModule.isDisposed() ? "" : this.myModule.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/rules/ModuleGroupingRule$ModuleUsageGroup", "getText"));
            }
            return string;
        }

        @Override
        public FileStatus getFileStatus() {
            return null;
        }

        @Override
        public boolean isValid() {
            return !this.myModule.isDisposed();
        }

        @Override
        public void navigate(boolean focus) throws UnsupportedOperationException {
        }

        @Override
        public boolean canNavigate() {
            return false;
        }

        @Override
        public boolean canNavigateToSource() {
            return false;
        }

        @Override
        public int compareTo(@NotNull UsageGroup o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/rules/ModuleGroupingRule$ModuleUsageGroup", "compareTo"));
            }
            if (o instanceof LibraryUsageGroup) {
                return -1;
            }
            return this.getText(null).compareToIgnoreCase(o.getText(null));
        }

        public String toString() {
            return UsageViewBundle.message("node.group.module", new Object[0]) + this.getText(null);
        }

        @Override
        public void calcData(DataKey key, DataSink sink) {
            if (!this.isValid()) {
                return;
            }
            if (LangDataKeys.MODULE_CONTEXT == key) {
                sink.put(LangDataKeys.MODULE_CONTEXT, this.myModule);
            }
        }
    }

    private static class LibraryUsageGroup
    implements UsageGroup {
        private final OrderEntry myEntry;

        @Override
        public void update() {
        }

        public LibraryUsageGroup(@NotNull OrderEntry entry) {
            if (entry == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/rules/ModuleGroupingRule$LibraryUsageGroup", "<init>"));
            }
            this.myEntry = entry;
        }

        @Override
        public Icon getIcon(boolean isOpen) {
            return AllIcons.Nodes.PpLibFolder;
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            String string = this.myEntry.getPresentableName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/rules/ModuleGroupingRule$LibraryUsageGroup", "getText"));
            }
            return string;
        }

        @Override
        public FileStatus getFileStatus() {
            return null;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public int compareTo(@NotNull UsageGroup usageGroup) {
            if (usageGroup == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/rules/ModuleGroupingRule$LibraryUsageGroup", "compareTo"));
            }
            if (usageGroup instanceof ModuleUsageGroup) {
                return 1;
            }
            return this.getText(null).compareToIgnoreCase(usageGroup.getText(null));
        }

        @Override
        public void navigate(boolean requestFocus) {
        }

        @Override
        public boolean canNavigate() {
            return false;
        }

        @Override
        public boolean canNavigateToSource() {
            return this.canNavigate();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LibraryUsageGroup)) {
                return false;
            }
            return this.myEntry.equals(((LibraryUsageGroup)o).myEntry);
        }

        public int hashCode() {
            return this.myEntry.hashCode();
        }
    }
}

