/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.util.PlatformIcons;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryGroupingRule
implements UsageGroupingRule {
    protected final Project myProject;

    public static DirectoryGroupingRule getInstance(Project project) {
        return ServiceManager.getService(project, DirectoryGroupingRule.class);
    }

    public DirectoryGroupingRule(Project project) {
        this.myProject = project;
    }

    @Override
    @Nullable
    public UsageGroup groupUsage(@NotNull Usage usage) {
        UsageInFile usageInFile;
        VirtualFile file;
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/rules/DirectoryGroupingRule", "groupUsage"));
        }
        if (usage instanceof UsageInFile && (file = (usageInFile = (UsageInFile)usage).getFile()) != null) {
            VirtualFile dir;
            if (file instanceof VirtualFileWindow) {
                file = ((VirtualFileWindow)((Object)file)).getDelegate();
            }
            if ((dir = file.getParent()) == null) {
                return null;
            }
            return this.getGroupForFile(dir);
        }
        return null;
    }

    protected UsageGroup getGroupForFile(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/rules/DirectoryGroupingRule", "getGroupForFile"));
        }
        return new DirectoryGroup(dir);
    }

    public String getActionTitle() {
        return "Group by directory";
    }

    private class DirectoryGroup
    implements UsageGroup,
    TypeSafeDataProvider {
        private final VirtualFile myDir;

        @Override
        public void update() {
        }

        private DirectoryGroup(VirtualFile dir) {
            if (dir == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/rules/DirectoryGroupingRule$DirectoryGroup", "<init>"));
            }
            this.myDir = dir;
        }

        @Override
        public Icon getIcon(boolean isOpen) {
            return PlatformIcons.DIRECTORY_CLOSED_ICON;
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            VirtualFile baseDir = DirectoryGroupingRule.this.myProject.getBaseDir();
            String relativePath = baseDir == null ? null : VfsUtilCore.getRelativePath(this.myDir, baseDir, File.separatorChar);
            String string = relativePath == null ? this.myDir.getPresentableUrl() : relativePath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/rules/DirectoryGroupingRule$DirectoryGroup", "getText"));
            }
            return string;
        }

        @Override
        public FileStatus getFileStatus() {
            return this.isValid() ? FileStatusManager.getInstance(DirectoryGroupingRule.this.myProject).getStatus(this.myDir) : null;
        }

        @Override
        public boolean isValid() {
            return this.myDir.isValid();
        }

        @Override
        public void navigate(boolean focus) throws UnsupportedOperationException {
            PsiDirectory directory = this.getDirectory();
            if (directory != null && directory.canNavigate()) {
                directory.navigate(focus);
            }
        }

        private PsiDirectory getDirectory() {
            return this.myDir.isValid() ? PsiManager.getInstance(DirectoryGroupingRule.this.myProject).findDirectory(this.myDir) : null;
        }

        @Override
        public boolean canNavigate() {
            PsiDirectory directory = this.getDirectory();
            return directory != null && directory.canNavigate();
        }

        @Override
        public boolean canNavigateToSource() {
            return false;
        }

        @Override
        public int compareTo(@NotNull UsageGroup usageGroup) {
            if (usageGroup == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/rules/DirectoryGroupingRule$DirectoryGroup", "compareTo"));
            }
            return this.getText(null).compareToIgnoreCase(usageGroup.getText(null));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DirectoryGroup)) {
                return false;
            }
            return this.myDir.equals(((DirectoryGroup)o).myDir);
        }

        public int hashCode() {
            return this.myDir.hashCode();
        }

        @Override
        public void calcData(DataKey key, DataSink sink) {
            if (!this.isValid()) {
                return;
            }
            if (CommonDataKeys.VIRTUAL_FILE == key) {
                sink.put(CommonDataKeys.VIRTUAL_FILE, this.myDir);
            }
            if (CommonDataKeys.PSI_ELEMENT == key) {
                sink.put(CommonDataKeys.PSI_ELEMENT, this.getDirectory());
            }
        }
    }
}

