/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DarculaColors;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.usageView.UsageTreeColors;
import com.intellij.usageView.UsageTreeColorsScheme;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.TextChunk;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.Node;
import com.intellij.usages.impl.UsageNode;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UsageViewTreeCellRenderer
extends ColoredTreeCellRenderer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.usages.impl.UsageViewTreeCellRenderer");
    private static final EditorColorsScheme ourColorsScheme = UsageTreeColorsScheme.getInstance().getScheme();
    private static final SimpleTextAttributes ourInvalidAttributes = SimpleTextAttributes.fromTextAttributes(ourColorsScheme.getAttributes(UsageTreeColors.INVALID_PREFIX));
    private static final SimpleTextAttributes ourReadOnlyAttributes = SimpleTextAttributes.fromTextAttributes(ourColorsScheme.getAttributes(UsageTreeColors.READONLY_PREFIX));
    private static final SimpleTextAttributes ourNumberOfUsagesAttribute = SimpleTextAttributes.fromTextAttributes(ourColorsScheme.getAttributes(UsageTreeColors.NUMBER_OF_USAGES));
    private static final SimpleTextAttributes ourInvalidAttributesDarcula = new SimpleTextAttributes(null, DarculaColors.RED, null, ourInvalidAttributes.getStyle());
    public static final Insets STANDARD_IPAD_NOWIFI = new Insets(1, 2, 1, 2);
    private static final Rectangle EMPTY_RECTANGLE = new Rectangle();
    private boolean myRowBoundsCalled;
    private final UsageViewPresentation myPresentation;
    private final UsageView myView;
    private Dimension cachedPreferredSize;

    UsageViewTreeCellRenderer(@NotNull UsageView view) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/UsageViewTreeCellRenderer", "<init>"));
        }
        this.myRowBoundsCalled = false;
        this.myView = view;
        this.myPresentation = view.getPresentation();
    }

    @Override
    public void customizeCellRenderer(@Nullable JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        boolean showAsReadOnly = false;
        if (value instanceof Node && tree != null && value != tree.getModel().getRoot()) {
            Node node = (Node)value;
            if (!node.isValid()) {
                this.append(UsageViewBundle.message("node.invalid", new Object[0]) + " ", UIUtil.isUnderDarcula() ? ourInvalidAttributesDarcula : ourInvalidAttributes);
            }
            if (this.myPresentation.isShowReadOnlyStatusAsRed() && node.isReadOnly()) {
                showAsReadOnly = true;
            }
        }
        if (value instanceof DefaultMutableTreeNode) {
            Node node;
            Rectangle visibleRect;
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
            Object userObject = treeNode.getUserObject();
            Rectangle rectangle = visibleRect = tree == null ? EMPTY_RECTANGLE : ((JViewport)tree.getParent()).getViewRect();
            if (!visibleRect.isEmpty()) {
                RowLocation visible = this.myRowBoundsCalled ? RowLocation.INSIDE_VISIBLE_RECT : this.isRowVisible(row, visibleRect);
                this.myRowBoundsCalled = false;
                if (visible != RowLocation.INSIDE_VISIBLE_RECT) {
                    this.setIpad(new Insets(1, visibleRect.width, 1, 0));
                    return;
                }
                if (!this.getIpad().equals(STANDARD_IPAD_NOWIFI)) {
                    this.setIpad(STANDARD_IPAD_NOWIFI);
                }
            }
            if (userObject instanceof UsageTarget) {
                String text;
                UsageTarget usageTarget = (UsageTarget)userObject;
                if (!usageTarget.isValid()) {
                    this.append(UsageViewBundle.message("node.invalid", new Object[0]), ourInvalidAttributes);
                    return;
                }
                ItemPresentation presentation = usageTarget.getPresentation();
                LOG.assertTrue(presentation != null);
                if (showAsReadOnly) {
                    this.append(UsageViewBundle.message("node.readonly", new Object[0]) + " ", ourReadOnlyAttributes);
                }
                this.append((text = presentation.getPresentableText()) == null ? "" : text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                this.setIcon(presentation.getIcon(expanded));
            } else if (treeNode instanceof GroupNode) {
                node = (GroupNode)treeNode;
                if (node.isRoot()) {
                    this.append(StringUtil.capitalize((String)this.myPresentation.getUsagesWord()), UsageViewTreeCellRenderer.patchAttrs(node, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES));
                } else {
                    this.append(((GroupNode)node).getGroup().getText(this.myView), UsageViewTreeCellRenderer.patchAttrs(node, showAsReadOnly ? ourReadOnlyAttributes : SimpleTextAttributes.REGULAR_ATTRIBUTES));
                    this.setIcon(((GroupNode)node).getGroup().getIcon(expanded));
                }
                int count = ((GroupNode)node).getRecursiveUsageCount();
                this.append(" (" + StringUtil.pluralize((String)(count + " " + this.myPresentation.getUsagesWord()), (int)count) + ")", UsageViewTreeCellRenderer.patchAttrs(node, ourNumberOfUsagesAttribute));
            } else if (treeNode instanceof UsageNode) {
                node = (UsageNode)treeNode;
                this.setIcon(((UsageNode)node).getUsage().getPresentation().getIcon());
                if (showAsReadOnly) {
                    this.append(UsageViewBundle.message("node.readonly", new Object[0]) + " ", UsageViewTreeCellRenderer.patchAttrs(node, ourReadOnlyAttributes));
                }
                if (node.isValid()) {
                    TextChunk[] text;
                    for (TextChunk textChunk : text = ((UsageNode)node).getUsage().getPresentation().getText()) {
                        SimpleTextAttributes simples = textChunk.getSimpleAttributesIgnoreBackground();
                        this.append(textChunk.getText(), UsageViewTreeCellRenderer.patchAttrs(node, simples));
                    }
                }
            } else if (userObject instanceof String) {
                this.append((String)userObject, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            } else {
                this.append(userObject == null ? "" : userObject.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        } else {
            this.append(value.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        if (tree != null) {
            SpeedSearchUtil.applySpeedSearchHighlighting(tree, this, true, this.mySelected);
        }
    }

    @NotNull
    public String getPlainTextForNode(Object value) {
        boolean showAsReadOnly = false;
        StringBuilder result = new StringBuilder();
        if (value instanceof Node) {
            Node node = (Node)value;
            if (!node.isValid()) {
                result.append(UsageViewBundle.message("node.invalid", new Object[0]) + " ");
            }
            if (this.myPresentation.isShowReadOnlyStatusAsRed() && node.isReadOnly()) {
                showAsReadOnly = true;
            }
        }
        if (value instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
            Object userObject = treeNode.getUserObject();
            if (userObject instanceof UsageTarget) {
                UsageTarget usageTarget = (UsageTarget)userObject;
                if (usageTarget.isValid()) {
                    String text;
                    ItemPresentation presentation = usageTarget.getPresentation();
                    LOG.assertTrue(presentation != null);
                    if (showAsReadOnly) {
                        result.append(UsageViewBundle.message("node.readonly", new Object[0]) + " ");
                    }
                    result.append((text = presentation.getPresentableText()) == null ? "" : text);
                } else {
                    result.append(UsageViewBundle.message("node.invalid", new Object[0]));
                }
            } else if (treeNode instanceof GroupNode) {
                GroupNode node = (GroupNode)treeNode;
                if (node.isRoot()) {
                    result.append(StringUtil.capitalize((String)this.myPresentation.getUsagesWord()));
                } else {
                    result.append(node.getGroup().getText(this.myView));
                }
                int count = node.getRecursiveUsageCount();
                result.append(" (" + StringUtil.pluralize((String)(count + " " + this.myPresentation.getUsagesWord()), (int)count) + ")");
            } else if (treeNode instanceof UsageNode) {
                UsageNode node = (UsageNode)treeNode;
                if (showAsReadOnly) {
                    result.append(UsageViewBundle.message("node.readonly", new Object[0]) + " ");
                }
                if (node.isValid()) {
                    TextChunk[] text;
                    for (TextChunk textChunk : text = node.getUsage().getPresentation().getText()) {
                        result.append(textChunk.getText());
                    }
                }
            } else if (userObject instanceof String) {
                result.append((String)userObject);
            } else {
                result.append(userObject == null ? "" : userObject.toString());
            }
        } else {
            result.append(value);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewTreeCellRenderer", "getPlainTextForNode"));
        }
        return string;
    }

    @NotNull
    public RowLocation isRowVisible(int row, @NotNull Rectangle visibleRect) {
        Dimension pref;
        if (visibleRect == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/usages/impl/UsageViewTreeCellRenderer", "isRowVisible"));
        }
        if (this.cachedPreferredSize == null) {
            this.cachedPreferredSize = pref = this.getPreferredSize();
        } else {
            pref = this.cachedPreferredSize;
        }
        pref.width = Math.max(visibleRect.width, pref.width);
        this.myRowBoundsCalled = true;
        JTree tree = this.getTree();
        Rectangle bounds = tree == null ? null : tree.getRowBounds(row);
        this.myRowBoundsCalled = false;
        int y = bounds == null ? 0 : bounds.y;
        TextRange vis = TextRange.from((int)Math.max(0, visibleRect.y - pref.height), (int)(visibleRect.height + pref.height * 2));
        boolean inside = vis.contains(y);
        if (inside) {
            RowLocation rowLocation = RowLocation.INSIDE_VISIBLE_RECT;
            if (rowLocation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewTreeCellRenderer", "isRowVisible"));
            }
            return rowLocation;
        }
        RowLocation rowLocation = y < vis.getStartOffset() ? RowLocation.BEFORE_VISIBLE_RECT : RowLocation.AFTER_VISIBLE_RECT;
        if (rowLocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewTreeCellRenderer", "isRowVisible"));
        }
        return rowLocation;
    }

    private static SimpleTextAttributes patchAttrs(@NotNull Node node, @NotNull SimpleTextAttributes original) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/UsageViewTreeCellRenderer", "patchAttrs"));
        }
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/usages/impl/UsageViewTreeCellRenderer", "patchAttrs"));
        }
        if (node.isExcluded()) {
            original = new SimpleTextAttributes(original.getStyle() | 4, original.getFgColor(), original.getWaveColor());
        }
        if (node instanceof GroupNode) {
            DefaultMutableTreeNode parent;
            FileStatus fileStatus;
            UsageGroup group = ((GroupNode)node).getGroup();
            FileStatus fileStatus2 = fileStatus = group != null ? group.getFileStatus() : null;
            if (fileStatus != null && fileStatus != FileStatus.NOT_CHANGED) {
                original = new SimpleTextAttributes(original.getStyle(), fileStatus.getColor(), original.getWaveColor());
            }
            if ((parent = (DefaultMutableTreeNode)node.getParent()) != null && parent.isRoot()) {
                original = new SimpleTextAttributes(original.getStyle() | 1, original.getFgColor(), original.getWaveColor());
            }
        }
        return original;
    }

    static String getTooltipFromPresentation(Object value) {
        DefaultMutableTreeNode treeNode;
        if (value instanceof DefaultMutableTreeNode && (treeNode = (DefaultMutableTreeNode)value) instanceof UsageNode) {
            UsageNode node = (UsageNode)treeNode;
            return node.getUsage().getPresentation().getTooltipText();
        }
        return null;
    }

    static enum RowLocation {
        BEFORE_VISIBLE_RECT,
        INSIDE_VISIBLE_RECT,
        AFTER_VISIBLE_RECT;

    }
}

