/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.find.FindManager;
import com.intellij.find.SearchInBackgroundOption;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.DumbModeAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageLimitUtil;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.ui.RangeBlinker;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsageViewManagerImpl
extends UsageViewManager {
    private final Project myProject;
    private static final Key<UsageView> USAGE_VIEW_KEY = Key.create((String)"USAGE_VIEW");
    @NonNls
    private static final String LARGE_FILES_HREF_TARGET = "LargeFiles";
    @NonNls
    private static final String FIND_OPTIONS_HREF_TARGET = "FindOptions";

    public UsageViewManagerImpl(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/UsageViewManagerImpl", "<init>"));
        }
        this.myProject = project;
    }

    @Override
    @NotNull
    public UsageView createUsageView(@NotNull UsageTarget[] targets, @NotNull Usage[] usages, @NotNull UsageViewPresentation presentation, Factory<UsageSearcher> usageSearcherFactory) {
        if (targets == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/UsageViewManagerImpl", "createUsageView"));
        }
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/usages/impl/UsageViewManagerImpl", "createUsageView"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/usages/impl/UsageViewManagerImpl", "createUsageView"));
        }
        UsageViewImpl usageView = new UsageViewImpl(this.myProject, presentation, targets, usageSearcherFactory);
        UsageViewManagerImpl.appendUsages(usages, usageView);
        usageView.setSearchInProgress(false);
        UsageViewImpl usageViewImpl = usageView;
        if (usageViewImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewManagerImpl", "createUsageView"));
        }
        return usageViewImpl;
    }

    @Override
    @NotNull
    public UsageView showUsages(@NotNull UsageTarget[] searchedFor, @NotNull Usage[] foundUsages, @NotNull UsageViewPresentation presentation, Factory<UsageSearcher> factory) {
        if (searchedFor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/UsageViewManagerImpl", "showUsages"));
        }
        if (foundUsages == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/usages/impl/UsageViewManagerImpl", "showUsages"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/usages/impl/UsageViewManagerImpl", "showUsages"));
        }
        UsageView usageView = this.createUsageView(searchedFor, foundUsages, presentation, factory);
        this.addContent((UsageViewImpl)usageView, presentation);
        this.showToolWindow(true);
        UsageView usageView2 = usageView;
        if (usageView2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewManagerImpl", "showUsages"));
        }
        return usageView2;
    }

    @Override
    @NotNull
    public UsageView showUsages(@NotNull UsageTarget[] searchedFor, @NotNull Usage[] foundUsages, @NotNull UsageViewPresentation presentation) {
        if (searchedFor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/UsageViewManagerImpl", "showUsages"));
        }
        if (foundUsages == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/usages/impl/UsageViewManagerImpl", "showUsages"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/usages/impl/UsageViewManagerImpl", "showUsages"));
        }
        UsageView usageView = this.showUsages(searchedFor, foundUsages, presentation, null);
        if (usageView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewManagerImpl", "showUsages"));
        }
        return usageView;
    }

    private void addContent(@NotNull UsageViewImpl usageView, @NotNull UsageViewPresentation presentation) {
        if (usageView == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/UsageViewManagerImpl", "addContent"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/usages/impl/UsageViewManagerImpl", "addContent"));
        }
        Content content = com.intellij.usageView.UsageViewManager.getInstance(this.myProject).addContent(presentation.getTabText(), presentation.getTabName(), presentation.getToolwindowTitle(), true, usageView.getComponent(), presentation.isOpenInNewTab(), true);
        usageView.setContent(content);
        content.putUserData(USAGE_VIEW_KEY, usageView);
    }

    @Override
    public UsageView searchAndShowUsages(final @NotNull UsageTarget[] searchFor, final @NotNull Factory<UsageSearcher> searcherFactory, boolean showPanelIfOnlyOneUsage, boolean showNotFoundMessage, final @NotNull UsageViewPresentation presentation, final @Nullable UsageViewManager.UsageViewStateListener listener) {
        if (searchFor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/UsageViewManagerImpl", "searchAndShowUsages"));
        }
        if (searcherFactory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/usages/impl/UsageViewManagerImpl", "searchAndShowUsages"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/usages/impl/UsageViewManagerImpl", "searchAndShowUsages"));
        }
        final AtomicReference usageViewRef = new AtomicReference();
        final FindUsagesProcessPresentation processPresentation = new FindUsagesProcessPresentation(presentation);
        processPresentation.setShowNotFoundMessage(showNotFoundMessage);
        processPresentation.setShowPanelIfOnlyOneUsage(showPanelIfOnlyOneUsage);
        Task.Backgroundable task = new Task.Backgroundable(this.myProject, UsageViewManagerImpl.getProgressTitle(presentation), true, new SearchInBackgroundOption()){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/UsageViewManagerImpl$1", "run"));
                }
                new SearchForUsagesRunnable(UsageViewManagerImpl.this.myProject, usageViewRef, presentation, searchFor, searcherFactory, processPresentation, listener).run();
            }

            @Override
            public DumbModeAction getDumbModeAction() {
                return DumbModeAction.CANCEL;
            }

            @Override
            @Nullable
            public Task.NotificationInfo getNotificationInfo() {
                String notification = usageViewRef.get() != null ? ((UsageViewImpl)usageViewRef.get()).getUsagesCount() + " Usage(s) Found" : "No Usages Found";
                return new Task.NotificationInfo("Find Usages", "Find Usages Finished", notification);
            }
        };
        ProgressManager.getInstance().run(task);
        return (UsageView)usageViewRef.get();
    }

    @Override
    public void searchAndShowUsages(@NotNull UsageTarget[] searchFor, @NotNull Factory<UsageSearcher> searcherFactory, @NotNull FindUsagesProcessPresentation processPresentation, @NotNull UsageViewPresentation presentation, @Nullable UsageViewManager.UsageViewStateListener listener) {
        if (searchFor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/UsageViewManagerImpl", "searchAndShowUsages"));
        }
        if (searcherFactory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/usages/impl/UsageViewManagerImpl", "searchAndShowUsages"));
        }
        if (processPresentation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/usages/impl/UsageViewManagerImpl", "searchAndShowUsages"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/usages/impl/UsageViewManagerImpl", "searchAndShowUsages"));
        }
        AtomicReference usageView = new AtomicReference();
        final SearchForUsagesRunnable runnable = new SearchForUsagesRunnable(this.myProject, usageView, presentation, searchFor, searcherFactory, processPresentation, listener);
        Factory<ProgressIndicator> progressIndicatorFactory = processPresentation.getProgressIndicatorFactory();
        final ProgressIndicator progressIndicator = progressIndicatorFactory != null ? (ProgressIndicator)progressIndicatorFactory.create() : null;
        final AtomicBoolean findUsagesStartedShown = new AtomicBoolean();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ProgressManager.getInstance().runProcess(new Runnable(){

                        @Override
                        public void run() {
                            runnable.searchUsages(findUsagesStartedShown);
                        }
                    }, progressIndicator);
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                finally {
                    runnable.endSearchForUsages(findUsagesStartedShown);
                }
            }
        });
    }

    @Override
    public UsageView getSelectedUsageView() {
        Content content = com.intellij.usageView.UsageViewManager.getInstance(this.myProject).getSelectedContent();
        if (content != null) {
            return (UsageView)content.getUserData(USAGE_VIEW_KEY);
        }
        return null;
    }

    @NotNull
    public static String getProgressTitle(@NotNull UsageViewPresentation presentation) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/UsageViewManagerImpl", "getProgressTitle"));
        }
        String scopeText = presentation.getScopeText();
        String usagesString = StringUtil.capitalize((String)presentation.getUsagesString());
        String result = scopeText == null ? UsageViewBundle.message("progress.searching.for", usagesString) : UsageViewBundle.message("progress.searching.for.in", usagesString, scopeText);
        String string = StringUtil.escapeXml((String)result);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewManagerImpl", "getProgressTitle"));
        }
        return string;
    }

    private void showToolWindow(boolean activateWindow) {
        ToolWindow toolWindow = ToolWindowManager.getInstance(this.myProject).getToolWindow(ToolWindowId.FIND);
        toolWindow.show(null);
        if (activateWindow && !toolWindow.isActive()) {
            toolWindow.activate(null);
        }
    }

    private static void appendUsages(final @NotNull Usage[] foundUsages, final @NotNull UsageViewImpl usageView) {
        if (foundUsages == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/UsageViewManagerImpl", "appendUsages"));
        }
        if (usageView == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/usages/impl/UsageViewManagerImpl", "appendUsages"));
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                for (Usage foundUsage : foundUsages) {
                    usageView.appendUsage(foundUsage);
                }
            }
        });
    }

    static void showTooManyUsagesWarning(final @NotNull Project project, final @NotNull TooManyUsagesStatus tooManyUsagesStatus, final @NotNull ProgressIndicator indicator, final @NotNull UsageViewPresentation presentation, final int usageCount, final UsageViewImpl usageView) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/UsageViewManagerImpl", "showTooManyUsagesWarning"));
        }
        if (tooManyUsagesStatus == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/usages/impl/UsageViewManagerImpl", "showTooManyUsagesWarning"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/usages/impl/UsageViewManagerImpl", "showTooManyUsagesWarning"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/usages/impl/UsageViewManagerImpl", "showTooManyUsagesWarning"));
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (usageView != null && usageView.searchHasBeenCancelled() || indicator.isCanceled()) {
                    return;
                }
                String message = UsageViewBundle.message("find.excessive.usage.count.prompt", usageCount, StringUtil.pluralize((String)presentation.getUsagesWord()));
                UsageLimitUtil.Result ret = UsageLimitUtil.showTooManyUsagesWarning(project, message, presentation);
                if (ret == UsageLimitUtil.Result.ABORT && usageView != null) {
                    usageView.cancelCurrentSearch();
                    indicator.cancel();
                }
                tooManyUsagesStatus.userResponded();
            }
        });
    }

    private static void notifyByFindBalloon(final HyperlinkListener listener, final @NotNull MessageType info, @NotNull FindUsagesProcessPresentation processPresentation, final @NotNull Project project, String ... sLines) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/usages/impl/UsageViewManagerImpl", "notifyByFindBalloon"));
        }
        if (processPresentation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/usages/impl/UsageViewManagerImpl", "notifyByFindBalloon"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/usages/impl/UsageViewManagerImpl", "notifyByFindBalloon"));
        }
        if (sLines == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/usages/impl/UsageViewManagerImpl", "notifyByFindBalloon"));
        }
        com.intellij.usageView.UsageViewManager.getInstance(project);
        final ArrayList<String> lines = new ArrayList<String>(Arrays.asList(sLines));
        final Collection<PsiFile> largeFiles = processPresentation.getLargeFiles();
        ArrayList<String> resultLines = new ArrayList<String>(lines);
        HyperlinkListener resultListener = listener;
        if (!largeFiles.isEmpty()) {
            String shortMessage = "(<a href='LargeFiles'>" + UsageViewBundle.message("large.files.were.ignored", largeFiles.size()) + "</a>)";
            resultLines.add(shortMessage);
            resultListener = new HyperlinkAdapter(){

                @Override
                protected void hyperlinkActivated(HyperlinkEvent e) {
                    if (e.getDescription().equals(UsageViewManagerImpl.LARGE_FILES_HREF_TARGET)) {
                        String detailedMessage = UsageViewManagerImpl.detailedLargeFilesMessage(largeFiles);
                        ArrayList<String> strings = new ArrayList<String>(lines);
                        strings.add(detailedMessage);
                        ToolWindowManager.getInstance(project).notifyByBalloon(ToolWindowId.FIND, info, UsageViewManagerImpl.wrapInHtml(strings), AllIcons.Actions.Find, listener);
                    } else if (listener != null) {
                        listener.hyperlinkUpdate(e);
                    }
                }
            };
        }
        ToolWindowManager.getInstance(project).notifyByBalloon(ToolWindowId.FIND, info, UsageViewManagerImpl.wrapInHtml(resultLines), AllIcons.Actions.Find, resultListener);
    }

    @NotNull
    private static String wrapInHtml(@NotNull List<String> strings) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/UsageViewManagerImpl", "wrapInHtml"));
        }
        String string = XmlStringUtil.wrapInHtml((CharSequence)StringUtil.join(strings, (String)"<br>"));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewManagerImpl", "wrapInHtml"));
        }
        return string;
    }

    @NotNull
    private static String detailedLargeFilesMessage(@NotNull Collection<PsiFile> largeFiles) {
        if (largeFiles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/UsageViewManagerImpl", "detailedLargeFilesMessage"));
        }
        String message = "";
        if (largeFiles.size() == 1) {
            VirtualFile vFile = largeFiles.iterator().next().getVirtualFile();
            message = message + "File " + UsageViewManagerImpl.presentableFileInfo(vFile) + " is ";
        } else {
            message = message + "Files<br> ";
            int counter = 0;
            for (PsiFile file : largeFiles) {
                VirtualFile vFile = file.getVirtualFile();
                message = message + UsageViewManagerImpl.presentableFileInfo(vFile) + "<br> ";
                if (counter++ <= 10) continue;
                break;
            }
            message = message + "are ";
        }
        String string = message = message + "too large and cannot be scanned";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewManagerImpl", "detailedLargeFilesMessage"));
        }
        return string;
    }

    @NotNull
    private static String presentableFileInfo(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/UsageViewManagerImpl", "presentableFileInfo"));
        }
        String string = UsageViewManagerImpl.getPresentablePath(vFile) + "&nbsp;(" + UsageViewManagerImpl.presentableSize(UsageViewManagerImpl.getFileLength(vFile)) + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewManagerImpl", "presentableFileInfo"));
        }
        return string;
    }

    @NotNull
    public static String presentableSize(long bytes) {
        long megabytes = bytes / 0x100000L;
        String string = UsageViewBundle.message("find.file.size.megabytes", Long.toString(megabytes));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewManagerImpl", "presentableSize"));
        }
        return string;
    }

    public static long getFileLength(final @NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/UsageViewManagerImpl", "getFileLength"));
        }
        final long[] length = new long[]{-1L};
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (!virtualFile.isValid()) {
                    return;
                }
                if (virtualFile.getFileType().isBinary()) {
                    return;
                }
                length[0] = virtualFile.getLength();
            }
        });
        return length[0];
    }

    @NotNull
    private static String getPresentablePath(final @NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/UsageViewManagerImpl", "getPresentablePath"));
        }
        String string = "'" + ApplicationManager.getApplication().runReadAction(new Computable<String>(){

            public String compute() {
                return virtualFile.getPresentableUrl();
            }
        }) + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewManagerImpl", "getPresentablePath"));
        }
        return string;
    }

    @NotNull
    private HyperlinkListener createGotToOptionsListener(final @NotNull UsageTarget[] targets) {
        if (targets == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/UsageViewManagerImpl", "createGotToOptionsListener"));
        }
        HyperlinkAdapter hyperlinkAdapter = new HyperlinkAdapter(){

            @Override
            protected void hyperlinkActivated(HyperlinkEvent e) {
                if (e.getDescription().equals(UsageViewManagerImpl.FIND_OPTIONS_HREF_TARGET)) {
                    FindManager.getInstance(UsageViewManagerImpl.this.myProject).showSettingsAndFindUsages(targets);
                }
            }
        };
        if (hyperlinkAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewManagerImpl", "createGotToOptionsListener"));
        }
        return hyperlinkAdapter;
    }

    @NotNull
    private static String createOptionsHtml(@NonNls UsageTarget[] searchFor) {
        KeyboardShortcut shortcut = UsageViewImpl.getShowUsagesWithSettingsShortcut(searchFor);
        String shortcutText = "";
        if (shortcut != null) {
            shortcutText = "&nbsp;(" + KeymapUtil.getShortcutText(shortcut) + ")";
        }
        String string = "<a href='FindOptions'>Find Options...</a>" + shortcutText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewManagerImpl", "createOptionsHtml"));
        }
        return string;
    }

    private static void flashUsageScriptaculously(@NotNull Usage usage) {
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/UsageViewManagerImpl", "flashUsageScriptaculously"));
        }
        if (!(usage instanceof UsageInfo2UsageAdapter)) {
            return;
        }
        UsageInfo2UsageAdapter usageInfo = (UsageInfo2UsageAdapter)usage;
        Editor editor = usageInfo.openTextEditor(true);
        if (editor == null) {
            return;
        }
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.BLINKING_HIGHLIGHTS_ATTRIBUTES);
        RangeBlinker rangeBlinker = new RangeBlinker(editor, attributes, 6);
        ArrayList<Segment> segments = new ArrayList<Segment>();
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor(segments);
        usageInfo.processRangeMarkers((Processor<Segment>)processor);
        rangeBlinker.resetMarkers(segments);
        rangeBlinker.startBlinking();
    }

    private class SearchForUsagesRunnable
    implements Runnable {
        private final AtomicInteger myUsageCountWithoutDefinition;
        private final AtomicReference<Usage> myFirstUsage;
        @NotNull
        private final Project myProject;
        private final AtomicReference<UsageViewImpl> myUsageViewRef;
        private final UsageViewPresentation myPresentation;
        private final UsageTarget[] mySearchFor;
        private final Factory<UsageSearcher> mySearcherFactory;
        private final FindUsagesProcessPresentation myProcessPresentation;
        private final UsageViewManager.UsageViewStateListener myListener;

        private SearchForUsagesRunnable(@NotNull Project project, @NotNull AtomicReference<UsageViewImpl> usageViewRef, @NotNull UsageViewPresentation presentation, @NotNull UsageTarget[] searchFor, @NotNull Factory<UsageSearcher> searcherFactory, @Nullable FindUsagesProcessPresentation processPresentation, UsageViewManager.UsageViewStateListener listener) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/UsageViewManagerImpl$SearchForUsagesRunnable", "<init>"));
            }
            if (usageViewRef == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/usages/impl/UsageViewManagerImpl$SearchForUsagesRunnable", "<init>"));
            }
            if (presentation == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/usages/impl/UsageViewManagerImpl$SearchForUsagesRunnable", "<init>"));
            }
            if (searchFor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/usages/impl/UsageViewManagerImpl$SearchForUsagesRunnable", "<init>"));
            }
            if (searcherFactory == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/usages/impl/UsageViewManagerImpl$SearchForUsagesRunnable", "<init>"));
            }
            if (processPresentation == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/usages/impl/UsageViewManagerImpl$SearchForUsagesRunnable", "<init>"));
            }
            this.myUsageCountWithoutDefinition = new AtomicInteger(0);
            this.myFirstUsage = new AtomicReference();
            this.myProject = project;
            this.myUsageViewRef = usageViewRef;
            this.myPresentation = presentation;
            this.mySearchFor = searchFor;
            this.mySearcherFactory = searcherFactory;
            this.myProcessPresentation = processPresentation;
            this.myListener = listener;
        }

        private UsageViewImpl getUsageView(ProgressIndicator indicator) {
            UsageViewImpl usageView = this.myUsageViewRef.get();
            if (usageView != null) {
                return usageView;
            }
            int usageCount = this.myUsageCountWithoutDefinition.get();
            if (usageCount >= 2 || usageCount == 1 && this.myProcessPresentation.isShowPanelIfOnlyOneUsage()) {
                usageView = new UsageViewImpl(this.myProject, this.myPresentation, this.mySearchFor, this.mySearcherFactory);
                usageView.associateProgress(indicator);
                if (this.myUsageViewRef.compareAndSet(null, usageView)) {
                    this.openView(usageView);
                    final Usage firstUsage = this.myFirstUsage.get();
                    if (firstUsage != null) {
                        final UsageViewImpl finalUsageView = usageView;
                        ApplicationManager.getApplication().runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                finalUsageView.appendUsage(firstUsage);
                            }
                        });
                    }
                } else {
                    Disposer.dispose((Disposable)usageView);
                }
                return this.myUsageViewRef.get();
            }
            return null;
        }

        private void openView(final @NotNull UsageViewImpl usageView) {
            if (usageView == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/UsageViewManagerImpl$SearchForUsagesRunnable", "openView"));
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SearchForUsagesRunnable.this.myProject.isDisposed()) {
                        return;
                    }
                    UsageViewManagerImpl.this.addContent(usageView, SearchForUsagesRunnable.this.myPresentation);
                    if (SearchForUsagesRunnable.this.myListener != null) {
                        SearchForUsagesRunnable.this.myListener.usageViewCreated(usageView);
                    }
                    UsageViewManagerImpl.this.showToolWindow(false);
                }
            });
        }

        @Override
        public void run() {
            AtomicBoolean findUsagesStartedShown = new AtomicBoolean();
            this.searchUsages(findUsagesStartedShown);
            this.endSearchForUsages(findUsagesStartedShown);
        }

        private void searchUsages(final @NotNull AtomicBoolean findStartedBalloonShown) {
            if (findStartedBalloonShown == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/UsageViewManagerImpl$SearchForUsagesRunnable", "searchUsages"));
            }
            ProgressIndicator indicator = ProgressWrapper.unwrap((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator());
            TooManyUsagesStatus.createFor((ProgressIndicator)indicator);
            Alarm findUsagesStartedBalloon = new Alarm();
            findUsagesStartedBalloon.addRequest(new Runnable(){

                @Override
                public void run() {
                    String balloon = UsageViewBundle.message("progress.searching.for", StringUtil.escapeXml((String)SearchForUsagesRunnable.this.myPresentation.getUsagesString()));
                    UsageViewManagerImpl.notifyByFindBalloon(null, MessageType.WARNING, SearchForUsagesRunnable.this.myProcessPresentation, UsageViewManagerImpl.this.myProject, new String[]{balloon});
                    findStartedBalloonShown.set(true);
                }
            }, 300, ModalityState.NON_MODAL);
            UsageSearcher usageSearcher = (UsageSearcher)this.mySearcherFactory.create();
            usageSearcher.generate(new Processor<Usage>(){

                public boolean process(final Usage usage) {
                    boolean incrementCounter;
                    ProgressIndicator indicator = ProgressWrapper.unwrap((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator());
                    if (indicator != null && indicator.isCanceled()) {
                        return false;
                    }
                    TooManyUsagesStatus tooManyUsagesStatus = TooManyUsagesStatus.getFrom((ProgressIndicator)indicator);
                    boolean bl = incrementCounter = !UsageViewManager.isSelfUsage(usage, SearchForUsagesRunnable.this.mySearchFor);
                    if (incrementCounter) {
                        int usageCount = SearchForUsagesRunnable.this.myUsageCountWithoutDefinition.incrementAndGet();
                        if (usageCount == 1 && !SearchForUsagesRunnable.this.myProcessPresentation.isShowPanelIfOnlyOneUsage()) {
                            SearchForUsagesRunnable.this.myFirstUsage.compareAndSet(null, usage);
                        }
                        final UsageViewImpl usageView = SearchForUsagesRunnable.this.getUsageView(indicator);
                        if (usageCount > 1000 && tooManyUsagesStatus.switchTooManyUsagesStatus()) {
                            UsageViewManagerImpl.showTooManyUsagesWarning(SearchForUsagesRunnable.this.myProject, tooManyUsagesStatus, indicator, SearchForUsagesRunnable.this.myPresentation, usageCount, usageView);
                        }
                        if (usageView != null) {
                            ApplicationManager.getApplication().runReadAction(new Runnable(){

                                @Override
                                public void run() {
                                    usageView.appendUsage(usage);
                                }
                            });
                        }
                    }
                    return indicator == null || !indicator.isCanceled();
                }
            });
            if (this.getUsageView(indicator) != null) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UsageViewManagerImpl.this.showToolWindow(true);
                    }
                }, this.myProject.getDisposed());
            }
            Disposer.dispose((Disposable)findUsagesStartedBalloon);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Balloon balloon;
                    if (findStartedBalloonShown.get() && (balloon = ToolWindowManager.getInstance(SearchForUsagesRunnable.this.myProject).getToolWindowBalloon(ToolWindowId.FIND)) != null) {
                        balloon.hide();
                    }
                }
            }, this.myProject.getDisposed());
        }

        private void endSearchForUsages(final @NotNull AtomicBoolean findStartedBalloonShown) {
            if (findStartedBalloonShown == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/UsageViewManagerImpl$SearchForUsagesRunnable", "endSearchForUsages"));
            }
            assert (!ApplicationManager.getApplication().isDispatchThread()) : Thread.currentThread();
            int usageCount = this.myUsageCountWithoutDefinition.get();
            if (usageCount == 0 && this.myProcessPresentation.isShowNotFoundMessage()) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        List<Action> notFoundActions = SearchForUsagesRunnable.this.myProcessPresentation.getNotFoundActions();
                        String message = UsageViewBundle.message("dialog.no.usages.found.in", StringUtil.decapitalize((String)SearchForUsagesRunnable.this.myPresentation.getUsagesString()), SearchForUsagesRunnable.this.myPresentation.getScopeText());
                        if (notFoundActions.isEmpty()) {
                            String[] stringArray;
                            if (SearchForUsagesRunnable.this.myProcessPresentation.isShowFindOptionsPrompt()) {
                                String[] stringArray2 = new String[2];
                                stringArray2[0] = StringUtil.escapeXml((String)message);
                                stringArray = stringArray2;
                                stringArray2[1] = UsageViewManagerImpl.createOptionsHtml(SearchForUsagesRunnable.this.mySearchFor);
                            } else {
                                String[] stringArray3 = new String[1];
                                stringArray = stringArray3;
                                stringArray3[0] = StringUtil.escapeXml((String)message);
                            }
                            String[] lines = stringArray;
                            UsageViewManagerImpl.notifyByFindBalloon(UsageViewManagerImpl.this.createGotToOptionsListener(SearchForUsagesRunnable.this.mySearchFor), MessageType.INFO, SearchForUsagesRunnable.this.myProcessPresentation, UsageViewManagerImpl.this.myProject, lines);
                            findStartedBalloonShown.set(false);
                        } else {
                            ArrayList<String> titles = new ArrayList<String>(notFoundActions.size() + 1);
                            titles.add(UsageViewBundle.message("dialog.button.ok", new Object[0]));
                            for (Action action : notFoundActions) {
                                Object value = action.getValue("NameWithMnemonic");
                                if (value == null) {
                                    value = action.getValue("Name");
                                }
                                titles.add((String)value);
                            }
                            int option = Messages.showDialog(SearchForUsagesRunnable.this.myProject, message, UsageViewBundle.message("dialog.title.information", new Object[0]), ArrayUtil.toStringArray(titles), 0, Messages.getInformationIcon());
                            if (option > 0) {
                                notFoundActions.get(option - 1).actionPerformed(new ActionEvent(this, 0, (String)titles.get(option)));
                            }
                        }
                    }
                }, ModalityState.NON_MODAL, this.myProject.getDisposed());
            } else if (usageCount == 1 && !this.myProcessPresentation.isShowPanelIfOnlyOneUsage()) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Usage usage = (Usage)SearchForUsagesRunnable.this.myFirstUsage.get();
                        if (usage.canNavigate()) {
                            usage.navigate(true);
                            UsageViewManagerImpl.flashUsageScriptaculously(usage);
                        }
                        UsageViewManagerImpl.notifyByFindBalloon(UsageViewManagerImpl.this.createGotToOptionsListener(SearchForUsagesRunnable.this.mySearchFor), MessageType.INFO, SearchForUsagesRunnable.this.myProcessPresentation, UsageViewManagerImpl.this.myProject, new String[]{"Only one usage found.", UsageViewManagerImpl.createOptionsHtml(SearchForUsagesRunnable.this.mySearchFor)});
                    }
                }, ModalityState.NON_MODAL, this.myProject.getDisposed());
            } else {
                UsageViewImpl usageView = this.myUsageViewRef.get();
                if (usageView != null) {
                    usageView.drainQueuedUsageNodes();
                    usageView.setSearchInProgress(false);
                }
                if (!this.myProcessPresentation.getLargeFiles().isEmpty()) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UsageViewManagerImpl.notifyByFindBalloon(null, MessageType.INFO, SearchForUsagesRunnable.this.myProcessPresentation, UsageViewManagerImpl.this.myProject, new String[0]);
                        }
                    }, ModalityState.NON_MODAL, this.myProject.getDisposed());
                }
            }
            if (this.myListener != null) {
                this.myListener.findingUsagesFinished(this.myUsageViewRef.get());
            }
        }
    }
}

