/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.rules.UsageFilteringRule;
import com.intellij.usages.rules.UsageFilteringRuleEx;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.usages.rules.UsageGroupingRuleEx;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UsageNodeTreeBuilder {
    private final GroupNode myRoot;
    private final UsageTarget[] myTargets;
    private UsageGroupingRule[] myGroupingRules;
    private UsageFilteringRule[] myFilteringRules;

    UsageNodeTreeBuilder(@NotNull UsageTarget[] targets, @NotNull UsageGroupingRule[] groupingRules, @NotNull UsageFilteringRule[] filteringRules, @NotNull GroupNode root) {
        if (targets == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/UsageNodeTreeBuilder", "<init>"));
        }
        if (groupingRules == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/usages/impl/UsageNodeTreeBuilder", "<init>"));
        }
        if (filteringRules == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/usages/impl/UsageNodeTreeBuilder", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/usages/impl/UsageNodeTreeBuilder", "<init>"));
        }
        this.myTargets = targets;
        this.myGroupingRules = groupingRules;
        this.myFilteringRules = filteringRules;
        this.myRoot = root;
    }

    public void setGroupingRules(@NotNull UsageGroupingRule[] rules) {
        if (rules == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/UsageNodeTreeBuilder", "setGroupingRules"));
        }
        this.myGroupingRules = rules;
    }

    public void setFilteringRules(@NotNull UsageFilteringRule[] rules) {
        if (rules == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/UsageNodeTreeBuilder", "setFilteringRules"));
        }
        this.myFilteringRules = rules;
    }

    public boolean isVisible(@NotNull Usage usage) {
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/UsageNodeTreeBuilder", "isVisible"));
        }
        for (UsageFilteringRule rule : this.myFilteringRules) {
            boolean visible = rule instanceof UsageFilteringRuleEx ? ((UsageFilteringRuleEx)rule).isVisible(usage, this.myTargets) : rule.isVisible(usage);
            if (visible) continue;
            return false;
        }
        return true;
    }

    @Nullable
    UsageNode appendUsage(@NotNull Usage usage, @NotNull Consumer<Runnable> edtQueue) {
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/UsageNodeTreeBuilder", "appendUsage"));
        }
        if (edtQueue == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/usages/impl/UsageNodeTreeBuilder", "appendUsage"));
        }
        if (!this.isVisible(usage)) {
            return null;
        }
        GroupNode lastGroupNode = this.myRoot;
        for (int i = 0; i < this.myGroupingRules.length; ++i) {
            UsageGroupingRule rule = this.myGroupingRules[i];
            UsageGroup group = rule instanceof UsageGroupingRuleEx ? ((UsageGroupingRuleEx)rule).groupUsage(usage, this.myTargets) : rule.groupUsage(usage);
            if (group == null) continue;
            lastGroupNode = lastGroupNode.addGroup(group, i, edtQueue);
        }
        return lastGroupNode.addUsage(usage, edtQueue);
    }
}

