/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.table;

import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.LayoutPassInfo;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabLayout;
import com.intellij.ui.tabs.impl.table.TablePassInfo;
import com.intellij.ui.tabs.impl.table.TableRow;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class TableLayout
extends TabLayout {
    private final JBTabsImpl myTabs;
    public TablePassInfo myLastTableLayout;

    public TableLayout(JBTabsImpl tabs) {
        this.myTabs = tabs;
    }

    private TablePassInfo computeLayoutTable(List<TabInfo> visibleInfos) {
        TablePassInfo data = new TablePassInfo(this.myTabs, visibleInfos);
        Insets insets = this.myTabs.getLayoutInsets();
        data.toFitRec = new Rectangle(insets.left, insets.top, this.myTabs.getWidth() - insets.left - insets.right, this.myTabs.getHeight() - insets.top - insets.bottom);
        int eachRow = 0;
        int eachX = data.toFitRec.x;
        TableRow eachTableRow = new TableRow(data);
        data.table.add(eachTableRow);
        data.requiredRows = 1;
        for (TabInfo eachInfo : data.myVisibleInfos) {
            TabLabel eachLabel = this.myTabs.myInfo2Label.get(eachInfo);
            Dimension size = eachLabel.getPreferredSize();
            if ((double)(eachX + size.width) >= data.toFitRec.getMaxX()) {
                ++data.requiredRows;
                eachX = data.toFitRec.x;
            }
            this.myTabs.layout(eachLabel, eachX, 0, size.width, 1);
            eachX += size.width + JBTabsImpl.getInterTabSpaceLength();
            data.requiredWidth += size.width + JBTabsImpl.getInterTabSpaceLength();
        }
        int selectedRow = -1;
        eachX = data.toFitRec.x;
        data.rowToFitMaxX = (int)data.toFitRec.getMaxX();
        if (data.requiredRows > 1) {
            int rowFit = insets.left + data.requiredWidth / data.requiredRows;
            for (TabInfo eachInfo : data.myVisibleInfos) {
                TabLabel eachLabel = this.myTabs.myInfo2Label.get(eachInfo);
                Rectangle eachBounds = eachLabel.getBounds();
                if (!eachBounds.contains(rowFit, 0)) continue;
                data.rowToFitMaxX = (int)eachLabel.getBounds().getMaxX();
                break;
            }
        }
        for (TabInfo eachInfo : data.myVisibleInfos) {
            TabLabel eachLabel = this.myTabs.myInfo2Label.get(eachInfo);
            Dimension size = eachLabel.getPreferredSize();
            if (eachX + size.width <= data.rowToFitMaxX) {
                eachTableRow.add(eachInfo);
                if (this.myTabs.getSelectedInfo() == eachInfo) {
                    selectedRow = eachRow;
                }
                eachX += size.width + JBTabsImpl.getInterTabSpaceLength();
                continue;
            }
            eachTableRow = new TableRow(data);
            data.table.add(eachTableRow);
            ++eachRow;
            eachX = insets.left + size.width;
            eachTableRow.add(eachInfo);
            if (this.myTabs.getSelectedInfo() != eachInfo) continue;
            selectedRow = eachRow;
        }
        ArrayList<TableRow> toMove = new ArrayList<TableRow>();
        for (int i = selectedRow + 1; i < data.table.size(); ++i) {
            toMove.add(data.table.get(i));
        }
        for (TableRow eachMove : toMove) {
            data.table.remove(eachMove);
            data.table.add(0, eachMove);
        }
        return data;
    }

    public boolean isLastRow(TabInfo info) {
        if (info == null) {
            return false;
        }
        List<TableRow> rows = this.myLastTableLayout.table;
        if (rows.size() > 0) {
            for (TabInfo tabInfo : rows.get((int)(rows.size() - 1)).myColumns) {
                if (tabInfo != info) continue;
                return true;
            }
        }
        return false;
    }

    public LayoutPassInfo layoutTable(List<TabInfo> visibleInfos) {
        this.myTabs.resetLayout(true);
        TablePassInfo data = this.computeLayoutTable(visibleInfos);
        Insets insets = this.myTabs.getLayoutInsets();
        int eachY = insets.top;
        int row = 0;
        int tabUnderlineFix = this.myTabs.isEditorTabs() ? 4 : 0;
        for (TableRow eachRow : data.table) {
            int eachX = insets.left;
            int deltaToFit = 0;
            boolean toAjust = false;
            if (eachRow.width < data.toFitRec.width && data.table.size() > 1) {
                deltaToFit = (int)Math.floor((double)(data.toFitRec.width - eachRow.width) / (double)eachRow.myColumns.size());
                toAjust = true;
            }
            for (int i = 0; i < eachRow.myColumns.size(); ++i) {
                TabInfo tabInfo = eachRow.myColumns.get(i);
                TabLabel label = this.myTabs.myInfo2Label.get(tabInfo);
                label.putClientProperty("Layout.stretchedByWidth", toAjust);
                int width = i < eachRow.myColumns.size() - 1 || !toAjust ? label.getPreferredSize().width + deltaToFit : data.toFitRec.width + insets.left - eachX;
                this.myTabs.layout(label, eachX, eachY, width, row < data.table.size() - 1 ? this.myTabs.myHeaderFitSize.height - tabUnderlineFix : this.myTabs.myHeaderFitSize.height);
                label.setAlignmentToCenter(deltaToFit > 0);
                boolean lastCell = i == eachRow.myColumns.size() - 1;
                eachX += width + (lastCell ? 0 : JBTabsImpl.getInterTabSpaceLength());
            }
            eachY += this.myTabs.myHeaderFitSize.height - 1 + JBTabsImpl.getInterTabSpaceLength() - (row < data.table.size() - 1 ? tabUnderlineFix : 0);
            ++row;
        }
        if (this.myTabs.getSelectedInfo() != null) {
            JBTabsImpl.Toolbar selectedToolbar = this.myTabs.myInfo2Toolbar.get(this.myTabs.getSelectedInfo());
            int xAddin = 0;
            if (!this.myTabs.myHorizontalSide && selectedToolbar != null && !selectedToolbar.isEmpty()) {
                xAddin = selectedToolbar.getPreferredSize().width + 1;
                this.myTabs.layout(selectedToolbar, insets.left + 1, eachY + 1, selectedToolbar.getPreferredSize().width, this.myTabs.getHeight() - eachY - insets.bottom - 2);
            }
            this.myTabs.layoutComp(xAddin, eachY + (this.myTabs.isEditorTabs() ? 0 : 2) - this.myTabs.getLayoutInsets().top, this.myTabs.getSelectedInfo().getComponent(), 0, 0);
        }
        this.myLastTableLayout = data;
        return data;
    }

    @Override
    public int getDropIndexFor(Point point) {
        return -1;
    }
}

