/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.ui.Gray;
import com.intellij.ui.tabs.impl.JBEditorTabsPainter;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;

class DarculaEditorTabsPainter
implements JBEditorTabsPainter {
    DarculaEditorTabsPainter() {
    }

    @Override
    public void doPaintInactive(Graphics2D g2d, Rectangle effectiveBounds, int x, int y, int w, int h, Color tabColor, int row, int column, boolean vertical) {
        if (tabColor != null) {
            g2d.setColor(tabColor);
            g2d.fillRect(x, y, w, h);
        } else {
            g2d.setPaint(UIUtil.getControlColor());
            g2d.fillRect(x, y, w, h);
        }
        g2d.setColor(Gray._0.withAlpha(10));
        g2d.drawRect(x, y, w - 1, h - 1);
    }

    @Override
    public void doPaintBackground(Graphics2D g, Rectangle clip, boolean vertical, Rectangle rectangle) {
        g.setColor(UIUtil.getPanelBackground());
        g.fill(clip);
        g.setColor(new Color(0, 0, 0, 80));
        g.fill(clip);
        int x = rectangle.x;
        int y = rectangle.y;
        int h = rectangle.height;
        g.setPaint(UIUtil.getGradientPaint((float)x, (float)y, (Color)Gray._78.withAlpha(160), (float)x, (float)(y + h), (Color)Gray._78.withAlpha(120)));
        int w = rectangle.width;
        g.fillRect(x, rectangle.y, w, h + (vertical ? 1 : 0));
        if (!vertical) {
            g.setColor((Color)Gray._78);
            g.drawLine(x, rectangle.y, x + w, rectangle.y);
        }
    }

    @Override
    public void paintSelectionAndBorder(Graphics2D g2d, Rectangle rect, JBTabsImpl.ShapeInfo selectedShape, Insets insets, Color tabColor, boolean horizontalTabs) {
        Insets i = selectedShape.path.transformInsets(insets);
        int _x = rect.x;
        int _y = rect.y;
        int _height = rect.height;
        if (!horizontalTabs) {
            g2d.setColor(new Color(0, 0, 0, 45));
            g2d.draw(selectedShape.labelPath.transformLine(i.left, selectedShape.labelPath.getMaxY() - selectedShape.labelPath.deltaY(4), selectedShape.path.getMaxX(), selectedShape.labelPath.getMaxY() - selectedShape.labelPath.deltaY(4)));
            g2d.setColor(new Color(0, 0, 0, 15));
            g2d.draw(selectedShape.labelPath.transformLine(i.left, selectedShape.labelPath.getMaxY() - selectedShape.labelPath.deltaY(5), selectedShape.path.getMaxX(), selectedShape.labelPath.getMaxY() - selectedShape.labelPath.deltaY(5)));
        }
        if (tabColor != null) {
            g2d.setColor(tabColor);
            g2d.fill(selectedShape.fillPath.getShape());
            g2d.setPaint(UIUtil.getGradientPaint((float)_x, (float)_y, (Color)Gray._255.withAlpha(50), (float)_x, (float)(_y + _height), (Color)Gray._255.withAlpha(0)));
        } else {
            g2d.setPaint(UIUtil.getGradientPaint((float)_x, (float)_y, (Color)Gray._85, (float)_x, (float)(_y + _height), (Color)Gray._60));
        }
        g2d.fill(selectedShape.fillPath.getShape());
        g2d.setColor(Gray._135.withAlpha(90));
        g2d.draw(selectedShape.fillPath.getShape());
        g2d.draw(selectedShape.labelPath.transformLine(selectedShape.labelPath.getMaxX() - selectedShape.labelPath.deltaX(1), selectedShape.labelPath.getY() + selectedShape.labelPath.deltaY(1), selectedShape.labelPath.getMaxX() - selectedShape.labelPath.deltaX(1), selectedShape.labelPath.getMaxY() - selectedShape.labelPath.deltaY(4)));
        if (!horizontalTabs) {
            g2d.setColor(Gray._0.withAlpha(30));
            g2d.draw(selectedShape.labelPath.transformLine(selectedShape.labelPath.getMaxX() + selectedShape.labelPath.deltaX(1), selectedShape.labelPath.getY() + selectedShape.labelPath.deltaY(1), selectedShape.labelPath.getMaxX() + selectedShape.labelPath.deltaX(1), selectedShape.labelPath.getMaxY() - selectedShape.labelPath.deltaY(4)));
            g2d.draw(selectedShape.labelPath.transformLine(selectedShape.labelPath.getX() - selectedShape.labelPath.deltaX(horizontalTabs ? 2 : 1), selectedShape.labelPath.getY() + selectedShape.labelPath.deltaY(1), selectedShape.labelPath.getX() - selectedShape.labelPath.deltaX(horizontalTabs ? 2 : 1), selectedShape.labelPath.getMaxY() - selectedShape.labelPath.deltaY(4)));
        }
        g2d.setColor(new Color(0, 0, 0, 50));
        g2d.draw(selectedShape.labelPath.transformLine(i.left, selectedShape.labelPath.getMaxY(), selectedShape.path.getMaxX(), selectedShape.labelPath.getMaxY()));
    }

    @Override
    public Color getBackgroundColor() {
        return new Color(3948353);
    }
}

