/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.table;

import com.intellij.ui.GuiUtils;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.BaseTableView;
import com.intellij.ui.table.ItemsProvider;
import com.intellij.ui.table.SelectionProvider;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.SortableColumnModel;
import com.intellij.util.ui.TableViewModel;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableView<Item>
extends BaseTableView
implements ItemsProvider,
SelectionProvider {
    public TableView() {
        this((ListTableModel<Item>)new ListTableModel(ColumnInfo.EMPTY_ARRAY));
    }

    public TableView(ListTableModel<Item> model) {
        super(model);
        this.setModelAndUpdateColumns(model);
    }

    @Override
    public void setModel(@NotNull TableModel dataModel) {
        if (dataModel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/table/TableView", "setModel"));
        }
        assert (dataModel instanceof SortableColumnModel) : "SortableColumnModel required";
        super.setModel(dataModel);
    }

    @Deprecated
    public void setModel(ListTableModel<Item> model) {
        this.setModelAndUpdateColumns(model);
    }

    public void setModelAndUpdateColumns(ListTableModel<Item> model) {
        super.setModel((TableModel)model);
        this.createDefaultColumnsFromModel();
        this.updateColumnSizes();
    }

    public ListTableModel<Item> getListTableModel() {
        return (ListTableModel)super.getModel();
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        Item item;
        ColumnInfo columnInfo = this.getListTableModel().getColumnInfos()[this.convertColumnIndexToModel(column)];
        TableCellRenderer renderer = columnInfo.getCustomizedRenderer(item = this.getRow(row), columnInfo.getRenderer(item));
        if (renderer == null) {
            return super.getCellRenderer(row, column);
        }
        return renderer;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.isEditing()) {
            this.getCellEditor().cancelCellEditing();
        }
        super.tableChanged(e);
    }

    public void setSelection(Collection<Item> selection) {
        this.clearSelection();
        for (Item aSelection : selection) {
            this.addSelection(aSelection);
        }
    }

    public void updateColumnSizes() {
        JTableHeader header = this.getTableHeader();
        TableCellRenderer defaultRenderer = header == null ? null : header.getDefaultRenderer();
        RowSorter<? extends TableModel> sorter = this.getRowSorter();
        RowSorter.SortKey sortKey = sorter == null ? null : (RowSorter.SortKey)ContainerUtil.getFirstItem(sorter.getSortKeys());
        ColumnInfo[] columns = this.getListTableModel().getColumnInfos();
        int[] sizeMode = new int[columns.length];
        int[] headers = new int[columns.length];
        int[] widths = new int[columns.length];
        int allColumnWidth = 0;
        int allColumnCurrent = 0;
        int varCount = 0;
        Icon sortIcon = UIManager.getIcon("Table.ascendingSortIcon");
        for (int i = 0; i < columns.length; ++i) {
            Component headerComponent;
            ColumnInfo columnInfo = columns[i];
            TableColumn column = this.getColumnModel().getColumn(i);
            TableCellRenderer columnHeaderRenderer = column.getHeaderRenderer();
            if (columnHeaderRenderer == null) {
                columnHeaderRenderer = defaultRenderer;
            }
            Component component = headerComponent = columnHeaderRenderer == null ? null : columnHeaderRenderer.getTableCellRendererComponent(this, column.getHeaderValue(), false, false, 0, i);
            if (headerComponent != null) {
                headers[i] = headerComponent.getPreferredSize().width;
                if (sorter != null && columnInfo.isSortable() && sortIcon != null && (sortKey == null || sortKey.getColumn() != i)) {
                    int n = i;
                    headers[n] = headers[n] + (sortIcon.getIconWidth() + (headerComponent instanceof JLabel ? ((JLabel)headerComponent).getIconTextGap() : 0));
                }
            }
            if (columnInfo.getWidth((JTable)this) > 0) {
                int width;
                sizeMode[i] = 1;
                widths[i] = width = columnInfo.getWidth((JTable)this);
            } else {
                String maxStringValue = columnInfo.getMaxStringValue();
                if (maxStringValue != null) {
                    sizeMode[i] = 2;
                    widths[i] = this.getFontMetrics(this.getFont()).stringWidth(maxStringValue) + columnInfo.getAdditionalWidth();
                    ++varCount;
                } else {
                    String preferredValue = columnInfo.getPreferredStringValue();
                    if (preferredValue != null) {
                        sizeMode[i] = 3;
                        widths[i] = this.getFontMetrics(this.getFont()).stringWidth(preferredValue) + columnInfo.getAdditionalWidth();
                        ++varCount;
                    }
                }
            }
            allColumnWidth += widths[i];
            allColumnCurrent += column.getPreferredWidth();
        }
        allColumnWidth = Math.max(allColumnWidth, allColumnCurrent);
        int viewWidth = this.getParent() != null ? this.getParent().getWidth() : this.getWidth();
        double gold = 0.5 * (3.0 - Math.sqrt(5.0));
        int addendum = varCount == 0 || viewWidth < allColumnWidth ? 0 : (int)(((double)allColumnWidth < gold * (double)viewWidth ? gold * (double)viewWidth : ((double)allColumnWidth < (1.0 - gold) * (double)viewWidth ? (1.0 - gold) * (double)viewWidth : (double)viewWidth)) - (double)allColumnWidth) / varCount;
        for (int i = 0; i < columns.length; ++i) {
            TableColumn column = this.getColumnModel().getColumn(i);
            int width = widths[i];
            if (sizeMode[i] == 1) {
                column.setMaxWidth(width);
                column.setPreferredWidth(width);
                column.setMinWidth(width);
                continue;
            }
            if (sizeMode[i] == 2) {
                width = Math.max(column.getPreferredWidth(), Math.max(width + addendum, headers[i]));
                column.setPreferredWidth(width);
                column.setMaxWidth(width);
                continue;
            }
            if (sizeMode[i] != 3) continue;
            width = Math.max(column.getPreferredWidth(), Math.max(width + addendum, headers[i]));
            column.setPreferredWidth(width);
        }
    }

    @Override
    public Collection<Item> getSelection() {
        return this.getSelectedObjects();
    }

    @Nullable
    public Item getSelectedObject() {
        int row = this.getSelectedRow();
        ListTableModel<Item> model = this.getListTableModel();
        return (Item)(row >= 0 && row < model.getRowCount() ? model.getRowValue(this.convertRowIndexToModel(row)) : null);
    }

    @NotNull
    public List<Item> getSelectedObjects() {
        ListSelectionModel selectionModel = this.getSelectionModel();
        int minSelectionIndex = selectionModel.getMinSelectionIndex();
        int maxSelectionIndex = selectionModel.getMaxSelectionIndex();
        if (minSelectionIndex == -1 || maxSelectionIndex == -1) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/table/TableView", "getSelectedObjects"));
            }
            return list;
        }
        SmartList result = new SmartList();
        ListTableModel<Item> model = this.getListTableModel();
        for (int i = minSelectionIndex; i <= maxSelectionIndex; ++i) {
            int modelIndex;
            if (!selectionModel.isSelectedIndex(i) || (modelIndex = this.convertRowIndexToModel(i)) < 0 || modelIndex >= model.getRowCount()) continue;
            result.add(model.getRowValue(modelIndex));
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/table/TableView", "getSelectedObjects"));
        }
        return smartList;
    }

    @Override
    public void addSelection(Object item) {
        int index = this.getListTableModel().indexOf(item);
        if (index < 0) {
            return;
        }
        this.getSelectionModel().addSelectionInterval(this.convertRowIndexToView(index), this.convertRowIndexToView(index));
        this.getColumnModel().getSelectionModel().addSelectionInterval(0, this.getColumnCount() - 1);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        TableCellEditor editor = this.getListTableModel().getColumnInfos()[this.convertColumnIndexToModel(column)].getEditor(this.getRow(row));
        return editor == null ? super.getCellEditor(row, column) : editor;
    }

    @Override
    public List<Item> getItems() {
        return this.getListTableModel().getItems();
    }

    public Item getRow(int row) {
        return (Item)this.getListTableModel().getRowValue(this.convertRowIndexToModel(row));
    }

    public void setMinRowHeight(int i) {
        this.setRowHeight(Math.max(i, this.getRowHeight()));
    }

    public JTable getComponent() {
        return this;
    }

    public TableViewModel getTableViewModel() {
        return this.getListTableModel();
    }

    public void stopEditing() {
        TableUtil.stopEditing((JTable)this);
    }

    @Override
    protected void createDefaultEditors() {
        super.createDefaultEditors();
        this.defaultEditorsByColumnClass.put(String.class, new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new DefaultCellEditor(GuiUtils.createUndoableTextField());
            }
        });
    }
}

