/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.table;

import com.intellij.Patches;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.Animated;
import com.intellij.ui.ComponentWithExpandableItems;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.ExpandableItemsHandlerFactory;
import com.intellij.ui.ExpandedItemRendererComponentWrapper;
import com.intellij.ui.Graphics2DDelegate;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.TableCell;
import com.intellij.ui.components.JBViewport;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JTableCellEditorHelper;
import com.intellij.util.ui.SortableColumnModel;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultRowSorter;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;
import org.jetbrains.annotations.NotNull;

public class JBTable
extends JTable
implements ComponentWithEmptyText,
ComponentWithExpandableItems<TableCell> {
    private final StatusText myEmptyText = new StatusText(this){

        @Override
        protected boolean isStatusVisible() {
            return JBTable.this.isEmpty();
        }
    };
    private final ExpandableItemsHandler<TableCell> myExpandableItemsHandler = ExpandableItemsHandlerFactory.install(this);
    private MyCellEditorRemover myEditorRemover;
    private boolean myEnableAntialiasing;
    private int myRowHeight = -1;
    private boolean myRowHeightIsExplicitlySet;
    private boolean myRowHeightIsComputing;
    private Integer myMinRowHeight;
    private boolean myStriped;
    private boolean isTypeAhead = true;
    private AsyncProcessIcon myBusyIcon;
    private boolean myBusy;

    public JBTable() {
        this(new DefaultTableModel());
    }

    public JBTable(TableModel model) {
        super(model);
        this.setFillsViewportHeight(true);
        this.addMouseListener(new MyMouseListener());
        this.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                if (JBTable.this.cellEditor != null && !(JBTable.this.cellEditor instanceof Animated)) {
                    JBTable.this.cellEditor.stopCellEditing();
                }
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }
        });
        final TableModelListener modelListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (!JBTable.this.myRowHeightIsExplicitlySet) {
                    JBTable.this.myRowHeight = -1;
                }
                if (e.getType() == -1 && JBTable.this.isEmpty() || e.getType() == 1 && !JBTable.this.isEmpty()) {
                    JBTable.this.repaintViewport();
                }
            }
        };
        if (this.getModel() != null) {
            this.getModel().addTableModelListener(modelListener);
        }
        this.addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JBTable.this.repaintViewport();
                if (evt.getOldValue() instanceof TableModel) {
                    ((TableModel)evt.getOldValue()).removeTableModelListener(modelListener);
                }
                if (evt.getNewValue() instanceof TableModel) {
                    ((TableModel)evt.getNewValue()).addTableModelListener(modelListener);
                }
            }
        });
        boolean marker = Patches.SUN_BUG_ID_4503845;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowHeight() {
        if (this.myRowHeightIsComputing) {
            return super.getRowHeight();
        }
        if (this.myRowHeight < 0) {
            try {
                this.myRowHeightIsComputing = true;
                for (int row = 0; row < this.getRowCount(); ++row) {
                    for (int column = 0; column < this.getColumnCount(); ++column) {
                        Object value;
                        Component component;
                        TableCellRenderer renderer = this.getCellRenderer(row, column);
                        if (renderer == null || (component = renderer.getTableCellRendererComponent(this, value = this.getValueAt(row, column), true, true, row, column)) == null) continue;
                        Dimension size = component.getPreferredSize();
                        this.myRowHeight = Math.max(size.height, this.myRowHeight);
                    }
                }
            }
            finally {
                this.myRowHeightIsComputing = false;
            }
        }
        if (this.myMinRowHeight == null) {
            this.myMinRowHeight = this.getFontMetrics(UIManager.getFont("Label.font")).getHeight();
        }
        return Math.max(this.myRowHeight, this.myMinRowHeight);
    }

    public void setShowColumns(boolean value) {
        JTableHeader tableHeader = this.getTableHeader();
        tableHeader.setVisible(value);
        tableHeader.setPreferredSize(value ? null : new Dimension());
    }

    @Override
    public void setRowHeight(int rowHeight) {
        this.myRowHeight = rowHeight;
        this.myRowHeightIsExplicitlySet = true;
        super.setRowHeight(rowHeight);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.myMinRowHeight = null;
    }

    private void repaintViewport() {
        if (!this.isDisplayable() || !this.isVisible()) {
            return;
        }
        Container p = this.getParent();
        if (p instanceof JBViewport) {
            p.repaint();
        }
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JBTableHeader();
    }

    public boolean isEmpty() {
        return this.getRowCount() == 0;
    }

    @Override
    public void setModel(@NotNull TableModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/table/JBTable", "setModel"));
        }
        super.setModel(model);
        if (model instanceof SortableColumnModel) {
            SortableColumnModel sortableModel = (SortableColumnModel)model;
            if (sortableModel.isSortable()) {
                TableRowSorter<TableModel> rowSorter = this.createRowSorter(model);
                rowSorter.setSortsOnUpdates(this.isSortOnUpdates());
                this.setRowSorter(rowSorter);
                RowSorter.SortKey sortKey = sortableModel.getDefaultSortKey();
                if (sortKey != null && sortKey.getColumn() >= 0 && sortKey.getColumn() < model.getColumnCount() && sortableModel.getColumnInfos()[sortKey.getColumn()].isSortable()) {
                    rowSorter.setSortKeys(Arrays.asList(sortKey));
                }
            } else {
                RowSorter<? extends TableModel> rowSorter = this.getRowSorter();
                if (rowSorter instanceof DefaultColumnInfoBasedRowSorter) {
                    this.setRowSorter(null);
                }
            }
        }
    }

    protected boolean isSortOnUpdates() {
        return true;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.myEnableAntialiasing) {
            GraphicsUtil.setupAntialiasing((Graphics)g);
        }
        super.paintComponent(g);
        this.myEmptyText.paint(this, g);
    }

    @Override
    protected void paintChildren(Graphics g) {
        if (this.myEnableAntialiasing) {
            GraphicsUtil.setupAntialiasing((Graphics)g);
        }
        super.paintChildren(g);
    }

    public void setEnableAntialiasing(boolean flag) {
        this.myEnableAntialiasing = flag;
    }

    public static DefaultCellEditor createBooleanEditor() {
        return new DefaultCellEditor(new JCheckBox()){
            {
                ((JCheckBox)this.getComponent()).setHorizontalAlignment(0);
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                Component component = super.getTableCellEditorComponent(table, value, isSelected, row, column);
                component.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                return component;
            }
        };
    }

    public void resetDefaultFocusTraversalKeys() {
        KeyboardFocusManager m = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        for (Integer each : Arrays.asList(0, 1, 2, 3)) {
            this.setFocusTraversalKeys(each, m.getDefaultFocusTraversalKeys(each));
        }
    }

    @Override
    @NotNull
    public StatusText getEmptyText() {
        StatusText statusText = this.myEmptyText;
        if (statusText == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/table/JBTable", "getEmptyText"));
        }
        return statusText;
    }

    @Override
    @NotNull
    public ExpandableItemsHandler<TableCell> getExpandableItemsHandler() {
        ExpandableItemsHandler<TableCell> expandableItemsHandler = this.myExpandableItemsHandler;
        if (expandableItemsHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/table/JBTable", "getExpandableItemsHandler"));
        }
        return expandableItemsHandler;
    }

    @Override
    public void setExpandableItemsEnabled(boolean enabled) {
        this.myExpandableItemsHandler.setEnabled(enabled);
    }

    @Override
    public void removeNotify() {
        if (ScreenUtil.isStandardAddRemoveNotify(this)) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            keyboardFocusManager.removePropertyChangeListener("permanentFocusOwner", this.myEditorRemover);
            keyboardFocusManager.removePropertyChangeListener("focusOwner", this.myEditorRemover);
            super.removeNotify();
            if (this.myBusyIcon != null) {
                this.remove(this.myBusyIcon);
                Disposer.dispose((Disposable)this.myBusyIcon);
                this.myBusyIcon = null;
            }
        } else {
            super.removeNotify();
        }
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return super.getScrollableUnitIncrement(visibleRect, orientation, direction);
        }
        return SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), " ");
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.myBusyIcon != null) {
            this.myBusyIcon.updateLocation(this);
        }
    }

    @Override
    public void paint(Graphics g) {
        if (!this.isEnabled()) {
            g = new TableGrayer((Graphics2D)g);
        }
        super.paint((Graphics)g);
        if (this.myBusyIcon != null) {
            this.myBusyIcon.updateLocation(this);
        }
    }

    public void setPaintBusy(boolean paintBusy) {
        if (this.myBusy == paintBusy) {
            return;
        }
        this.myBusy = paintBusy;
        this.updateBusy();
    }

    private void updateBusy() {
        if (this.myBusy && this.myBusyIcon == null) {
            this.myBusyIcon = new AsyncProcessIcon(this.toString()).setUseMask(false);
            this.myBusyIcon.setOpaque(false);
            this.myBusyIcon.setPaintPassiveIcon(false);
            this.add(this.myBusyIcon);
        }
        if (this.myBusyIcon != null) {
            if (this.myBusy) {
                this.myBusyIcon.resume();
            } else {
                this.myBusyIcon.suspend();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (JBTable.this.myBusyIcon != null) {
                            JBTable.this.repaint();
                        }
                    }
                });
            }
            if (this.myBusyIcon != null) {
                this.myBusyIcon.updateLocation(this);
            }
        }
    }

    public boolean isStriped() {
        return this.myStriped;
    }

    public void setStriped(boolean striped) {
        this.myStriped = striped;
        if (striped) {
            this.getColumnModel().setColumnMargin(0);
            this.setIntercellSpacing(new Dimension(this.getIntercellSpacing().width, 0));
            this.setShowGrid(false);
        }
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        TableCellEditor editor;
        SpeedSearchSupply supply;
        if (this.cellEditor != null && !this.cellEditor.stopCellEditing()) {
            return false;
        }
        if (row < 0 || row >= this.getRowCount() || column < 0 || column >= this.getColumnCount()) {
            return false;
        }
        if (!this.isCellEditable(row, column)) {
            return false;
        }
        if (e instanceof KeyEvent && UIUtil.isReallyTypedEvent((KeyEvent)((KeyEvent)e)) && (supply = SpeedSearchSupply.getSupply(this)) != null && supply.isPopupActive()) {
            return false;
        }
        if (this.myEditorRemover == null) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.myEditorRemover = new MyCellEditorRemover();
            keyboardFocusManager.addPropertyChangeListener("focusOwner", this.myEditorRemover);
            keyboardFocusManager.addPropertyChangeListener("permanentFocusOwner", this.myEditorRemover);
        }
        if ((editor = this.getCellEditor(row, column)) != null && editor.isCellEditable(e)) {
            this.editorComp = this.prepareEditor(editor, row, column);
            if (this.editorComp == null) {
                this.removeEditor();
                return false;
            }
            this.editorComp.setBounds(this.getCellRect(row, column, false));
            this.add(this.editorComp);
            this.editorComp.validate();
            IdeFocusManager.findInstanceByComponent(this).requestFocus(this.editorComp, false);
            this.setCellEditor(editor);
            this.setEditingRow(row);
            this.setEditingColumn(column);
            editor.addCellEditorListener(this);
            if (this.isTypeAhead) {
                JTableCellEditorHelper.typeAhead(this, e, row, column);
            }
            return true;
        }
        return false;
    }

    private static boolean isTableDecorationSupported() {
        return UIUtil.isUnderAlloyLookAndFeel() || UIUtil.isUnderNativeMacLookAndFeel() || UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF() || UIUtil.isUnderNimbusLookAndFeel() || UIUtil.isUnderWindowsLookAndFeel();
    }

    public void disableTypeAheadInCellEditors() {
        this.isTypeAhead = false;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component result = super.prepareRenderer(renderer, row, column);
        if (UIUtil.isUnderGTKLookAndFeel()) {
            UIUtil.changeBackGround((Component)this, (Color)UIUtil.getTreeTextBackground());
        }
        if (JBTable.isTableDecorationSupported() && this.isStriped() && result instanceof JComponent) {
            Color bg = row % 2 == 1 ? this.getBackground() : UIUtil.getDecoratedRowColor();
            JComponent c = (JComponent)result;
            boolean cellSelected = this.isCellSelected(row, column);
            if (!cellSelected) {
                c.setOpaque(true);
                c.setBackground(bg);
                for (Component child : c.getComponents()) {
                    child.setBackground(bg);
                }
            }
        }
        if (this.myExpandableItemsHandler.getExpandedItems().contains(new TableCell(row, column))) {
            result = new ExpandedItemRendererComponentWrapper(result);
        }
        return result;
    }

    protected TableRowSorter<TableModel> createRowSorter(TableModel model) {
        return new DefaultColumnInfoBasedRowSorter(model);
    }

    private final class TableGrayer
    extends Graphics2DDelegate {
        public TableGrayer(Graphics2D g2d) {
            super(g2d);
        }

        public void setColor(Color color) {
            if (!UIUtil.isUnderDarcula() || !JBTable.this.getBackground().equals(color)) {
                color = new Color(UIUtil.getGrayFilter().filterRGB(0, 0, color.getRGB()));
            }
            super.setColor(color);
        }

        public Graphics create() {
            return new TableGrayer((Graphics2D)super.create());
        }
    }

    protected class JBTableHeader
    extends JTableHeader {
        public JBTableHeader() {
            super(JBTable.this.columnModel);
            JBTable.this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    JBTableHeader.this.revalidate();
                    JBTableHeader.this.repaint();
                }
            });
        }

        @Override
        public void paint(Graphics g) {
            if (JBTable.this.myEnableAntialiasing) {
                GraphicsUtil.setupAntialiasing((Graphics)g);
            }
            if (!JBTable.this.isEnabled()) {
                g = new TableGrayer((Graphics2D)g);
            }
            super.paint((Graphics)g);
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            TableModel model = JBTable.this.getModel();
            if (model instanceof SortableColumnModel) {
                String tooltipText;
                int i = this.columnAtPoint(event.getPoint());
                int infoIndex = i >= 0 ? JBTable.this.convertColumnIndexToModel(i) : -1;
                ColumnInfo[] columnInfos = ((SortableColumnModel)model).getColumnInfos();
                String string = tooltipText = infoIndex >= 0 && infoIndex < columnInfos.length ? columnInfos[infoIndex].getTooltipText() : null;
                if (tooltipText != null) {
                    return tooltipText;
                }
            }
            return super.getToolTipText(event);
        }
    }

    protected static class DefaultColumnInfoBasedRowSorter
    extends TableRowSorter<TableModel> {
        public DefaultColumnInfoBasedRowSorter(TableModel model) {
            super(model);
            this.setModelWrapper(new TableRowSorterModelWrapper(model));
            this.setMaxSortKeys(1);
        }

        @Override
        public Comparator<?> getComparator(int column) {
            TableModel model = (TableModel)this.getModel();
            if (model instanceof SortableColumnModel) {
                Comparator comparator;
                ColumnInfo[] columnInfos = ((SortableColumnModel)model).getColumnInfos();
                if (column >= 0 && column < columnInfos.length && (comparator = columnInfos[column].getComparator()) != null) {
                    return comparator;
                }
            }
            return super.getComparator(column);
        }

        @Override
        protected boolean useToString(int column) {
            return false;
        }

        @Override
        public boolean isSortable(int column) {
            TableModel model = (TableModel)this.getModel();
            if (model instanceof SortableColumnModel) {
                ColumnInfo[] columnInfos = ((SortableColumnModel)model).getColumnInfos();
                if (column >= 0 && column < columnInfos.length) {
                    return columnInfos[column].isSortable() && columnInfos[column].getComparator() != null;
                }
            }
            return false;
        }

        private class TableRowSorterModelWrapper
        extends DefaultRowSorter.ModelWrapper<TableModel, Integer> {
            private final TableModel myModel;

            private TableRowSorterModelWrapper(TableModel model) {
                if (model == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/table/JBTable$DefaultColumnInfoBasedRowSorter$TableRowSorterModelWrapper", "<init>"));
                }
                this.myModel = model;
            }

            @Override
            public TableModel getModel() {
                return this.myModel;
            }

            @Override
            public int getColumnCount() {
                return this.myModel.getColumnCount();
            }

            @Override
            public int getRowCount() {
                return this.myModel.getRowCount();
            }

            @Override
            public Object getValueAt(int row, int column) {
                if (this.myModel instanceof SortableColumnModel) {
                    return ((SortableColumnModel)this.myModel).getRowValue(row);
                }
                return this.myModel.getValueAt(row, column);
            }

            @Override
            public String getStringValueAt(int row, int column) {
                TableStringConverter converter = DefaultColumnInfoBasedRowSorter.this.getStringConverter();
                if (converter != null) {
                    String value = converter.toString(this.myModel, row, column);
                    if (value != null) {
                        return value;
                    }
                    return "";
                }
                Object o = this.getValueAt(row, column);
                if (o == null) {
                    return "";
                }
                String string = o.toString();
                if (string == null) {
                    return "";
                }
                return string;
            }

            @Override
            public Integer getIdentifier(int index) {
                return index;
            }
        }
    }

    private final class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int row;
            int[] selectedRows;
            if (SwingUtilities.isRightMouseButton(e) && (selectedRows = JBTable.this.getSelectedRows()).length < 2 && (row = JBTable.this.rowAtPoint(e.getPoint())) != -1) {
                JBTable.this.getSelectionModel().setSelectionInterval(row, row);
            }
        }
    }

    private final class MyCellEditorRemover
    implements PropertyChangeListener {
        private final IdeFocusManager myFocusManager;

        public MyCellEditorRemover() {
            this.myFocusManager = IdeFocusManager.findInstanceByComponent(JBTable.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (!JBTable.this.isEditing()) {
                return;
            }
            this.myFocusManager.doWhenFocusSettlesDown(new Runnable(){

                @Override
                public void run() {
                    if (!JBTable.this.isEditing()) {
                        return;
                    }
                    for (Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(); c != null; c = c.getParent()) {
                        if (c instanceof JPopupMenu) {
                            c = ((JPopupMenu)c).getInvoker();
                        }
                        if (c == JBTable.this) {
                            return;
                        }
                        if (!(c instanceof Window)) continue;
                        if (c != SwingUtilities.getWindowAncestor(JBTable.this)) break;
                        JBTable.this.getCellEditor().stopCellEditing();
                        break;
                    }
                }
            });
        }
    }
}

