/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.speedSearch;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.speedSearch.FilteringListModel;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.Function;
import javax.swing.JList;

public class NameFilteringListModel<T>
extends FilteringListModel<T> {
    private final Function<T, String> myNamer;
    private int myFullMatchIndex = -1;
    private int myStartsWithIndex = -1;
    private final Computable<String> myPattern;

    public NameFilteringListModel(JList list, Function<T, String> namer, Condition<String> filter, final SpeedSearch speedSearch) {
        this(list, namer, filter, new Computable<String>(){

            public String compute() {
                return speedSearch.getFilter();
            }
        });
    }

    public NameFilteringListModel(JList list, Function<T, String> namer, Condition<String> filter, final SpeedSearchSupply speedSearch) {
        this(list, namer, filter, new Computable<String>(){

            public String compute() {
                String prefix = speedSearch.getEnteredPrefix();
                return prefix == null ? "" : prefix;
            }
        });
    }

    public NameFilteringListModel(JList list, final Function<T, String> namer, final Condition<String> filter, Computable<String> pattern) {
        super(list);
        this.myPattern = pattern;
        this.myNamer = namer;
        this.setFilter(namer != null ? new Condition<T>(){

            public boolean value(T t) {
                return filter.value(namer.fun(t));
            }
        } : null);
    }

    @Override
    protected void addToFiltered(T elt) {
        super.addToFiltered(elt);
        if (this.myNamer != null) {
            String filterString = StringUtil.toUpperCase((String)((String)this.myPattern.compute()));
            String candidateString = StringUtil.toUpperCase((String)((String)this.myNamer.fun(elt)));
            int index = this.getSize() - 1;
            if (this.myFullMatchIndex == -1 && filterString.equals(candidateString)) {
                this.myFullMatchIndex = index;
            }
            if (this.myStartsWithIndex == -1 && candidateString.startsWith(filterString)) {
                this.myStartsWithIndex = index;
            }
        }
    }

    @Override
    public void refilter() {
        this.myFullMatchIndex = -1;
        this.myStartsWithIndex = -1;
        super.refilter();
    }

    public int getClosestMatchIndex() {
        return this.myFullMatchIndex != -1 ? this.myFullMatchIndex : this.myStartsWithIndex;
    }
}

