/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.Patches;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.containers.WeakHashMap;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.Area;
import java.util.Map;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenUtil {
    public static final String DISPOSE_TEMPORARY = "dispose.temporary";
    @Nullable
    private static final Map<GraphicsConfiguration, Pair<Insets, Long>> ourInsetsCache;
    private static final int ourInsetsTimeout = 5000;

    private ScreenUtil() {
    }

    public static boolean isVisible(@NotNull Rectangle bounds) {
        Rectangle[] allScreenBounds;
        if (bounds == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/ScreenUtil", "isVisible"));
        }
        if (bounds.isEmpty()) {
            return false;
        }
        for (Rectangle screenBounds : allScreenBounds = ScreenUtil.getAllScreenBounds()) {
            Rectangle intersection = screenBounds.intersection(bounds);
            if (intersection.isEmpty()) continue;
            int sq1 = intersection.width * intersection.height;
            int sq2 = bounds.width * bounds.height;
            return (double)sq1 / (double)sq2 > 0.1;
        }
        return false;
    }

    public static Rectangle getMainScreenBounds() {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        Rectangle bounds = graphicsConfiguration.getBounds();
        ScreenUtil.applyInsets(bounds, ScreenUtil.getScreenInsets(graphicsConfiguration));
        return bounds;
    }

    private static Rectangle[] getAllScreenBounds() {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = env.getScreenDevices();
        Rectangle[] result = new Rectangle[devices.length];
        for (int i = 0; i < devices.length; ++i) {
            GraphicsDevice device = devices[i];
            GraphicsConfiguration configuration = device.getDefaultConfiguration();
            result[i] = new Rectangle(configuration.getBounds());
            ScreenUtil.applyInsets(result[i], ScreenUtil.getScreenInsets(configuration));
        }
        return result;
    }

    public static Shape getAllScreensShape() {
        Rectangle[] rectangles = ScreenUtil.getAllScreenBounds();
        Area area = new Area();
        for (Rectangle rectangle : rectangles) {
            area.add(new Area(rectangle));
        }
        return area;
    }

    public static Rectangle getScreenRectangle(@NotNull Point p) {
        Rectangle[] allScreenBounds;
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/ScreenUtil", "getScreenRectangle"));
        }
        double distance = -1.0;
        Rectangle answer = null;
        for (Rectangle rect : allScreenBounds = ScreenUtil.getAllScreenBounds()) {
            if (rect.contains(p)) {
                return rect;
            }
            double d = ScreenUtil.findNearestPointOnBorder(rect, p).distance(p.x, p.y);
            if (answer != null && !(distance > d)) continue;
            distance = d;
            answer = rect;
        }
        if (answer == null) {
            throw new IllegalStateException("It's impossible to determine target graphics environment for point (" + p.x + "," + p.y + ")");
        }
        return answer;
    }

    public static GraphicsDevice getScreenDevice(Rectangle bounds) {
        GraphicsDevice candidate = null;
        int maxIntersection = 0;
        for (GraphicsDevice device : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            GraphicsConfiguration config = device.getDefaultConfiguration();
            Rectangle rect = config.getBounds();
            Rectangle intersection = rect.intersection(bounds);
            if (intersection.isEmpty() || intersection.width * intersection.height <= maxIntersection) continue;
            maxIntersection = intersection.width * intersection.height;
            candidate = device;
        }
        return candidate;
    }

    public static boolean isStandardAddRemoveNotify(Component component) {
        JRootPane rootPane = ScreenUtil.findMainRootPane(component);
        return rootPane == null || rootPane.getClientProperty(DISPOSE_TEMPORARY) == null;
    }

    private static JRootPane findMainRootPane(Component component) {
        while (component != null) {
            Container parent = component.getParent();
            if (parent == null) {
                return component instanceof RootPaneContainer ? ((RootPaneContainer)((Object)component)).getRootPane() : null;
            }
            component = parent;
        }
        return null;
    }

    private static Rectangle applyInsets(Rectangle rect, Insets i) {
        if (i == null) {
            return rect;
        }
        return new Rectangle(rect.x + i.left, rect.y + i.top, rect.width - (i.left + i.right), rect.height - (i.top + i.bottom));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Insets getScreenInsets(GraphicsConfiguration gc) {
        if (ourInsetsCache == null) {
            return ScreenUtil.calcInsets(gc);
        }
        Map<GraphicsConfiguration, Pair<Insets, Long>> map = ourInsetsCache;
        synchronized (map) {
            Pair data = ourInsetsCache.get(gc);
            long now = System.currentTimeMillis();
            if (data == null || now > (Long)data.second + 5000L) {
                data = Pair.create((Object)ScreenUtil.calcInsets(gc), (Object)now);
                ourInsetsCache.put(gc, (Pair<Insets, Long>)data);
            }
            return (Insets)data.first;
        }
    }

    private static Insets calcInsets(GraphicsConfiguration gc) {
        if (Patches.SUN_BUG_ID_7172665 && GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices().length > 1) {
            return new Insets(0, 0, 0, 0);
        }
        return Toolkit.getDefaultToolkit().getScreenInsets(gc);
    }

    public static Rectangle getScreenRectangle(int x, int y) {
        return ScreenUtil.getScreenRectangle(new Point(x, y));
    }

    public static boolean isOutsideOnTheRightOFScreen(Rectangle rect) {
        int screenX = rect.x;
        int screenY = rect.y;
        Rectangle screen = ScreenUtil.getScreenRectangle(screenX, screenY);
        return rect.getMaxX() > screen.getMaxX();
    }

    public static void moveRectangleToFitTheScreen(Rectangle aRectangle) {
        int screenX = aRectangle.x + aRectangle.width / 2;
        int screenY = aRectangle.y + aRectangle.height / 2;
        Rectangle screen = ScreenUtil.getScreenRectangle(screenX, screenY);
        ScreenUtil.moveToFit(aRectangle, screen, null);
    }

    public static void moveToFit(Rectangle rectangle, Rectangle container, @Nullable Insets padding) {
        Insets insets = padding != null ? padding : new Insets(0, 0, 0, 0);
        Rectangle move = new Rectangle(rectangle.x - insets.left, rectangle.y - insets.top, rectangle.width + insets.left + insets.right, rectangle.height + insets.top + insets.bottom);
        if (move.getMaxX() > container.getMaxX()) {
            move.x = (int)container.getMaxX() - move.width;
        }
        if (move.getMinX() < container.getMinX()) {
            move.x = (int)container.getMinX();
        }
        if (move.getMaxY() > container.getMaxY()) {
            move.y = (int)container.getMaxY() - move.height;
        }
        if (move.getMinY() < container.getMinY()) {
            move.y = (int)container.getMinY();
        }
        rectangle.x = move.x + insets.left;
        rectangle.y = move.y + insets.right;
        rectangle.width = move.width - insets.left - insets.right;
        rectangle.height = move.height - insets.top - insets.bottom;
    }

    public static void fitToScreen(Rectangle r) {
        int yOverdraft;
        Rectangle screen = ScreenUtil.getScreenRectangle(r.x, r.y);
        int xOverdraft = r.x + r.width - screen.x - screen.width;
        if (xOverdraft > 0) {
            int shift = Math.min(xOverdraft, r.x - screen.x);
            r.x -= shift;
            if ((xOverdraft -= shift) > 0) {
                r.width -= xOverdraft;
            }
        }
        if ((yOverdraft = r.y + r.height - screen.y - screen.height) > 0) {
            int shift = Math.min(yOverdraft, r.y - screen.y);
            r.y -= shift;
            if ((yOverdraft -= shift) > 0) {
                r.height -= yOverdraft;
            }
        }
    }

    public static Point findNearestPointOnBorder(Rectangle rect, Point p) {
        Point[] variants;
        int x0 = rect.x;
        int y0 = rect.y;
        int x1 = x0 + rect.width;
        int y1 = y0 + rect.height;
        double distance = -1.0;
        Point best = null;
        for (Point variant : variants = new Point[]{new Point(p.x, y0), new Point(p.x, y1), new Point(x0, p.y), new Point(x1, p.y)}) {
            double d = variant.distance(p.x, p.y);
            if (best != null && !(distance > d)) continue;
            best = variant;
            distance = d;
        }
        assert (best != null);
        return best;
    }

    public static void cropRectangleToFitTheScreen(Rectangle rect) {
        int screenX = rect.x;
        int screenY = rect.y;
        Rectangle screen = ScreenUtil.getScreenRectangle(screenX, screenY);
        if (rect.getMaxX() > screen.getMaxX()) {
            rect.width = (int)screen.getMaxX() - rect.x;
        }
        if (rect.getMinX() < screen.getMinX()) {
            rect.x = (int)screen.getMinX();
        }
        if (rect.getMaxY() > screen.getMaxY()) {
            rect.height = (int)screen.getMaxY() - rect.y;
        }
        if (rect.getMinY() < screen.getMinY()) {
            rect.y = (int)screen.getMinY();
        }
    }

    public static boolean isMovementTowards(Point prevLocation, Point location, Rectangle bounds) {
        if (bounds == null) {
            return false;
        }
        if (prevLocation == null || prevLocation.equals(location)) {
            return true;
        }
        int dx = prevLocation.x - location.x;
        int dy = prevLocation.y - location.y;
        if (dx > 0 && bounds.x >= prevLocation.x) {
            return false;
        }
        if (dx < 0 && bounds.x + bounds.width <= prevLocation.x) {
            return false;
        }
        if (dy > 0 && bounds.y + bounds.height >= prevLocation.y) {
            return false;
        }
        if (dy < 0 && bounds.y <= prevLocation.y) {
            return false;
        }
        if (dx == 0) {
            return location.x >= bounds.x && location.x < bounds.x + bounds.width && dy > 0 ^ bounds.y > location.y;
        }
        if (dy == 0) {
            return location.y >= bounds.y && location.y < bounds.y + bounds.height && dx > 0 ^ bounds.x > location.x;
        }
        float a = (float)dy / (float)dx;
        float b = (float)location.y - a * (float)location.x;
        float crossY = a * (float)bounds.x + b;
        if (crossY >= (float)bounds.y && crossY < (float)(bounds.y + bounds.height)) {
            return true;
        }
        crossY = a * (float)(bounds.x + bounds.width) + b;
        if (crossY >= (float)bounds.y && crossY < (float)(bounds.y + bounds.height)) {
            return true;
        }
        float crossX = ((float)bounds.y - b) / a;
        if (crossX >= (float)bounds.x && crossX < (float)(bounds.x + bounds.width)) {
            return true;
        }
        crossX = ((float)(bounds.y + bounds.height) - b) / a;
        return crossX >= (float)bounds.x && crossX < (float)(bounds.x + bounds.width);
    }

    static {
        boolean useCache = SystemInfo.isXWindow && !GraphicsEnvironment.isHeadless();
        ourInsetsCache = useCache ? new WeakHashMap() : null;
    }
}

