/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.AbstractCollectionComboBoxModel;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MutableCollectionComboBoxModel<T>
extends AbstractCollectionComboBoxModel<T> {
    private List<T> myItems;

    public MutableCollectionComboBoxModel(@NotNull List<T> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/MutableCollectionComboBoxModel", "<init>"));
        }
        this(items, ContainerUtil.getFirstItem(items));
    }

    public MutableCollectionComboBoxModel(@NotNull List<T> items, @Nullable T selection) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/MutableCollectionComboBoxModel", "<init>"));
        }
        super(selection);
        this.myItems = items;
    }

    @Override
    @NotNull
    protected final List<T> getItems() {
        List<T> list = this.myItems;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/MutableCollectionComboBoxModel", "getItems"));
        }
        return list;
    }

    public void update(@NotNull List<T> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/MutableCollectionComboBoxModel", "update"));
        }
        this.myItems = items;
        super.update();
    }

    public void addItem(T item) {
        this.myItems.add(item);
        this.fireIntervalAdded(this, this.myItems.size() - 1, this.myItems.size() - 1);
        if (this.myItems.size() == 1 && this.getSelectedItem() == null && item != null) {
            this.setSelectedItem(item);
        }
    }
}

