/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public abstract class HtmlListCellRenderer<T>
extends ListCellRendererWrapper<T> {
    private StringBuilder myText;

    public HtmlListCellRenderer() {
    }

    public HtmlListCellRenderer(ListCellRenderer listCellRenderer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void customize(JList list, T value, int index, boolean selected, boolean hasFocus) {
        this.myText = new StringBuilder();
        try {
            this.doCustomize(list, value, index, selected, hasFocus);
            if (this.myText.length() == 0) {
                this.setText(null);
            } else {
                this.myText.insert(0, "<html><body style=\"white-space:nowrap\">");
                this.myText.append("</body></html>");
                this.setText(this.myText.toString());
            }
        }
        finally {
            this.myText = null;
        }
    }

    protected abstract void doCustomize(JList var1, T var2, int var3, boolean var4, boolean var5);

    public void append(@NotNull String fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/HtmlListCellRenderer", "append"));
        }
        this.append(fragment, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/HtmlListCellRenderer", "append"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ui/HtmlListCellRenderer", "append"));
        }
        SimpleColoredComponent.formatText(this.myText, fragment, attributes);
    }

    public void appendLink(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, @NotNull String url) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/HtmlListCellRenderer", "appendLink"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ui/HtmlListCellRenderer", "appendLink"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ui/HtmlListCellRenderer", "appendLink"));
        }
        SimpleColoredComponent.formatLink(this.myText, fragment, attributes, url);
    }

    public void append(@NotNull SimpleColoredText text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/HtmlListCellRenderer", "append"));
        }
        int length = text.getTexts().size();
        for (int i = 0; i < length; ++i) {
            String fragment = text.getTexts().get(i);
            SimpleTextAttributes attributes = text.getAttributes().get(i);
            this.append(fragment, attributes);
        }
    }
}

