/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.ui.AbstractFieldPanel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.InsertPathAction;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FieldPanel
extends AbstractFieldPanel {
    private final JTextField myTextField;

    public FieldPanel() {
        this(new JTextField(30));
    }

    protected FieldPanel(JTextField textField) {
        super(textField);
        this.myTextField = textField;
        this.createComponent();
    }

    public FieldPanel(String labelText, String viewerDialogTitle, ActionListener browseButtonActionListener, Runnable documentListener) {
        this(new JTextField(30), labelText, viewerDialogTitle, browseButtonActionListener, documentListener);
    }

    public FieldPanel(JTextField textField, String labelText, String viewerDialogTitle, ActionListener browseButtonActionListener, Runnable documentListener) {
        super(textField, labelText, viewerDialogTitle, browseButtonActionListener, documentListener);
        this.myTextField = textField;
        this.createComponent();
    }

    @Override
    public void createComponent() {
        super.createComponent();
        ComponentWithBrowseButton.MyDoClickAction doClickAction = this.getDoClickAction();
        if (doClickAction != null) {
            doClickAction.registerShortcut(this.getTextField());
        }
        this.myTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent event) {
                if (FieldPanel.this.getChangeListener() != null) {
                    FieldPanel.this.getChangeListener().run();
                }
            }
        });
    }

    @Override
    public String getText() {
        return this.myTextField.getText();
    }

    @Override
    public void setText(String text) {
        this.myTextField.setText(text);
    }

    public JTextField getTextField() {
        return this.myTextField;
    }

    public static FieldPanel create(String labelText, String viewerDialogTitle) {
        return FieldPanel.create(labelText, viewerDialogTitle, null, null);
    }

    public static FieldPanel withPaths(String labelText, String viewerDialogTitle) {
        return FieldPanel.withPaths(labelText, viewerDialogTitle, null, null);
    }

    public static FieldPanel withPaths(String labelText, String viewerDialogTitle, ActionListener browseButtonActionListener, Runnable documentListener) {
        FieldPanel fieldPanel = FieldPanel.create(labelText, viewerDialogTitle, browseButtonActionListener, documentListener);
        InsertPathAction.addTo(fieldPanel.myTextField);
        return fieldPanel;
    }

    private static FieldPanel create(String labelText, String viewerDialogTitle, ActionListener browseButtonActionListener, Runnable documentListener) {
        return new FieldPanel(labelText, viewerDialogTitle, browseButtonActionListener, documentListener);
    }

    public void setEditable(boolean editable) {
        this.myTextField.setEditable(editable);
        for (JButton button : this.myButtons) {
            button.setEnabled(editable);
        }
    }
}

