/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.ExpandedItemRendererComponentWrapper;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ExpandedItemListCellRendererWrapper
implements ListCellRenderer {
    @NotNull
    private final ListCellRenderer myWrappee;
    @NotNull
    private final ExpandableItemsHandler<Integer> myHandler;

    public ExpandedItemListCellRendererWrapper(@NotNull ListCellRenderer wrappee, @NotNull ExpandableItemsHandler<Integer> handler) {
        if (wrappee == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/ExpandedItemListCellRendererWrapper", "<init>"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ui/ExpandedItemListCellRendererWrapper", "<init>"));
        }
        this.myWrappee = wrappee;
        this.myHandler = handler;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component result = this.myWrappee.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (this.myHandler.getExpandedItems().contains(index)) {
            result = new ExpandedItemRendererComponentWrapper(result);
        }
        return result;
    }

    @NotNull
    public ListCellRenderer getWrappee() {
        ListCellRenderer listCellRenderer = this.myWrappee;
        if (listCellRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/ExpandedItemListCellRendererWrapper", "getWrappee"));
        }
        return listCellRenderer;
    }
}

